<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Subscription extends Model
{
	// Add fillable fields if needed
	protected $guarded = [];

	public function user(): BelongsTo
	{
		return $this->belongsTo(User::class);
	}

	public function appUser(): BelongsTo
	{
		return $this->belongsTo(AppUser::class, 'user_id');
	}

	public function plan(): BelongsTo
	{
		return $this->belongsTo(SubscriptionPlan::class, 'plan_id');
	}
}
