<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Post extends Model
{
    use HasFactory;

    protected $fillable = [
        'app_user_id',
        'content',
        'content_html',
        'status',
        'category',
        'platforms',
        'published_at',
        'scheduled_at',
    ];

    protected $attributes = [
        'status' => 'draft',
        'category' => 'General',
    ];

    protected function casts(): array
    {
        return [
            'platforms' => 'array',
            'published_at' => 'datetime',
            'scheduled_at' => 'datetime',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(AppUser::class, 'app_user_id');
    }

    public function media(): HasMany
    {
        return $this->hasMany(PostMedia::class)->orderBy('display_order');
    }
}
