<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;
    protected $table = 'categories';
    protected $fillable = [
        'category_name',
        'is_default',
        'user_id',
    ];

    protected $casts = [
        'is_default' => 'integer',
        'user_id' => 'integer',
    ];

    protected $attributes = [
        'is_default' => 1,
        'user_id' => null,
    ];
}

