<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Laravel\Sanctum\HasApiTokens;
use App\Models\Subscription;

class AppUser extends Authenticatable
{
    use HasFactory, HasApiTokens;

    protected $table = 'app_users';

    protected $fillable = [
        'name',
        'email',
        'password',
        'timezone',
        'status',
        // Company/Shop Information
        'company_name',
        'company_description',
        // Contact Information
        'phone',
        'website',
        'address',
        'city',
        'state',
        'country',
        'postal_code',
        // Social Media & Marketing
        'social_media_handles',
        'preferred_social_platforms',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Ensure default attributes for new models.
     */
    protected $attributes = [
        'timezone' => 'UTC',
        'status' => 'inactive', // Default to inactive until email verified
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'social_media_handles' => 'array',
            'preferred_social_platforms' => 'array',
        ];
    }

    /**
     * Current active subscription relationship.
     */
    public function subscription(): HasOne
    {
        return $this->hasOne(Subscription::class, 'user_id')->latestOfMany();
    }
}

