<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class VerifyEmailMail extends Mailable
{
    use Queueable, SerializesModels;

    public $verificationUrl;
    public $userName;

    /**
     * Create a new message instance.
     *
     * @param string $verificationUrl
     * @param string $userName
     */
    public function __construct($verificationUrl, $userName = null)
    {
        $this->verificationUrl = $verificationUrl;
        $this->userName = $userName;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Verify Your Email Address')
                    ->view('emails.verify-email')
                    ->with([
                        'verificationUrl' => $this->verificationUrl,
                        'userName' => $this->userName,
                    ]);
    }
}

