<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Subscription;
use App\Models\SubscriptionPlan;
use App\Models\User;
use Illuminate\Http\Request;

class SubscriptionController extends Controller
{
    public function show(User $user)
    {
        $subscription = Subscription::with('plan')->where('user_id', $user->id)->latest()->first();
        return response()->json([
            'subscription' => $subscription,
            'plans' => SubscriptionPlan::orderBy('price')->get(['id', 'name', 'price', 'duration'])
        ]);
    }

    public function store(Request $request, User $user)
    {
        $data = $request->validate([
            'plan_id' => 'required|exists:subscription_plans,id',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
            'status' => 'required|in:active,expired,cancelled',
            'payment_method' => 'required|in:stripe,paypal,manual',
            'transaction_id' => 'nullable|string|max:150',
        ]);

        $data['user_id'] = $user->id;

        Subscription::create($data);

        return redirect()->route('users.index')->with('success', 'Subscription saved successfully.');
    }

    public function update(Request $request, User $user, Subscription $subscription)
    {
        $this->authorize('update', $user); // optional: if you have policies
        $data = $request->validate([
            'plan_id' => 'required|exists:subscription_plans,id',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
            'status' => 'required|in:active,expired,cancelled',
            'payment_method' => 'required|in:stripe,paypal,manual',
            'transaction_id' => 'nullable|string|max:150',
        ]);

        $subscription->update($data);

        return redirect()->route('users.index')->with('success', 'Subscription updated successfully.');
    }
}


