<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\SubscriptionPlan;
use App\Models\Subscription;

class DashboardController extends Controller
{
    /**
     * Show the admin dashboard with some simple stats.
     */
    public function index()
    {
        $userCount = User::count();
        $planCount = SubscriptionPlan::count();
        $activeSubscriptions = Subscription::where('status', 'active')->count();

        return view('admin.dashboard', compact('userCount', 'planCount', 'activeSubscriptions'));
    }
}

