<?php

namespace App\Console\Commands;

use App\Jobs\PublishScheduledPosts;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Bus;

class PublishScheduledPostsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'posts:publish-scheduled {--sync : Run synchronously instead of queuing}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Publish scheduled posts that are due';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        try {
            if ($this->option('sync')) {
                // Run synchronously - simple and reliable
                $job = new PublishScheduledPosts();
                $job->handle();
            } else {
                // Dispatch to queue (for advanced setups)
                dispatch(new PublishScheduledPosts());
            }
            
            return Command::SUCCESS;
        } catch (\Exception $e) {
            \Log::error('PublishScheduledPostsCommand failed: ' . $e->getMessage(), [
                'trace' => $e->getTraceAsString(),
            ]);
            return Command::FAILURE;
        }
    }
}

