# Two-Step Registration Flow for Indian Shops/Companies

This document explains the complete registration flow designed specifically for Indian shops and companies.

## Overview

The registration process is divided into **3 steps**:

1. **Step 1: Quick Registration** - Minimal information (name, email, password, phone)
2. **Step 2: Email Activation** - Verify email to activate account
3. **Step 3: Profile Completion** - Add company/shop details for AI content optimization

---

## Step 1: Quick Registration

### Endpoint

```
POST /api/register
```

### Required Fields (Minimal)

| Field                   | Type   | Required | Description                                 |
| ----------------------- | ------ | -------- | ------------------------------------------- |
| `name`                  | string | ✅ Yes   | Owner/Manager name                          |
| `email`                 | string | ✅ Yes   | Email address (must be unique)              |
| `password`              | string | ✅ Yes   | Password (minimum 6 characters)             |
| `password_confirmation` | string | ✅ Yes   | Must match password                         |
| `phone`                 | string | ✅ Yes   | Phone number (must be unique, max 15 chars) |

### Request Example

```json
{
    "name": "Rajesh Kumar",
    "email": "rajesh@example.com",
    "password": "securepass123",
    "password_confirmation": "securepass123",
    "phone": "+919876543210"
}
```

### Response (Success)

```json
{
    "success": true,
    "message": "Registration successful! Please check your email to activate your account.",
    "data": {
        "user": {
            "id": 1,
            "name": "Rajesh Kumar",
            "email": "rajesh@example.com",
            "phone": "+919876543210",
            "status": "inactive",
            "email_verified": false
        },
        "debug": {
            "verification_token": "abc123...",
            "verification_url": "http://localhost:3000/verify-email?token=abc123...&email=rajesh%40example.com",
            "note": "This debug field should be removed in production."
        }
    }
}
```

### What Happens

1. ✅ User account is created with `status: 'inactive'`
2. ✅ Email verification token is generated
3. ✅ Verification email is sent (in production)
4. ⚠️ User **cannot login** until email is verified

---

## Step 2: Email Activation

### Email Link Format

The user receives an email with a link:

```
http://your-frontend.com/verify-email?token=abc123...&email=rajesh@example.com
```

### Frontend Flow

1. User clicks email link (GET request)
2. Frontend page opens: `/verify-email`
3. Frontend extracts `token` and `email` from URL
4. Frontend makes POST request to API

### Endpoint

```
POST /api/verify-email
```

### Request Body

```json
{
    "email": "rajesh@example.com",
    "token": "abc123..."
}
```

### Response (Success)

```json
{
    "success": true,
    "message": "Email verified successfully! Your account is now activated. Please complete your profile to get started.",
    "data": {
        "user": {
            "id": 1,
            "name": "Rajesh Kumar",
            "email": "rajesh@example.com",
            "email_verified": true,
            "status": "active",
            "profile_completed": false
        }
    }
}
```

### What Happens

1. ✅ Email is verified (`email_verified_at` is set)
2. ✅ Account status changes to `'active'`
3. ✅ User can now login
4. ⚠️ User should complete profile for full functionality

### Error Responses

**Invalid/Expired Token:**

```json
{
    "success": false,
    "message": "Invalid or expired verification link.",
    "errors": {
        "token": ["This verification link is invalid or has expired."]
    }
}
```

**Token Expired (24 hours):**

```json
{
    "success": false,
    "message": "This verification link has expired. Please request a new one.",
    "errors": {
        "token": [
            "This verification link has expired. Please register again or contact support."
        ]
    }
}
```

---

## Step 3: Profile Completion

### Endpoint

```
POST /api/complete-profile
```

**Authentication Required:** ✅ Yes (Bearer token)

### Required Fields

| Field              | Type   | Required | Description                                              |
| ------------------ | ------ | -------- | -------------------------------------------------------- |
| `company_name`     | string | ✅ Yes   | Name of your shop/company                                |

### Optional Fields

| Field                        | Type   | Description                                                                                                                                |
| ---------------------------- | ------ | ------------------------------------------------------------------------------------------------------------------------------------------ |
| `company_description`        | string | Brief description (max 1000 chars)                                                                                                         |
| `website`                    | url    | Company website                                                                                                                            |
| `address`                     | string | Street address                                                                                                                             |
| `city`                        | string | City                                                                                                                                       |
| `state`                       | string | State                                                                                                                                      |
| `country`                     | string | Default: "India"                                                                                                                           |
| `postal_code`                 | string | PIN code                                                                                                                                   |
| `target_audience`             | string | Description of target audience (for AI)                                                                                                    |
| `social_media_handles`        | object | Existing social media handles                                                                                                              |
| `preferred_social_platforms` | array  | Platforms to post to: `facebook`, `instagram`, `twitter`, `linkedin`, `youtube`, `tiktok`, `pinterest`                                     |

### Request Example

```json
{
    "company_name": "Rajesh Fashion Store",
    "company_description": "A trendy fashion store offering latest trends for men and women",
    "address": "123 MG Road",
    "city": "Mumbai",
    "state": "Maharashtra",
    "country": "India",
    "postal_code": "400001",
    "target_audience": "Young professionals and college students aged 18-30",
    "preferred_social_platforms": ["facebook", "instagram", "whatsapp"]
}
```

### Response (Success)

```json
{
    "success": true,
    "message": "Profile completed successfully! You can now start posting to social media platforms.",
    "data": {
        "user": {
            "id": 1,
            "name": "Rajesh Kumar",
            "email": "rajesh@example.com",
            "company": {
                "company_name": "Rajesh Fashion Store",
                "preferred_platforms": ["facebook", "instagram", "whatsapp"]
            }
        }
    }
}
```

### Error Response (Not Verified)

```json
{
    "success": false,
    "message": "Please verify your email address first."
}
```

---

## Complete Flow Diagram

```
┌─────────────────────────────────────────────────────────────┐
│ Step 1: Quick Registration                                  │
│ POST /api/register                                           │
│ Body: { name, email, password, password_confirmation, phone }│
│ ↓                                                            │
│ Account created with status: 'inactive'                     │
│ Verification email sent                                      │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│ Step 2: Email Activation                                    │
│ User clicks email link                                       │
│ GET /verify-email?token=xxx&email=xxx                        │
│ ↓                                                            │
│ Frontend makes:                                              │
│ POST /api/verify-email                                       │
│ Body: { email, token }                                       │
│ ↓                                                            │
│ Account activated: status → 'active'                       │
│ email_verified_at → current timestamp                        │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│ Step 3: Profile Completion                                   │
│ User logs in (can now login)                                 │
│ ↓                                                            │
│ POST /api/complete-profile (with Bearer token)               │
│ Body: { company_name, company_description, ... }            │
│ ↓                                                            │
│ Profile completed! Ready to use platform                    │
└─────────────────────────────────────────────────────────────┘
```

---

## Login After Registration

### Endpoint

```
POST /api/login
```

### Important: Login Requirements

1. ✅ Email must be verified (`email_verified_at` is not null)
2. ✅ Account status must be `'active'`

### Login Before Email Verification

**Request:**

```json
{
    "email": "rajesh@example.com",
    "password": "securepass123"
}
```

**Response (Error):**

```json
{
    "success": false,
    "message": "Please verify your email address before logging in. Check your inbox for the activation link.",
    "errors": {
        "email": [
            "Email verification required. Please check your inbox for the activation link."
        ]
    }
}
```

### Login After Email Verification

**Response (Success):**

```json
{
    "success": true,
    "message": "Login successful.",
    "data": {
        "token": "1|abc123...",
        "token_expires_at": "2025-01-28T10:30:00Z",
        "user": {
            "id": 1,
            "name": "Rajesh Kumar",
            "email": "rajesh@example.com",
            "email_verified": true,
            "status": "active"
        }
    }
}
```

---

## Postman Testing Guide

### Step 1: Register

```http
POST http://localhost:8000/api/register
Content-Type: application/json

{
  "name": "Rajesh Kumar",
  "email": "rajesh@test.com",
  "password": "password123",
  "password_confirmation": "password123",
  "phone": "+919876543210"
}
```

**Copy the `verification_token` from response**

### Step 2: Verify Email

```http
POST http://localhost:8000/api/verify-email
Content-Type: application/json

{
  "email": "rajesh@test.com",
  "token": "paste_verification_token_here"
}
```

### Step 3: Login

```http
POST http://localhost:8000/api/login
Content-Type: application/json

{
  "email": "rajesh@test.com",
  "password": "password123"
}
```

**Copy the `token` from response**

### Step 4: Complete Profile

```http
POST http://localhost:8000/api/complete-profile
Content-Type: application/json
Authorization: Bearer paste_token_here

{
  "company_name": "Rajesh Fashion Store",
  "company_description": "A trendy fashion store offering latest trends for men and women",
  "city": "Mumbai",
  "state": "Maharashtra",
  "country": "India",
  "preferred_social_platforms": ["facebook", "instagram"]
}
```

---

## Key Points for Indian Shops

1. **Phone Number**: Required and unique - important for Indian market
2. **Country Default**: Automatically set to "India" if not provided
3. **Company Description**: Provide detailed description for better AI content optimization
4. **State/City**: Important for location-based content

---

## Security Features

1. ✅ **Email Verification Required**: Cannot login without verifying email
2. ✅ **Token Expiration**: Verification tokens expire after 24 hours
3. ✅ **Unique Phone**: Phone numbers must be unique
4. ✅ **Password Confirmation**: Required during registration
5. ✅ **Status Check**: Account must be active to login

---

## Next Steps After Profile Completion

1. **Connect Social Media**: Link existing social media accounts
2. **Create Content**: Use AI-powered content creator
3. **Schedule Posts**: Set up automated posting
4. **Analyze Performance**: Track engagement across platforms

---

## Troubleshooting

### Issue: "Email verification required"

**Solution**: Check your email inbox and click the activation link

### Issue: "Verification link expired"

**Solution**: Register again or contact support

### Issue: "Phone number already registered"

**Solution**: Use a different phone number or try logging in

### Issue: "Account is not active"

**Solution**: Verify your email first, then try logging in

---

## Migration

Run the migration to add the phone field:

```bash
php artisan migrate
```

This will add the `phone` field to the `app_users` table.
