# Which Method to Use? Simple Answer

## 🎯 Quick Answer

### **Development: Use Synchronous (--sync)**

✅ **BEST for Development**

-   Simple - no queue worker needed
-   Easy debugging
-   Perfect for local testing

### **Production: Use Queue**

✅ **BEST for Production**

-   More reliable
-   Better performance
-   Handles failures better

---

## ⚡ Good News!

**The system is now AUTOMATIC!**

It automatically chooses the right method based on your `APP_ENV`:

-   `APP_ENV=local` → Uses **Synchronous** (--sync)
-   `APP_ENV=production` → Uses **Queue**

**You don't need to change anything manually!**

---

## 📋 What You Need to Do

### For Development:

1. Make sure `.env` has: `APP_ENV=local`
2. Run: `php artisan migrate`
3. Set up scheduler (cron or manual)
4. **Done!** No queue worker needed.

### For Production:

1. Make sure `.env` has: `APP_ENV=production`
2. Make sure `.env` has: `QUEUE_CONNECTION=database`
3. Run: `php artisan migrate`
4. Start queue worker: `php artisan queue:work` (or use Supervisor)
5. Set up scheduler (cron)
6. **Done!**

---

## 🔍 How to Check Which Method is Active

### Check Your Environment

```bash
php artisan tinker
>>> config('app.env')
```

### Test the Command

```bash
# Development mode (should show "Running synchronously...")
php artisan posts:publish-scheduled

# Production mode (should show "Dispatching to queue...")
php artisan posts:publish-scheduled
```

---

## 📊 Simple Comparison

|                  | Development (Sync) | Production (Queue) |
| ---------------- | ------------------ | ------------------ |
| **Setup**        | ⭐ Easy            | ⭐⭐ Medium        |
| **Queue Worker** | ❌ Not needed      | ✅ Required        |
| **Best For**     | Local testing      | Live server        |

---

## ✅ Final Answer

**Use Synchronous for Development**  
**Use Queue for Production**

**But you don't need to choose - it's automatic!** Just set `APP_ENV` correctly and the system handles everything.

---

See `SCHEDULED_POSTS_ENVIRONMENT_SETUP.md` for detailed setup instructions.
