# Scheduled Posts - Automatic Setup (Simple)

## ✅ What's Already Done

The system is **already configured** to automatically publish scheduled posts. No complex setup needed!

---

## 🚀 Quick Setup (2 Steps Only)

### Step 1: Run Migration

```bash
php artisan migrate
```

### Step 2: Set Up Scheduler

**Linux/Mac:**

```bash
crontab -e
# Add this one line:
* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1
```

**Windows:**
Run this in PowerShell (keep it running):

```powershell
while ($true) {
    php artisan schedule:run
    Start-Sleep -Seconds 60
}
```

**That's it!** Posts will publish automatically every minute.

---

## 🎯 How It Works

1. **Every minute**, Laravel scheduler runs automatically
2. **Checks** for posts where `scheduled_at <= NOW()`
3. **Publishes** them automatically (status: `'scheduled'` → `'posted'`)

**No queue worker needed. No complex setup. Just works!**

---

## 🧪 Test It

### 1. Create a Scheduled Post

```bash
PUT /api/posts/1/publish
{
  "scheduled_at": "2025-01-23T15:05:00Z"  # 5 minutes from now
}
```

### 2. Wait or Run Manually

```bash
# Run manually to test immediately
php artisan posts:publish-scheduled --sync
```

### 3. Check Result

The post will automatically change:

-   `status`: `'scheduled'` → `'posted'`
-   `published_at`: Set to the scheduled time
-   `scheduled_at`: Cleared (set to null)

---

## ✅ That's All!

**The system is already configured to work automatically.**

Just:

1. Run migration
2. Set up cron (or run manually for testing)
3. Done!

**No queue worker. No complex configuration. Just works automatically!**

---

## 📝 Notes

-   Runs every minute automatically
-   Uses synchronous mode (simple, reliable)
-   No queue worker needed
-   All posts with `scheduled_at <= NOW()` are published automatically
-   Logs everything to `storage/logs/laravel.log`

---

**It's that simple!** 🎉
