# Quick Start - Admin Login

## Setup Instructions

### 1. Install Dependencies (if not already done)

```bash
npm install
```

### 2. Build Assets

For development:
```bash
npm run dev
```

For production:
```bash
npm run build
```

### 3. Access the Login Page

Navigate to:
```
http://localhost:8000/admin/login
```

Or if using Valet/Herd:
```
http://social-platform.test/admin/login
```

## Testing the Login

### Create an Admin User

You can create an admin user using Laravel Tinker:

```bash
php artisan tinker
```

Then run:
```php
User::create([
    'name' => 'Admin User',
    'email' => 'admin@example.com',
    'password' => bcrypt('password123'),
    'role' => 'admin'
]);
```

### Login Credentials

Use the credentials you just created:
- **Email**: admin@example.com
- **Password**: password123

## What You'll See

The login page features:
- Professional two-column layout
- Login form on the left side
- Promotional content on the right side (desktop only)
- Email and password fields with icons
- "Remember me" checkbox
- "Forgot password" link
- Google sign-in button (UI only - needs implementation)
- Sign-up link
- Fully responsive design
- Dark mode support (add `dark` class to `<html>` to test)

## After Login

Upon successful login, you'll be redirected to:
```
/admin/dashboard
```

Make sure this route and controller exist and are properly configured.

## Customization Tips

1. **Change Logo/Branding**: Edit `resources/views/admin/login.blade.php` line 17
2. **Modify Colors**: Update `tailwind.config.js` primary colors
3. **Update Welcome Text**: Edit the heading and description in the login form
4. **Change Right Side Content**: Modify the promotional section in the login view

## Troubleshooting

### Assets not loading
- Run `npm run dev` or `npm run build`
- Clear browser cache
- Check Vite is running for development

### Login not working
- Ensure user has `role = 'admin'`
- Check database connection
- Verify session configuration

### Redirects not working
- Make sure `admin.dashboard` route exists
- Check middleware configuration
- Verify user authentication

## Next Steps

1. Implement forgot password functionality
2. Create admin dashboard layout
3. Add social authentication
4. Implement dark mode toggle
5. Create more admin pages with TailAdmin styling

