# Posts API - Quick Reference

**For Next.js Frontend Developers**

---

## 🔑 Authentication

All endpoints require:

```
Authorization: Bearer {token}
```

---

## 📝 Posts Endpoints

### Create Draft Post

```
POST /api/posts
Content-Type: multipart/form-data

Body:
- content (required)
- content_html (optional)
- category (optional, default: "General")
- platforms (optional, JSON array)
- files[] (optional, max 10MB each)
```

### Get All Posts

```
GET /api/posts?status=draft&page=1&per_page=20&sort=updated_at&order=desc

Query Params:
- status: draft | posted
- category: string
- page: number
- per_page: number (max 100)
- sort: created_at | updated_at | published_at
- order: asc | desc
```

### Get Single Post

```
GET /api/posts/{id}
```

### Update Draft Post

```
PUT /api/posts/{id}
Content-Type: multipart/form-data

Body:
- content (optional)
- content_html (optional)
- category (optional)
- platforms (optional)
- files[] (optional, new files)
- remove_media_ids (optional, array of IDs)
```

### Publish Post

```
PUT /api/posts/{id}/publish
Content-Type: application/json

Body (optional):
{
  "platforms": ["facebook", "twitter"]
}
```

### Delete Post

```
DELETE /api/posts/{id}
```

---

## 🖼️ Media Endpoints

### Upload Media

```
POST /api/posts/{id}/media
Content-Type: multipart/form-data

Body:
- files[] (required)
- display_order (optional)
```

### Delete Media

```
DELETE /api/posts/{id}/media/{media_id}
```

---

## ✅ Status Rules

| Action       | Draft | Posted |
| ------------ | ----- | ------ |
| View         | ✅    | ✅     |
| Edit         | ✅    | ❌     |
| Delete       | ✅    | ✅     |
| Publish      | ✅    | ❌     |
| Add Media    | ✅    | ❌     |
| Remove Media | ✅    | ❌     |

---

## 📋 Response Format

**Success:**

```json
{
  "success": true,
  "message": "...",
  "data": { ... }
}
```

**Error:**

```json
{
  "success": false,
  "error": "Error message",
  "errors": { ... }
}
```

---

## 🔢 Status Codes

-   `200` - Success (GET, PUT, DELETE)
-   `201` - Created (POST)
-   `400` - Bad Request
-   `401` - Unauthorized
-   `403` - Forbidden
-   `404` - Not Found
-   `422` - Validation Error
-   `500` - Server Error

---

## 💡 Quick Tips

1. **`app_user_id`** is automatically set from auth token - don't send it
2. **`platforms`** can be JSON string or array
3. **File max size**: 10MB per file
4. **Only drafts** can be edited or have media added/removed
5. **Pagination default**: 20 items per page

---

**Full Documentation:** See `POSTS_API_DOCUMENTATION.md`
