# Postman Testing Guide - Forgot Password & Reset Password

This guide explains how to test the Forgot Password and Reset Password endpoints in Postman.

## Prerequisites

1. Make sure your Laravel application is running (e.g., `php artisan serve`)
2. Your base URL should be something like: `http://localhost:8000` or `http://127.0.0.1:8000`
3. The API routes are prefixed with `/api`

---

## 1. Forgot Password Endpoint

### Endpoint Details

-   **Method**: `POST`
-   **URL**: `http://localhost:8000/api/forgot-password`
-   **Authentication**: Not required (public endpoint)

### Step-by-Step Instructions

1. **Open Postman** and create a new request

2. **Set the HTTP Method**:

    - Select `POST` from the dropdown

3. **Enter the URL**:

    ```
    http://localhost:8000/api/forgot-password
    ```

    (Replace `localhost:8000` with your actual server URL if different)

4. **Set Headers**:

    - Click on the **Headers** tab
    - Add the following header:
        - **Key**: `Content-Type`
        - **Value**: `application/json`
        - **Accept**: `application/json` (optional but recommended)

5. **Set Request Body**:

    - Click on the **Body** tab
    - Select **raw**
    - Choose **JSON** from the dropdown (on the right)
    - Enter the following JSON:

    ```json
    {
        "email": "user@example.com"
    }
    ```

    Replace `user@example.com` with a valid email address that exists in your database.

6. **Send the Request**:
    - Click the **Send** button

### Expected Response (Success - Valid Email)

**Status Code**: `200 OK`

**Response Body**:

```json
{
    "success": true,
    "message": "Password reset link has been sent to your email address. Please check your inbox.",
    "debug": {
        "token": "abc123def456ghi789...",
        "reset_url": "http://localhost:3000/reset-password?token=abc123...&email=user@example.com",
        "note": "This debug field should be removed in production. Email link opens frontend page, which then POSTs to /api/reset-password"
    }
}
```

**Important Notes**:

-   The `debug` field contains the reset token - **copy this token** as you'll need it for the reset password endpoint
-   The `reset_url` points to your **frontend** (Next.js), not the API endpoint
-   The `debug` field is only available in development mode - remove it in production

### Expected Response (Error - Email Not Found)

**Status Code**: `404 Not Found`

**Response Body** (if email doesn't exist):

```json
{
    "success": false,
    "message": "No account found with this email address. Please check your email and try again.",
    "errors": {
        "email": ["This email address is not registered in our system."]
    }
}
```

### Expected Response (Validation Error)

**Status Code**: `422 Unprocessable Entity`

**Response Body** (if email is invalid):

```json
{
    "message": "The given data was invalid.",
    "errors": {
        "email": ["Please enter a valid email address."]
    }
}
```

---

## 2. Reset Password Endpoint

### Endpoint Details

-   **Method**: `POST`
-   **URL**: `http://localhost:8000/api/reset-password`
-   **Authentication**: Not required (public endpoint)

### Step-by-Step Instructions

1. **First, get a reset token** by calling the Forgot Password endpoint (see above)

2. **Create a new request** in Postman

3. **Set the HTTP Method**:

    - Select `POST` from the dropdown

4. **Enter the URL**:

    ```
    http://localhost:8000/api/reset-password
    ```

5. **Set Headers**:

    - Click on the **Headers** tab
    - Add the following header:
        - **Key**: `Content-Type`
        - **Value**: `application/json`
        - **Accept**: `application/json` (optional but recommended)

6. **Set Request Body**:

    - Click on the **Body** tab
    - Select **raw**
    - Choose **JSON** from the dropdown
    - Enter the following JSON:

    ```json
    {
        "email": "user@example.com",
        "token": "paste_the_token_from_forgot_password_response_here",
        "password": "newpassword123",
        "password_confirmation": "newpassword123"
    }
    ```

    **Important**:

    - Replace `user@example.com` with the same email you used in the forgot password request
    - Replace `paste_the_token_from_forgot_password_response_here` with the actual token from the `debug.token` field in the forgot password response
    - Both `password` and `password_confirmation` must match exactly
    - Password must be at least 6 characters long

7. **Send the Request**:
    - Click the **Send** button

### Expected Response (Success)

**Status Code**: `200 OK`

**Response Body**:

```json
{
    "success": true,
    "message": "Your password has been reset successfully. You can now login with your new password."
}
```

### Expected Response (Error - Invalid Token)

**Status Code**: `422 Unprocessable Entity`

**Response Body**:

```json
{
    "success": false,
    "message": "Invalid or expired reset token.",
    "errors": {
        "token": ["This password reset token is invalid or has expired."]
    }
}
```

### Expected Response (Error - Expired Token)

**Status Code**: `422 Unprocessable Entity`

**Response Body**:

```json
{
    "success": false,
    "message": "This password reset token has expired. Please request a new one.",
    "errors": {
        "token": [
            "This password reset token has expired. Please request a new password reset link."
        ]
    }
}
```

### Expected Response (Validation Error)

**Status Code**: `422 Unprocessable Entity`

**Response Body** (if passwords don't match):

```json
{
    "message": "The given data was invalid.",
    "errors": {
        "password": [
            "Password confirmation does not match. Please make sure both password fields are identical."
        ]
    }
}
```

**Response Body** (if password is too short):

```json
{
    "message": "The given data was invalid.",
    "errors": {
        "password": ["Password must be at least 6 characters."]
    }
}
```

---

## Complete Testing Workflow

### Step 1: Request Password Reset

1. Call `POST /api/forgot-password` with a valid email
2. Copy the `token` from the `debug.token` field in the response

### Step 2: Reset Password

1. Call `POST /api/reset-password` with:
    - The same email from Step 1
    - The token from Step 1
    - New password and password confirmation

### Step 3: Verify

1. Try logging in with the new password using the login endpoint

---

## Postman Collection Example

You can create a Postman Collection with these two requests:

### Request 1: Forgot Password

```
POST http://localhost:8000/api/forgot-password
Headers:
  Content-Type: application/json
Body (raw JSON):
{
    "email": "test@example.com"
}
```

### Request 2: Reset Password

```
POST http://localhost:8000/api/reset-password
Headers:
  Content-Type: application/json
Body (raw JSON):
{
    "email": "test@example.com",
    "token": "{{reset_token}}",
    "password": "newpassword123",
    "password_confirmation": "newpassword123"
}
```

**Tip**: You can use Postman variables to store the token from the first request and use it in the second request automatically.

---

## Troubleshooting

### Issue: "Connection refused" or "Could not get response"

-   **Solution**: Make sure your Laravel server is running (`php artisan serve`)

### Issue: "404 Not Found"

-   **Solution**: Check that your URL includes `/api` prefix: `http://localhost:8000/api/forgot-password`

### Issue: "Token invalid or expired"

-   **Solution**:
    -   Make sure you're using the token from the most recent forgot password request
    -   Tokens expire after 60 minutes
    -   Request a new token if it has expired

### Issue: "Password confirmation does not match"

-   **Solution**: Ensure `password` and `password_confirmation` fields have exactly the same value

### Issue: No `debug` field in response

-   **Solution**: The `debug` field is only available in development. Check your `.env` file - `APP_DEBUG` should be `true`

---

## Security Notes

1. **In Production**: The `debug` field should be removed from the forgot password response
2. **Token Expiration**: Reset tokens expire after 60 minutes
3. **Token Usage**: Each token can only be used once
4. **Email Privacy**: The API doesn't reveal whether an email exists in the system (security best practice)
