# Company/Shop Registration Guide

This guide explains the enhanced registration system for companies and shops using the social media marketing platform.

## Overview

The registration system now collects comprehensive company/shop information to enable:

-   **AI-Powered Content Optimization**: Uses company name and description to improve social media content
-   **Multi-Platform Posting**: One-click posting to Facebook, Instagram, Twitter, LinkedIn, YouTube, TikTok, and Pinterest
-   **Targeted Marketing**: Better content suggestions based on company description and target audience

---

## Registration Fields

### 1. Basic User Information (Required)

| Field      | Type   | Required | Description                     |
| ---------- | ------ | -------- | ------------------------------- |
| `name`     | string | ✅ Yes   | Owner/Manager name              |
| `email`    | string | ✅ Yes   | Email address (must be unique)  |
| `password` | string | ✅ Yes   | Password (minimum 6 characters) |

### 2. Company/Shop Information (Required)

| Field                 | Type   | Required | Description                                         | AI Usage                                   |
| --------------------- | ------ | -------- | --------------------------------------------------- | ------------------------------------------ |
| `company_name`        | string | ✅ Yes   | Name of your company/shop                           | Used for personalized content generation   |
| `company_description` | text   | ❌ No    | Brief description of your business (max 1000 chars) | Used for context in AI content improvement |

### 3. Contact Information (Optional)

| Field         | Type   | Required | Description                             |
| ------------- | ------ | -------- | --------------------------------------- |
| `phone`       | string | ❌ No    | Business phone number                   |
| `website`     | string | ❌ No    | Company website URL (must be valid URL) |
| `address`     | text   | ❌ No    | Street address                          |
| `city`        | string | ❌ No    | City                                    |
| `state`       | string | ❌ No    | State/Province                          |
| `country`     | string | ❌ No    | Country                                 |
| `postal_code` | string | ❌ No    | Postal/ZIP code                         |

### 4. Social Media & Marketing (Optional but Recommended)

| Field                        | Type   | Required | Description                                         | AI Usage                                               |
| ---------------------------- | ------ | -------- | --------------------------------------------------- | ------------------------------------------------------ |
| `target_audience`            | string | ❌ No    | Description of your target audience (max 500 chars) | **Critical for AI** - helps tailor content to audience |
| `social_media_handles`       | object | ❌ No    | Existing social media account handles               | Used for account linking                               |
| `preferred_social_platforms` | array  | ❌ No    | Platforms you want to post to                       | Determines which platforms to optimize for             |

**Social Media Handles Structure:**

```json
{
    "facebook": "@yourpage",
    "instagram": "@yourhandle",
    "twitter": "@yourhandle",
    "linkedin": "company-name",
    "youtube": "@yourchannel"
}
```

**Preferred Platforms Options:**

-   `facebook`
-   `instagram`
-   `twitter`
-   `linkedin`
-   `youtube`
-   `tiktok`
-   `pinterest`

---

## API Registration Request

### Endpoint

```
POST /api/register
```

### Request Body Example

```json
{
    "name": "John Doe",
    "email": "john@example.com",
    "password": "securepassword123",

    "company_name": "Fashion Forward Boutique",
    "company_description": "A trendy boutique offering the latest fashion trends for young professionals",

    "phone": "+1-555-0123",
    "website": "https://fashionforward.com",
    "address": "123 Main Street",
    "city": "New York",
    "state": "NY",
    "country": "USA",
    "postal_code": "10001",

    "target_audience": "Young professionals aged 25-35, fashion-conscious, urban dwellers",
    "social_media_handles": {
        "facebook": "@fashionforward",
        "instagram": "@fashionforward_nyc",
        "twitter": "@fashionforward"
    },
    "preferred_social_platforms": ["facebook", "instagram", "twitter"]
}
```

### Success Response

```json
{
    "success": true,
    "message": "Company registered successfully. You can now start posting to social media platforms.",
    "data": {
        "user": {
            "id": 1,
            "name": "John Doe",
            "email": "john@example.com",
            "timezone": "UTC",
            "status": "active",
            "company": {
                "company_name": "Fashion Forward Boutique",
                "preferred_platforms": ["facebook", "instagram", "twitter"]
            }
        }
    }
}
```

---

## How AI Uses This Information

### 1. Content Optimization Based on Company Description

**Example**: If `company_description` mentions "restaurant" or "food":

-   AI suggests food photography tips
-   Optimizes captions for food-related hashtags
-   Suggests posting times when food content performs best
-   Recommends content formats (stories, reels, posts)

**Example**: If `company_description` mentions "tech" or "software":

-   AI suggests professional, technical tone
-   Optimizes for LinkedIn and Twitter
-   Suggests educational content formats
-   Recommends B2B-focused messaging

### 2. Target Audience Personalization

**Example**: If `target_audience` is "Young professionals aged 25-35":

-   AI adjusts language to be modern and engaging
-   Suggests trending hashtags relevant to this demographic
-   Recommends posting times when this audience is active
-   Optimizes content length and format

### 3. Company Description Analysis

**Example**: If `company_description` mentions "ecommerce" or "online store":

-   AI focuses on product showcases
-   Suggests call-to-actions for online purchases
-   Optimizes for Instagram Shopping and Facebook Shop
-   Recommends user-generated content strategies

### 4. Multi-Platform Content Adaptation

Based on `preferred_social_platforms`, AI will:

-   **Facebook**: Optimize for longer-form content, community engagement
-   **Instagram**: Focus on visual content, stories, reels
-   **Twitter**: Create concise, engaging tweets
-   **LinkedIn**: Professional tone, B2B messaging
-   **YouTube**: Video content suggestions, SEO optimization
-   **TikTok**: Short-form video ideas, trending sounds
-   **Pinterest**: Visual pins, SEO-optimized descriptions

---

## Field Priority for AI Content Improvement

### High Priority (Most Important for AI)

1. ✅ **`target_audience`** - Personalizes messaging and timing
2. ✅ **`company_description`** - Provides context for content generation and determines content style

### Medium Priority

3. `company_name` - Used for branding in content
4. `preferred_social_platforms` - Determines platform-specific optimization

### Low Priority (Nice to Have)

5. `social_media_handles` - For account linking
6. Contact information - For business verification and location-based content

---

## Example Use Cases

### Use Case 1: Restaurant Owner

```json
{
    "company_name": "Pizza Paradise",
    "company_description": "Authentic Italian restaurant serving traditional pizzas and pasta",
    "target_audience": "Families and young adults who love authentic Italian food",
    "preferred_social_platforms": ["instagram", "facebook"]
}
```

**AI Will:**

-   Suggest food photography tips
-   Generate captions with food emojis
-   Recommend posting during meal times
-   Create Instagram Reels ideas for behind-the-scenes content
-   Optimize for local discovery (if address provided)

### Use Case 2: E-commerce Fashion Store

```json
{
    "company_name": "StyleHub",
    "company_description": "Online fashion retail store offering trendy clothing for millennials and Gen Z",
    "target_audience": "Fashion-forward millennials and Gen Z, aged 18-30",
    "preferred_social_platforms": ["instagram", "tiktok", "pinterest"]
}
```

**AI Will:**

-   Focus on visual product showcases
-   Suggest trending fashion hashtags
-   Create TikTok-style video content ideas
-   Optimize for Instagram Shopping features
-   Recommend user-generated content campaigns

### Use Case 3: B2B Tech Service

```json
{
    "company_name": "CloudTech Solutions",
    "company_description": "Cloud computing services provider for mid-size companies",
    "target_audience": "IT managers and CTOs at mid-size companies",
    "preferred_social_platforms": ["linkedin", "twitter"]
}
```

**AI Will:**

-   Use professional, technical language
-   Focus on educational content
-   Optimize for LinkedIn articles and posts
-   Create thought leadership content ideas
-   Suggest B2B-focused call-to-actions

---

## Postman Testing Example

### Request

```http
POST http://localhost:8000/api/register
Content-Type: application/json

{
  "name": "Jane Smith",
  "email": "jane@techstartup.com",
  "password": "securepass123",
  "company_name": "TechStart Solutions",
  "company_description": "Software development services for small to medium businesses",
  "target_audience": "Small to medium businesses looking for custom software solutions",
  "preferred_social_platforms": ["linkedin", "twitter", "facebook"]
}
```

---

## Next Steps After Registration

1. **Connect Social Media Accounts**: Link your existing social media accounts
2. **Create Your First Post**: Use the AI-powered content creator
3. **Schedule Posts**: Set up automated posting to multiple platforms
4. **Analyze Performance**: Track engagement across all platforms

---

## Important Notes

1. **Required Fields**: `company_name` is required as it's essential for AI content optimization
2. **AI Enhancement**: The more information you provide (especially `target_audience` and `company_description`), the better AI can personalize your content
3. **Platform Selection**: Choose your `preferred_social_platforms` carefully - this determines which platforms AI optimizes for
4. **Description Matters**: Be specific with `company_description` - it significantly impacts content suggestions and helps AI understand your business better

---

## Migration

Run the migration to add these fields to your database:

```bash
php artisan migrate
```

This will add all the new company/shop fields to the `app_users` table.

**Note**: The fields `company_category`, `business_type`, `business_registration_number`, and `business_established_date` have been removed from the system. Only `company_name` and `company_description` are used for company information.
