<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use app\Models\User;
use App\Models\Time;
use Carbon\Carbon; // Import Carbon

class LoginController extends Controller
{
    public function authenticate(Request $request){
        $request->validate([
            'email'=> 'required',
            'password'=> 'required',
        ]);

        $email = $request->input('email');
        $password = $request->input('password');

        $currentDate = Carbon::now()->toDateString(); // Get the current date without time
        $userId = Auth::id();

        $attendance = Time::where('user_id', $userId)
        ->whereDate('time_in', $currentDate)
        ->whereDate('time_out', $currentDate)
        ->count();

        if (Auth::attempt(['email'=>$email,'password'=>$password])) {
            $user = User::where('email',$email)->first();
            Auth::login($user);
            if( $attendance == 0){
                return Redirect('/home');
            }
            else{
                $time = Time::where('user_id', $userId)->latest()->first();

                $timeIn = Carbon::parse($time->time_in);
                $timeOut = Carbon::parse($time->time_out);

                $totalHours = $timeIn->diffInMinutes($timeOut) / 60;
                $formattedTotalHours = number_format($totalHours, 2);
                return view('index', ['time' => $time,'totalHours' => $formattedTotalHours]);
            }
            

        }else{
            return back()->withErrors(['invalid data']);
        }
    }

    public function logout(){
        Auth::logout();
        return redirect('/logout');
    }
}
