<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use App\Models\Time;


class AttendanceTimeController extends Controller
{
    public function index()
    {
        $currentDate = Carbon::now()->toDateString(); // Get the current date without time
        $userId = Auth::id();
        
        // Count the attendance records for the current date and the logged-in user
        $attendance = Time::where('user_id', $userId)
                           ->whereDate('time_in', $currentDate)
                           ->count();
        
        return view('home', compact('attendance'));
    }

    public function timeIn(Request $request)
    {
        $currentDate = Carbon::now();
        $userId = Auth::id();
        $attendance = new Time();
       $attendance->user_id = $userId;
       $attendance->time_in = $currentDate;
       $attendance->save();

       $time = Time::where('user_id', $userId)->latest()->first();

       if ($time && $time->time_in && $time->time_out) {
        $timeIn = Carbon::parse($time->time_in);
        $timeOut = Carbon::parse($time->time_out);


        $totalHours = $timeIn->diffInMinutes($timeOut) / 60;
        $formattedTotalHours = number_format($totalHours, 2);
    } else {
        $formattedTotalHours = 'N/A'; 
    }
        return view('index', ['time_in' => $attendance->time_in, 'time' => $time, 'totalHours' => $formattedTotalHours]);
    }





    public function timeOut(Request $request)
    {
        $currentDate = Carbon::now();
        $userId = Auth::id();

        $attendance = Time::where('user_id', $userId)
                          ->whereDate('time_in', Carbon::now()->toDateString())
                          ->first();
        
            $attendance->time_out = $currentDate;
            $attendance->save();
            $time = Time::where('user_id', $userId)->latest()->first();

            if ($time && $time->time_in && $time->time_out) {
                $timeIn = Carbon::parse($time->time_in);
                $timeOut = Carbon::parse($time->time_out);
    
        
                $totalHours = $timeIn->diffInMinutes($timeOut) / 60;
                $formattedTotalHours = number_format($totalHours, 2);
            } else {
                $formattedTotalHours = 'N/A'; 
            }
            return view('index', [
                'time_in' => $attendance->time_in,
                'time_out' => $attendance->time_out,
                'time' => $time,
                'totalHours' => $formattedTotalHours
            ]);
        
    }

    
}
