"use strict";

// Class definition
var Googletranslate = (function () {
  var translatelanguage = function () {
    const languageSelector = $("#languageSelector"); // Use jQuery to select the element
    const savedLanguage = $("#savedLanguage").val() || 'en'; // Get saved language from hidden input or default to 'en'
    console.log('savedLanguage',savedLanguage);
    // Set the selected option in the select dropdown using jQuery
    languageSelector.val(savedLanguage); // Directly set the value of the select element
    
    if (!window.location.href.includes('thankyou/index')) {
      setGoogleTranslateLanguage(savedLanguage);
    }
     // Apply selected language
    // Add event listener to the select element for language change
    languageSelector.on("change", function () {
      const selectedLanguage = $(this).val(); // Get the selected language
      const selectedText = $(this).find("option:selected").text(); // Get the selected option text

      // Save the selected language in localStorage
      localStorage.setItem("selectedLanguage", selectedLanguage);

      // Set the Google Translate language
      setGoogleTranslateLanguage(selectedLanguage); // Apply selected language

      // Save language to database
      saveLanguageToDatabase(selectedLanguage); // Save to database

      // Update the button text (optional if needed)
      // languageSelector.text(selectedText);
    });
  };

  return {
    init: function () {
      translatelanguage();
    },
  };
})();

// Initialize the script
jQuery(document).ready(function () {
  Googletranslate.init();

  $.ajaxSetup({
    headers: {
      "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
    },
  });
});

// Function to set the language in Google Translate
function setGoogleTranslateLanguage(language) {
  console.log('language',language);
  document.cookie = `googtrans=/en/${language}; path=/`;
  document.cookie = `googtrans=/en/${language}; domain=${window.location.hostname}; path=/`;

  // Trigger Google Translate's language change
  const interval = setInterval(() => {
    const selectElem = document.querySelector(".goog-te-combo");
    if (selectElem) {
      clearInterval(interval);
      selectElem.value = language;
      selectElem.dispatchEvent(new Event("change")); // Trigger change event
    }
  }, 100);
}

function saveLanguageToDatabase(language) {
  const savedUserId = $("#savedUserId").val();
  $.ajax({
    url: "/store-language", // Endpoint where the language is stored
    method: "POST", // HTTP method
    data: {
      language: language, // Language data
      user_id: savedUserId, // User ID from hidden input
    },
    success: function (response) {
      console.log("Language saved successfully:", response);
      // location.reload();
    },
    error: function (xhr, status, error) {
      console.error("Error saving language:", error);
    },
  });
}
