<?php

namespace App\Modules\Candidate\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Collective\Html\Eloquent\FormAccessible;
use DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Auth;
use App\Modules\Candidate\Models\BusinessOwner;
use App\Modules\Candidate\Models\Profilemst;
use App\Modules\Candidate\Models\Result;
use App\Modules\Candidate\Models\Position;
use App\Modules\Candidate\Models\Candidatemst;
use App\Modules\Candidate\Models\Testmst;
use App\Modules\Candidate\Models\AssessmentSave;
use App\Modules\Candidate\Models\ProblemsolvingSave;
use App\Modules\Candidate\Models\CandidateLog;
use App\Modules\Candidate\Models\Mailmst;
use Mail;

use Illuminate\Support\Facades\Redirect;

class ThankyouController extends Controller
{


	public function index()
	{


		$test_id = Auth::user()->test_id;

		$candidate_id = Auth::id();

		$business_id = Auth::user()->business_id;
		$business_owner = BusinessOwner::find($business_id);

		$resultupdate = Result::calculateandsave($test_id,$candidate_id);
			
		if($resultupdate) {

			$candidate_log = new CandidateLog;
			$candidate_log->candidate_id = $candidate_id;
			$candidate_log->business_id = $business_id;
			$candidate_log->action = "COMPLETED ASSESSMENT";
			$candidate_log->save();


			$candidate_mst = Candidatemst::find($candidate_id);

			if($candidate_mst['status'] != 'Hired' && $candidate_mst['status'] != 'Terminated') {

			$candidate_mst->status = 'REVIEW';
			$candidate_mst->save();

			}

	
			$this->businessownernotification_mail($resultupdate,$candidate_mst,$business_owner,'FINALTEST_COMPLETION_NOTIFICATION');

			$this->sendcandidatemail($candidate_mst,$business_owner,'TEST_COMPLETION_NOTIFICATION_TO_CANDIDATE');
	
		}

		return view('Candidate::thankyou.index');


	}

	public function businessownernotification_mail ($result,$candidate_mst,$business_owner,$mail_title) {


      $mail = Mailmst::find($mail_title);
	  $mail_data['subj'] = 	$mail->subject;
	  $mail_data['from'] = 	$mail->from_id;
	  $mail_data['to'] = $business_owner['username'];

	  if($candidate_mst['notification_mail']) {

		  $notification_email = explode(",",$candidate_mst['notification_mail']);
		  $users = DB::table('user_mst')
				   ->select("email")
				   ->whereIn('user_id', $notification_email)->get();

		$mail_data['notification'] = $users;


	  }	

	  

	  $find = array('%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%PROFILE_OUTCOME%');
      $replace = array($business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name	,$result['profile_result']);
	  $message = str_replace($find,$replace, $mail->mail_content);
	  $mail_data['content'] = $message;

	  Mail::queue('Candidate::emails.notification', $mail_data, function ($message) use ($mail_data) {

			$message->from($mail_data['from'], 'IdealTraits.com');
            $message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
			foreach($mail_data['notification'] as $to_email) {
				
				$message->to($to_email->email, $mail_data['to'])->subject($mail_data['subj']);
			}

		});


	}



	public function sendcandidatemail ($candidate_mst,$business_owner,$mail_title) {


      $mail = Mailmst::find($mail_title);
	  $mail_data['subj'] = 	$mail->subject;
	  $mail_data['from'] = 	$mail->from_id;
	  $mail_data['to'] =	$candidate_mst['email'];

	 
	  $find = array("%FIRST NAME%","%BUSINESS LOGO%");
		
	  if($business_owner->business_logo != "") {
				   $banner = $business_owner["business_logo"];
			} else {
				   $banner =  "default_logo.jpg";
			}	

      $replace = array($candidate_mst->first_name . " " . $candidate_mst->last_name, config('constants.business_logo_path') . $banner  );
	  $message = str_replace($find,$replace, $mail->mail_content);
	  $mail_data['content'] = $message;

	  Mail::queue('Candidate::emails.notification', $mail_data, function ($message) use ($mail_data) {

			$message->from($mail_data['from'], 'IdealTraits.com');
            $message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
			

		});


	}


	





	

}



?>