<?php

namespace App\Modules\Candidate\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Collective\Html\Eloquent\FormAccessible;
use DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\Modules\Candidate\Models\ProblemSolving;
use App\Modules\Candidate\Models\PsResults;
use App\Modules\Candidate\Models\AssessmentSave;
use App\Modules\Candidate\Models\Testmst;

use Illuminate\Support\Facades\Redirect;

class ProblemsolvingController extends Controller
{


	public function index()
	{

		

		$ps_data = ProblemSolving::orderBy('iq_id')->get();

		$ps_result = PsResults::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id])->orderBy('iq_id')->get(['iq_id', 'answer']);

		return view('Candidate::problemsolving.index',["ps_data" => $ps_data,"ps_result" => $ps_result->keyBy('iq_id')]);


	}


	public function save(Request $request)
	{


		$ps_data = Input::all();
		$ps_mst = ProblemSolving::orderBy('iq_id')->get();

		
		foreach($ps_mst as $row) {

			PsResults::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id,"iq_id" => $row['iq_id']])->delete();

			$ps_ans['candidate_id'] = Auth::id();
			$ps_ans['iq_id'] = $row['iq_id'];
			$ps_ans['test_id'] = Auth::user()->test_id;
			$ps_ans['answer'] = $ps_data['psopt_' . $row['iq_id']];
			if($ps_ans['answer'] == $row['answer'] ) {
				$ps_ans['result'] = "Correct";
			} else {
				$ps_ans['result'] = "Wrong";
			}

			$ps_update = PsResults::updateOrCreate($ps_ans);
			if($ps_update) {

				$request->session()->put('completed.problemsolving', '1');

			}

		}


		$test_mst = Testmst::find(Auth::user()->test_id);
		if($test_mst->short_answer == 1) {
		
				return Redirect::to("shortanswer/index");
		}
			
	}


	public function sample()
	{

		return view('Candidate::assessment.sample');


	}


}



?>