<?php
namespace App\Modules\Candidate\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Collective\Html\Eloquent\FormAccessible;
use DB;
use App\Modules\Candidate\Models\Language;
use App\Modules\Candidate\Models\Education;
use App\Modules\Candidate\Models\Contactinfo;
use App\Modules\Candidate\Models\Contactdetails;
use App\Modules\Candidate\Models\State;
use App\Modules\Candidate\Models\Country;
use App\Modules\Candidate\Models\Experience;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Carbon\Carbon;

class BuildresumeController extends Controller
{

	public function index()
	{

		
		$candidate = Contactinfo::find(Auth::id());
		$state = State::orderBy('state')->get();
		$country = Country::orderBy('country')->get();
	  	return view('Candidate::buildresume.index',
			   ['state'=> $state,'country' => $country,'candidate' => $candidate]);
		  
	}


	public function saveresume()
	{

		$resume_data = Input::all();
		

		if($resume_data) {

			$this->updatecontactinfo($resume_data);
			$this->updateworkexperience($resume_data);
			$this->updateeduexperience($resume_data);
			$this->updateedulang($resume_data);

        	  $voluntary_details = Contactdetails::where('candidate_id', Auth::id())
								->first();
			if($voluntary_details->race != '' && $voluntary_details->gender != ''){
			   return Redirect::to('/assessment/sample');
			} 
			else{
				 return Redirect::to('/vountary/index');
			}
	    }

	}


public function updateedulang($resume_data) {


	$lang_index = 0;
    foreach($resume_data['lang'] as $row) {

			
			$lang['read'] = '';
			$lang['write'] = '';
			$lang['speak'] = '';

			$lang['candidate_id'] = Auth::id();
			$lang['languages'] = $resume_data['lang'][$lang_index];

			if(isset($resume_data['lang_read'][$lang_index])) {
			$lang['read'] = $resume_data['lang_read'][$lang_index];
			}
			if(isset($resume_data['lang_write'][$lang_index])) {
			$lang['write'] = $resume_data['lang_write'][$lang_index];
			}
			if(isset($resume_data['lang_speak'][$lang_index])) {
			$lang['speak'] = $resume_data['lang_speak'][$lang_index];
			}
			$lang_update = Language::where('candidate_id', Auth::id())
								->updateOrCreate($lang);
			$lang_index++;

		}
			 
 }


	
 public function updatecontactinfo($resume_data) {


	 $contactinfo['first_name'] = $resume_data['contact_first_name'] . " " . $resume_data['contact_last_name'];
		$contactinfo['address1'] = $resume_data['contact_address1'];
		$contactinfo['address2'] = $resume_data['contact_address2'];
		$contactinfo['state'] = $resume_data['contact_state'];
		$contactinfo['country'] = $resume_data['contact_country'];
		$contactinfo['mobile'] = $resume_data['contact_phone_number'];
 		$contactinfo['telephone'] = $resume_data['contact_telephone'];
		$contactinfo['objective'] = $resume_data['objective'];
		$contactinfo['summary'] = $resume_data['summary'];
		$contactinfo['achievements'] = $resume_data['achievements'];
		$contactinfo['skills'] = $resume_data['skills'];


		$contact_insert = Contactinfo::where('candidate_id', Auth::id())
								  ->update($contactinfo);
			 
 }

 public function updateworkexperience($resume_data) {


	$experience_index = 0;
    foreach($resume_data['workexperience_position_title'] as $row) {
		
			$experience['candidate_id'] = Auth::id();
			$experience['designation'] = $resume_data['workexperience_position_title'][$experience_index];
			$experience['company'] = $resume_data['workexperience_company'][$experience_index];
			
			
			$dtfrom = Carbon::createFromDate($resume_data['workexperience_from_year'][$experience_index], $resume_data['workexperience_from_month'][$experience_index], 1);
			
			$dtto = Carbon::createFromDate($resume_data['workexperience_to_year'][$experience_index], $resume_data['workexperience_to_month'][$experience_index], 1);
			
			
			
			$experience['start_date'] = date_format($dtfrom,"M-Y");
			
			$experience['end_date'] = date_format($dtto,"M-Y");;
			
			
			
			$experience['location'] = $resume_data['workexperience_location_title'][$experience_index];
			$experience['description'] = $resume_data['workexperience_job_desc'][$experience_index];

			if(isset($resume_data['workexperience_workhere'][$experience_index]))
			$experience['stillhere'] = $resume_data['workexperience_workhere'][$experience_index];
             $selected_country =  Country::find($resume_data['contact_country']);
		
			$experience['country'] = $selected_country['country_code'];

			$dtfrom = Carbon::createFromDate($resume_data['workexperience_from_year'][$experience_index], $resume_data['workexperience_from_month'][$experience_index], 1);
			
			$dtto = Carbon::createFromDate($resume_data['workexperience_to_year'][$experience_index], $resume_data['workexperience_to_month'][$experience_index], 1);
			
			
			$interval = $dtfrom->diff($dtto);   //calculation for number of years experience

			$experience['no_of_yearsexp'] = $interval->format('%y.%m');

			

			$experience_update = Experience::where('candidate_id', Auth::id())
								->updateOrCreate($experience);
			$experience_index++;

		}
			 
 }


 public function updateeduexperience($resume_data) {


	$edu_index = 0;
    foreach($resume_data['edu_institute'] as $row) {
		
			$edu['candidate_id'] = Auth::id();
			$edu['institute'] = $resume_data['edu_institute'][$edu_index];
			$edu['degree'] = $resume_data['edu_degree'][$edu_index];
			
			
			$dtfrom = Carbon::createFromDate($resume_data['edu_from_year'][$edu_index], $resume_data['edu_from_month'][$edu_index], 1);
			
			$dtto = Carbon::createFromDate($resume_data['edu_to_year'][$edu_index], $resume_data['edu_to_month'][$edu_index], 1);
			
			
			
			$edu['start_date'] = date_format($dtfrom,"M-Y");
			$edu['end_date'] = date_format($dtto,"M-Y");;
			
			
			
			//$edu['start_date'] = date("M", $resume_data['edu_from_month'][$edu_index]) . "-" . $resume_data['edu_from_year'][$edu_index] ;
			//$edu['end_date'] = date("M",$resume_data['edu_to_month'][$edu_index]) . "-" . $resume_data['edu_to_year'][$edu_index] ;
			$edu['state'] = $resume_data['edu_state'][$edu_index];
			//$edu['country'] = "US";
			  $selected_country =  Country::find($resume_data['contact_country']);
		
			$edu['country'] = $selected_country['country_code'];

			if(isset($resume_data['edu_ongoing'][$edu_index])) {
				$edu['ongoing'] = $resume_data['edu_ongoing'][$edu_index];
			}
			$edu_update = Education::where('candidate_id', Auth::id())
								->updateOrCreate($edu);
			$edu_index++;

		}
			 
 }


}
