<?php

namespace App\Modules\Candidate\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Collective\Html\Eloquent\FormAccessible;
use DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\Modules\Candidate\Models\Assessment;
use App\Modules\Candidate\Models\AssessmentSave;
use Illuminate\Support\Facades\Redirect;
use App\Modules\Candidate\Models\Mailmst;
use Mail;
use App\Modules\Candidate\Models\BusinessOwner;
use App\Modules\Candidate\Models\Result;
use App\Modules\Candidate\Models\Candidatemst;
use App\Modules\Candidate\Models\Testmst;



class AssessmentController extends Controller
{


	public function index(Request $request)
	{

	
		

    
		$assessments = Assessment::orderBy('pq_id')->paginate(4);

		$assessments_result = AssessmentSave::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id])->orderBy('pq_id')->get(['pq_id', 'most','least']);

		return view('Candidate::assessment.index',["assessments" => $assessments,"assessments_result" => $assessments_result]);


	}


	public function save(Request $request)
	{


	

		$assessment_data = Input::all();


		
		foreach($assessment_data['pqid'] as $index => $pqid) {

		$most = $assessment_data['mst_radio'. $pqid];
		$least = $assessment_data['lst_radio'. $pqid];

		$assessment_save['candidate_id'] =  Auth::id();
		$assessment_save['pq_id'] =  $pqid;
		$assessment_save['most'] =  $most;
		$assessment_save['least'] =  $least;
		$assessment_save['test_id'] =  Auth::user()->test_id;

		AssessmentSave::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id,"pq_id" => $pqid])->delete();

		$assessment_update = AssessmentSave::where('candidate_id', Auth::id())
								->updateOrCreate($assessment_save);

		}
			if($assessment_data['nextpage'])
			return Redirect::to($assessment_data['nextpage']);		
			else {

				$test_id = Auth::user()->test_id;
				$candidate_id = Auth::id();
				$business_id = Auth::user()->business_id;
				$business_owner = BusinessOwner::find($business_id);
				$resultupdate = Result::calculateandsave($test_id,$candidate_id);
		
				if($resultupdate) {

					$request->session()->put('completed.assessments', '1');

					$candidate_mst = Candidatemst::find($candidate_id);
					if($candidate_mst['status'] != 'Hired' && $candidate_mst['status'] != 'Terminated') {
					$candidate_mst->status = 'INCOMPLETE';
					$candidate_mst->save();

					}
					$this->businessownernotification_mail($resultupdate,$candidate_mst,$business_owner,'TEST_COMPLETION_NOTIFICATION');
				}


				$test_mst = Testmst::find(Auth::user()->test_id);

				if($test_mst->problem_solving == 1) {

					return Redirect::to("problemsolving/index");

				} else if($test_mst->short_answer == 1) {
					
					return Redirect::to("shortanswer/index");
				} else
					return Redirect::to("thankyou/index");


			}
	

	}


	public function businessownernotification_mail ($result,$candidate_mst,$business_owner,$mail_title) {


      $mail = Mailmst::find($mail_title);
	  $mail_data['subj'] = 	$mail->subject;
	  $mail_data['from'] = 	$mail->from_id;
	  $mail_data['to'] = $business_owner['username'];

	  if($candidate_mst['notification_mail']) {

		  $notification_email = explode(",",$candidate_mst['notification_mail']);
		  $users = DB::table('user_mst')
				   ->select("email")
				   ->whereIn('user_id', $notification_email)->get();

		$mail_data['notification'] = $users;


	  }	

	  

	  $find = array('%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%USER_NAME%','%URL%','%PROFILE_OUTCOME%');
      $replace = array($business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name,$candidate_mst->username,url('/'),$result['profile_result']);
	  $message = str_replace($find,$replace, $mail->mail_content);
	  $mail_data['content'] = $message;

	  Mail::queue('Candidate::emails.notification', $mail_data, function ($message) use ($mail_data) {

			$message->from($mail_data['from'], 'IdealTraits.com');
            $message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
			foreach($mail_data['notification'] as $to_email) {
				
				$message->to($to_email->email, $mail_data['to'])->subject($mail_data['subj']);
			}

		});


	}


	public function sample()
	{

		return view('Candidate::assessment.sample');


	}


}



?>