@extends('Candidate::template.header')  
@section('main')
<section class="content-part">
	<div class="container">
		<h3>
			@if (isset($business_arr[0]->candidate_welcome_msg) && $business_arr[0]->candidate_welcome_msg != '')
			{{ $business_arr[0]->candidate_welcome_msg }}
			@else
			<!--  Our Team is dedicated to our employees and driven to succeed. Thank you for your interest in the position offered. -->
			@endif
		</h3>
		<div class="row">
			<div class="col-md-2 col-sm-2">
			</div>
			<div class="col-md-8 col-sm-8">
				@if(isset($nodata))
					<div id="login-error" class="alert alert-danger alert-dismissable fade in">
						<ul>
							
							<li>Please click email link which we have send through email to reset your password</li>
						
						</ul>
					</div>
				@else
				<div class="login-part">
					<h4>Update Password</h4>  
					
					
					@if ($errors->any())
					<div id="login-error" class="alert alert-danger alert-dismissable fade in">
						<ul>
							@foreach ($errors->all() as $error)
							<li>{{ $error }}</li>
							@endforeach
						</ul>
					</div>
					@endif
					
					{!! Form::open(['url' => 'login/updatepassword', 'class' => 'welcome-login class-new', 'onsubmit'=> 'return validate();']) !!} 
					<div class="form-group">
						
						<input name="password" type="password" id="password" class="form-control-login" placeholder="Enter your password">
						
					</div>
					<div class="form-group">
						<!-- <input type="password" id="password" class="form-control-login" placeholder="Password (Located in invitation mail)">-->
						<input type="hidden" name="currenturl" value="{{ URL::current() }}" />
						
						<input name="retypepassword" type="password" id="retypepassword" class="form-control-login" placeholder="Re-enter your password">
						
						@if (isset($business_arr[0]->business_id) && $business_arr[0]->business_id != '')
						{{ Form::hidden('business_id', $business_arr[0]->business_id, array('id' => 'business_id')) }}
						@endif
						
						{{ Form::hidden('username', $username, array('id' => 'username')) }}
						
						@if (isset($candidate_id) && $candidate_id != '')
						{{ Form::hidden('candidate_id', $candidate_id, array('id' => 'candidate_id')) }}
						@endif
					</div>
					<div class="control__indicator"></div>
				<button type="submit" class="btn-submit hvr-shutter-in-vertical">Update</button>
				<!-- </form>-->
				{!! Form::close() !!}
			</div>
			@endif
		</div>
		
	</div>
</div>
</section>

@stop

<script type="text/javascript">

	function validate(){
		
		var result = true;
		
		if ($('#retypepassword').val()==''){
			$('#retypepassword').addClass("err-cls");
			result = false;
		} else{
			$('#retypepassword').removeClass("err-cls");
		}
		if ($('#password').val()==''){
			$('#password').addClass("err-cls");
			result = false;
		} else{
			$('#password').removeClass("err-cls");
		}
		if ($('#retypepassword').val() != '' && $('#password').val()==''){
			if(  $('#retypepassword').val() != $('#password').val()){
				$('#retypepassword').addClass("err-cls");
				$('#password').addClass("err-cls");
				result = false;
			} 
		} 
		
		return result;

	}
</script>

