@extends('Candidate::template.header')  
@section('main')
<section class="content-part">
	<div class="container">
		<h3>
			@if(!isset($expirylink) && !isset($message))
			@if (isset($business_arr[0]->candidate_welcome_msg) && $business_arr[0]->candidate_welcome_msg != '')
			{{ $business_arr[0]->candidate_welcome_msg }}
			@else
			Our Team is dedicated to our employees and driven to succeed. Thank you for your interest in the position offered.
			@endif
			@endif
		</h3>
		<div class="row">

			
			@if(isset($expirylink))
			<div class="col-md-2 col-sm-2">
			</div>
			<div class="col-md-8 col-sm-8">
				<div class="login-part">
					<div id="login-error" class="alert alert-danger alert-dismissable fade in text-center">
						<ul>
							<li>{{ $expirylink }}</li>

						</ul>
					</div>
				</div>
				@elseif(isset($message))
				<div class="col-md-2 col-sm-2">
				</div>
				<div class="col-md-8 col-sm-8">
					<div class="login-part">
						<div id="login-error" class="alert alert-success alert-dismissable fade in text-center">
							<ul>
								<li>{{ $message }}</li>

							</ul>
						</div>
					</div>
					@elseif(!isset($hashval) && !isset($throughlogin))
					<div class="col-md-2 col-sm-2">
					</div>
					<div class="col-md-8 col-sm-8">
						<div class="login-part">
							<h4>Reset your password</h4>  
							@if ($errors->any())
							<div id="login-error" class="alert alert-danger alert-dismissable fade in">
								<ul>
									@foreach ($errors->all() as $error)
									<li>{{ $error }}</li>
									@endforeach
								</ul>
							</div>
							@endif
							{!! Form::open(['url' => 'login/resetpassword', 'class' => 'welcome-login class-new', 'onsubmit'=> 'return validatereset();']) !!} 
							<div class="form-group">

								<input name="username" type="text" id="username" class="form-control-login" placeholder="Enter your username" @if(isset($username)) value="{{ $username }}" readonly @endif>

							</div>
							<div class="form-group">

								<input type="hidden" name="currenturl" value="{{ URL::current() }}" />

								<input name="candidateemail" type="text" id="candidateemail" class="form-control-login" placeholder="Enter your email"  @if(isset($candidateemail)) value="{{ $candidateemail }}" readonly @endif>

								@if (isset($business_arr[0]->business_id) && $business_arr[0]->business_id != '')
								{{ Form::hidden('business_id', $business_arr[0]->business_id, array('id' => 'business_id')) }}
								@endif

								@if (isset($candidate_id) && $candidate_id != '')
								{{ Form::hidden('candidate_id', $candidate_id, array('id' => 'candidate_id')) }}
								@endif
							</div>
							<div class="control__indicator"></div>
							<button type="submit" class="btn-submit hvr-shutter-in-vertical">Send Reset Link </button>
							<!-- </form>-->
							{!! Form::close() !!}
						</div>
						@else
						<div class="col-md-1 col-sm-1">
						</div>
						<div class="col-md-6 col-sm-6">
							<div class="login-part">
								@if(!isset($hashval))
								<h4>Create password</h4>
								@else  
								<h4>Reset password</h4>
								@endif



								
								
								{!! Form::open(['url' => 'login/updatepassword', 'class' => 'welcome-login class-new', 'onsubmit'=> 'return validate();']) !!} 
								<div class="form-group">

									<input name="password" type="password" id="password" class="form-control-login" placeholder="Create a password">

								</div>
								<div class="form-group">
									<!-- <input type="password" id="password" class="form-control-login" placeholder="Password (Located in invitation mail)">-->
									<input type="hidden" name="currenturl" value="{{ URL::current() }}" />

									<input name="retypepassword" type="password" id="retypepassword" class="form-control-login" placeholder="Re-enter your password">

									@if (isset($business_arr[0]->business_id) && $business_arr[0]->business_id != '')
									{{ Form::hidden('business_id', $business_arr[0]->business_id, array('id' => 'business_id')) }}
									@endif
									@if(isset($username))
									{{ Form::hidden('username', $username, array('id' => 'username')) }}
									@endif

									@if (isset($candidate_id) && $candidate_id != '')
									{{ Form::hidden('candidate_id', $candidate_id, array('id' => 'candidate_id')) }}
									@endif
								</div>
								<div id="login-error" class="alert alert-danger alert-dismissable fade in" style="display:none">
									<ul style="padding-left: 10px">
										
									</ul>
								</div>
								<div class="form-group">
									<div id="agree-label" class="displtble">
										<label>
											<span class="custom-checkbox">
												<input type="checkbox" name="agree" id="agree" value=1 checked="checked" onclick="setval();">
											</span>
											<span> I agree to the <a target="_blank" href="http://idealtraits.com/terms-and-conditions/">Terms of Service</a> and <a target="_blank" href="http://idealtraits.com/terms-and-conditions/">Privacy Policy</a></span> </label>
										</div>
									</div>
									
									<div class="control__indicator"></div>
									<button type="submit" class="btn-submit hvr-shutter-in-vertical">Continue</button>
									<!-- </form>-->
									{!! Form::close() !!}
								</div>
							</div>
						</br></br></br></br>
						<div class="col-md-5 col-sm-5">
							<div class="bxr-shad"> <span>Password must meet the following</span>
								<p>Be at least 6 characters</p>
								<p>Contains 1 uppercase letter</p>
								<p>Contains 1 special character</p>
							</div>
							@endif
						</div>

		</div>
	</div>
	
</section>

			@stop

			<script type="text/javascript">

				function validate(){

					var result = true;
					$('#login-error ul').empty();
					if ($('#retypepassword').val()==''){
						$('#retypepassword').addClass("err-cls");
						result = false;
					} else{
						$('#retypepassword').removeClass("err-cls");
					}
					if ($('#password').val()==''){
						$('#password').addClass("err-cls");
						result = false;
					} else{
						$('#password').removeClass("err-cls");
					}
					if ($('#retypepassword').val() != '' && $('#password').val() !=''){
						if(  $('#retypepassword').val() != $('#password').val()){
							$('#retypepassword').addClass("err-cls");
							$('#password').addClass("err-cls");
							$('#login-error ul').append('<li style="list-style: unset;">Your password & confirm password must match</li>');
							$('#login-error').show();
							result = false;
						} 
					} 
					if ($('#password').val().length < 6){
						$('#login-error ul').append('<li style="list-style: unset;">You have to enter at least 6 digit!</li>');
						$('#login-error').show();
						result = false;
					}
					var pwdUpper = /[A-Z]+/;
					var pwdSpecial = /[!@#$%^&()'[\]"?+-/*={}.,;:_]+/;
					var pass = $('#password').val();
					if(!pwdUpper.test(pass) || !pwdSpecial.test(pass)) {
						$('#login-error ul').append('<li style="list-style: unset;">Password missing required characters</li>');
						$('#login-error').show();
						result = false;
					} 

					return result;

				}

				function validatereset(){

					var resultreset = true;

					if ($('#username').val()==''){
						$('#username').addClass("err-cls");
						resultreset = false;
					} else{
						$('#username').removeClass("err-cls");
					}
					if ($('#candidateemail').val()==''){
						$('#candidateemail').addClass("err-cls");
						resultreset = false;
					} else{
						$('#candidateemail').removeClass("err-cls");
					}


					return resultreset;

				}
			</script>

