<?php

namespace App\Modules\Candidate\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Collective\Html\Eloquent\FormAccessible;
use DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Auth;
use App\Modules\Candidate\Models\BusinessOwner;
use App\Modules\Candidate\Models\Profilemst;
use App\Modules\Candidate\Models\Result;
use App\Modules\Candidate\Models\Position;
use App\Modules\Candidate\Models\Candidatemst;
use App\Modules\Candidate\Models\Testmst;
use App\Modules\Candidate\Models\AssessmentSave;
use App\Modules\Candidate\Models\ProblemsolvingSave;
use App\Modules\Candidate\Models\CandidateLog;
use App\Modules\Candidate\Models\Mailmst;
use App\Modules\Candidate\Models\History;
use Mail;

use Illuminate\Support\Facades\Redirect;

class ThankyouController extends Controller
{


	public function index(Request $request)
	{


		$test_id = Auth::user()->test_id;

		$candidate_id = Auth::id();

		$business_id = Auth::user()->business_id;
		$business_owner = BusinessOwner::find($business_id);

		

		
        $start_time  = $request->session()->get('start_test_time');

		$resultupdate = Result::thankyoucalculateandsave($test_id,$candidate_id,$start_time);
			
		if($resultupdate) {

			$candidate_log = new CandidateLog;
			$candidate_log->candidate_id = $candidate_id;
			$candidate_log->business_id = $business_id;
			$candidate_log->action = "COMPLETED ASSESSMENT";
			$candidate_log->save();


			$candidate_mst = Candidatemst::find($candidate_id);

			if($candidate_mst['status'] != 'Hired' && $candidate_mst['status'] != 'Terminated') {

			$candidate_mst->status = 'REVIEW';
			$candidate_mst->save();

			}

	
			$this->businessownernotification_mail($resultupdate,$candidate_mst,$business_owner,'FINALTEST_COMPLETION_NOTIFICATION');

			$this->sendcandidatemail($candidate_mst,$business_owner,'TEST_COMPLETION_NOTIFICATION_TO_CANDIDATE');
	
		}
		if ($business_owner['current_package_id'] == 50 && $candidate_mst['job_id'] != NULL) {
				$business_logo = $business_owner->business_logo;
		       $offerpage_res = DB::table('package_mst')
		           ->join('candidateofferpage','package_mst.candidateofferpage', '=', 'candidateofferpage.content_id')
				   ->select('candidateofferpage.page_content')
				   ->where('package_mst.package_id', "=",$business_owner['current_package_id'])->first();
		
		        $state_res = DB::table('candidate_contactinfo')
				   ->select('candidate_contactinfo.state')
				   ->where('candidate_contactinfo.candidate_id', "=",$candidate_id)->first();
				  
		
			  $find = array('%FIRST_NAME%','%CANDIDATE_STATE%');
			  $replace = array($candidate_mst['first_name'],$state_res->state);
			  $message = str_replace($find,$replace, $offerpage_res->page_content);
			   return view('Candidate::thankyou.index', ['business_logo' => $business_logo,'offerpage_content' =>$message]);
			
		}else{
			if(isset($business_owner['business_website']) && $business_owner['business_website'] != '' ) {
		  if( strpos( $business_owner['business_website'], 'http' ) !== false ) {
   				header('Refresh: 5;url='.$business_owner['business_website']);
           }else{
		        header('Refresh: 5;url=http://'.$business_owner['business_website']);
		   }
		
		} else {
			header('Refresh: 5;url=http://www.idealtraits.com');
		}
		History::maintainCandidateLog(9,'CANDIDATE_THANKYOU');
		Auth::logout();
		$request->session()->flush();
		$business_logo = $business_owner->business_logo;
		//return view('Candidate::thankyou.index');
		 return view('Candidate::thankyou.index', ['business_logo' => $business_logo]);
		
		}


	}
	public function save(Request $request)
	{
		print_r($request);
		exit;
	}

	public function businessownernotification_mail ($result,$candidate_mst,$business_owner,$mail_title) {


      $mail = Mailmst::find($mail_title);
	  $mail_data['subj'] = 	$mail->subject;
	  $mail_data['from'] = 	$mail->from_id;
	  $mail_data['to'] = $business_owner['username'];

      if($mail->mail_active == 'Y'){
			 /* if($candidate_mst['notification_mail']) {
		
				  $notification_email = explode(",",$candidate_mst['notification_mail']);
				  $users = DB::table('user_mst')
						   ->select("email")
						   ->whereIn('user_id', $notification_email)->get();
		
				$mail_data['notification'] = $users;
		
		
			  }	*/
			  	  $notification_email = DB::table('business_email_notification')
				   ->select("FINALTEST_COMPLETION_NOTIFICATION")
				   ->where('business_id', $business_owner->business_id)->first();
		
		
				if(isset($notification_email->FINALTEST_COMPLETION_NOTIFICATION) && $notification_email->FINALTEST_COMPLETION_NOTIFICATION != '' ){
						   $notification_arr = explode(",", $notification_email->FINALTEST_COMPLETION_NOTIFICATION);
							$mail_data['notification'] = $notification_arr;
							
				 }
		
			  
		
			  $find = array('%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%PROFILE_OUTCOME%','%CANDIDATE_SUMMARY_LINK%');
			  $replace = array($business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name	,$result['profile_result'],config('constants.base_path').'candidates/view/id/'.$candidate_mst->candidate_id.'/sflag/1');
			  $message = str_replace($find,$replace, $mail->mail_content);
			  $mail_data['content'] = $message;
		
			  Mail::queue('Candidate::emails.notification', $mail_data, function ($message) use ($mail_data, $notification_email) {
		
					$message->from($mail_data['from'], 'IdealTraits.com');
					/*$message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
					if(isset($mail_data['notification']) && $mail_data['notification'] != ''){
						foreach($mail_data['notification'] as $to_email) {
							
							$message->to($to_email->email, $mail_data['to'])->subject($mail_data['subj']);
						}
					}*/
					if(isset($notification_email)){
					   if($notification_email->FINALTEST_COMPLETION_NOTIFICATION != ''){
						foreach($mail_data['notification'] as $to_email) {
							$message->to($to_email,$to_email )->subject($mail_data['subj']);
						}
					   }
					}else{
						   $message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
						
					 }
		
				});
		}


	}



	public function sendcandidatemail ($candidate_mst,$business_owner,$mail_title) {


      $mail = Mailmst::find($mail_title);
	  $mail_data['subj'] = 	$mail->subject;
	  $mail_data['from'] = 	$mail->from_id;
	  $mail_data['to'] =	$candidate_mst['email'];

	  if($mail->mail_active == 'Y'){ 
		  $find = array("%FIRST NAME%","%BUSINESS LOGO%");
			
		  if($business_owner->business_logo != "") {
					   $banner = $business_owner["business_logo"];
		   } else {
					   $banner =  "default_logo.jpg";
		  }	
	
		  $replace = array($candidate_mst->first_name . " " . $candidate_mst->last_name, config('constants.business_logo_path') . $banner  );
		  $message = str_replace($find,$replace, $mail->mail_content);
		  $mail_data['content'] = $message;
	
		  Mail::queue('Candidate::emails.notification', $mail_data, function ($message) use ($mail_data) {
	
				$message->from($mail_data['from'], 'IdealTraits.com');
				$message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
				
	
			});
		}

	}


	





	

}



?>