<?php

namespace App\Modules\Candidate\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Collective\Html\Eloquent\FormAccessible;
use DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\Modules\Candidate\Models\Assessment;
use App\Modules\Candidate\Models\AssessmentSave;
use App\Modules\Candidate\Models\History;
use Illuminate\Support\Facades\Redirect;
use App\Modules\Candidate\Models\Mailmst;
use Mail;
use App\Modules\Candidate\Models\BusinessOwner;
use App\Modules\Candidate\Models\Result;
use App\Modules\Candidate\Models\Candidatemst;
use App\Modules\Candidate\Models\Testmst;
use Illuminate\Support\Facades\URL;



class AssessmentController extends Controller
{


	public function index(Request $request)
	{
        $currentURL = URL::full();
		$current_page = Auth::user()->current_page;
		if(strpos($currentURL,'page') && !strpos($currentURL,'backpage')){
		   if(Auth::user()->current_page !=  $currentURL) {
				return Redirect::to($current_page);
		   } 
		}
		
		$assessments = Assessment::orderBy('pq_id')->paginate(4);

		$assessments_result = AssessmentSave::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id])->orderBy('pq_id')->get(['pq_id', 'most','least']);

		

		return view('Candidate::assessment.index',["assessments" => $assessments,"assessments_result" => $assessments_result,"current_page" => $assessments->currentPage()]);


	}


	public function save(Request $request)
	{
       

	
		$assessment_data = Input::all();

		foreach($assessment_data['pqid'] as $index => $pqid) {
		

		$most = $assessment_data['mst_radio'. $pqid];
		$least = $assessment_data['lst_radio'. $pqid];
		
		/*$assessment_save = new AssessmentSave;

		$assessment_save->candidate_id =  Auth::id();
		$assessment_save->pq_id =  $pqid;
		$assessment_save->most =  $most;
		$assessment_save->least =  $least;
		$assessment_save->test_id =  Auth::user()->test_id;*/

		AssessmentSave::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id,"pq_id" => $pqid])->delete();
  
		//$assessment_update = AssessmentSave::where('candidate_id', Auth::id())->save($assessment_save);
		//if ($_SERVER['REMOTE_ADDR'] == '103.8.119.66'){
			$assessment_save_arr['candidate_id'] = Auth::id();
			$assessment_save_arr['pq_id'] = $pqid;
			$assessment_save_arr['test_id'] = Auth::user()->test_id;
			$assessment_save_arr['most'] = $most;
			$assessment_save_arr['least'] = $least;
			$asessment_update = AssessmentSave::updateOrCreate($assessment_save_arr);
		//}else{
			//$assessment_save->save();
		//}
		
		}
			if($assessment_data['nextpage']) {
				
				 $page_number_arr  =  explode('?',$assessment_data['nextpage']);
				 if($page_number_arr[1]){
					$page_num  = explode('=',$page_number_arr[1]);
					$pnumber   = $page_num[1] -1;
					if($pnumber == 1){
						History::maintainCandidateLog(12,'CANDIDATE_PQ_1');
					}else if($pnumber == 2){
						History::maintainCandidateLog(13,'CANDIDATE_PQ_2');
					}else if($pnumber == 3){
						History::maintainCandidateLog(14,'CANDIDATE_PQ_3');
					}else if($pnumber == 4){
						History::maintainCandidateLog(15,'CANDIDATE_PQ_4');
					}else if($pnumber == 5){
						History::maintainCandidateLog(16,'CANDIDATE_PQ_5');
					}else if($pnumber == 6){
						History::maintainCandidateLog(17,'CANDIDATE_PQ_6');
					}else if($pnumber == 7){
					    History::maintainCandidateLog(18,'CANDIDATE_PQ_7');
					}else if($pnumber == 8){
						History::maintainCandidateLog(19,'CANDIDATE_PQ_8');
					}
				 }
			
				$candidate_mst = Candidatemst::find(Auth::id());
				$candidate_mst->current_page = $assessment_data['nextpage'];
				$candidate_mst->save();

				return Redirect::to($assessment_data['nextpage']);		
			} else {
				History::maintainCandidateLog(8,'CANDIDATE_PQ');
				$test_id = Auth::user()->test_id;
				$candidate_id = Auth::id();
				$business_id = Auth::user()->business_id;
				$business_owner = BusinessOwner::find($business_id);
				$start_time  = $request->session()->get('start_test_time');
				$resultupdate = Result::calculateandsave($test_id,$candidate_id,$start_time);
		
				if($resultupdate) {

					$request->session()->put('completed.assessments', '1');

					$candidate_mst = Candidatemst::find($candidate_id);
					if($candidate_mst['status'] != 'Hired' && $candidate_mst['status'] != 'Terminated') {
					$candidate_mst->status = 'INCOMPLETE';
					$candidate_mst->save();

					}
					$this->businessownernotification_mail($resultupdate,$candidate_mst,$business_owner,'TEST_COMPLETION_NOTIFICATION');
				}


				$test_mst = Testmst::find(Auth::user()->test_id);

				if($test_mst->problem_solving == 1) {

					$candidate_mst = Candidatemst::find(Auth::id());
					$candidate_mst->current_page = "problemsolving/index";
					$candidate_mst->save();
					return Redirect::to("problemsolving/index");


				} else if($test_mst->short_answer == 1) {
					
					$candidate_mst = Candidatemst::find(Auth::id());
					$candidate_mst->current_page = "shortanswer/index";
					$candidate_mst->save();
					return Redirect::to("shortanswer/index");
				} else
					return Redirect::to("thankyou/index");


			}
	

	}


	public function businessownernotification_mail ($result,$candidate_mst,$business_owner,$mail_title) {

      
      $mail = Mailmst::find($mail_title);
	  $mail_data['subj'] = 	$mail->subject;
	  $mail_data['from'] = 	$mail->from_id;
	  $mail_data['to'] = $business_owner['username'];

	/*  if($candidate_mst['notification_mail']) {

		  $notification_email = explode(",",$candidate_mst['notification_mail']);
		  $users = DB::table('user_mst')
				   ->select("email")
				   ->whereIn('user_id', $notification_email)->get();

		$mail_data['notification'] = $users;


	  }	
	  
*/
		 
		  $notification_email = DB::table('business_email_notification')
				   ->select("TEST_COMPLETION_NOTIFICATION")
				   ->where('business_id', $business_owner->business_id)->first();
		
		
    if(isset($notification_email->TEST_COMPLETION_NOTIFICATION) && $notification_email->TEST_COMPLETION_NOTIFICATION != '' ){
		       $notification_arr = explode(",", $notification_email->TEST_COMPLETION_NOTIFICATION);
				$mail_data['notification'] = $notification_arr;
				
     }


	  

	  $find = array('%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%USER_NAME%','%URL%','%PROFILE_OUTCOME%');
      $replace = array($business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name,$candidate_mst->username,url('/'),$result['profile_result']);
	  $message = str_replace($find,$replace, $mail->mail_content);
	  $mail_data['content'] = $message;
	  Mail::send(['html' => 'Candidate::emails.notification'], $mail_data, function ($message) use ($mail_data, $notification_email) {

			$message->from($mail_data['from'], 'IdealTraits.com');
			if(isset($notification_email)){
			   if($notification_email->TEST_COMPLETION_NOTIFICATION != ''){
				foreach($mail_data['notification'] as $to_email) {
					$message->to($to_email,$to_email )->subject($mail_data['subj']);
				}
			   }
			}else{
			       $message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
				
			 }

		});


	}


	public function sample()
	{

		return view('Candidate::assessment.sample');


	}


}



?>