<?php
namespace App\Modules\Candidate\Traits;

use App\Modules\Candidate\Models\Candidatemst;
use App\Modules\Candidate\Models\Contactdetails;
use App\Modules\Candidate\Models\Language;
use App\Modules\Candidate\Models\Candidatewebsite;
use App\Modules\Candidate\Models\Candidateskill;
use App\Modules\Candidate\Models\Experience;
use App\Modules\Candidate\Models\Education;
use App\Modules\Candidate\Models\Candidateachievements;
use App\Modules\Candidate\Models\Candidatecertification;
use DB;
trait ResumeparserTrait {
	
	public function resumeParseBinary($encode64,$type ){
	 //Your Api Link
	 $APIURL="https://rest.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";
	  try
	  {
		 $encode64 = base64_encode($encode64);	
		 $version = "8.0.0";
		 $subUserId = "Jeremy";
		 $data = array(
					"filedata" => $encode64,
					"filename" => $type,
					"userkey" => env("RESUMEPARSER_KEY"),
					"version" => $version,
					"subuserid" => $subUserId
					);
	    $str_data = json_encode($data);	
		
		$ch = curl_init($APIURL);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                                                                     
		curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);                                                                  
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                                                                      
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(                                                                          
			'Content-Type: application/json',                                                                                
			'Content-Length: ' . strlen($str_data))                                                                       
		);  
		$result = curl_exec($ch);
		
		return $result;
		}
		 catch (Exception $e) 
		 {
			echo 'Caught exception: ',  $e->getMessage(), "\n";
		}
	   
	}
	
	function parseResume($filename='',$candidate_id)	{
		 @$stream= fopen('/var/www/html/dashboard/upload/resume/'.$filename, 'r');
		 $content = stream_get_contents($stream);
		 $jsonOutput = $this->resumeParseBinary($content,$filename);
		 $jsonOutput = json_decode($jsonOutput, true);
		 if (!isset($jsonOutput["ResumeParserData"]))
			 return;
		 $json=$jsonOutput["ResumeParserData"];
			
			
		$FirstName=(String) $json["Name"]["FirstName"];
		$LastName=(String) $json["Name"]["LastName"];					
		$DateOfBirth=(String) $json["DateOfBirth"];
		if($DateOfBirth != '')
			$DateOfBirth = date("Y-m-d", strtotime($DateOfBirth));
		$Gender=(String) $json["Gender"];
		$MaritalStatus=(String) $json["MaritalStatus"];
		$Nationality=(String) $json["Nationality"];					
		
		$present_street='';
		$present_city='';
		$present_state='';
		$present_country='';
		$present_zipcode='';
		
		$permanent_street='';
		$permanent_city='';
		$permanent_state='';
		$permanent_country='';
		$permanent_zipcode='';
		$preferred_city = '';
		$preferred_state = '';
		$preferred_country = '';
		$current_job_start_date = '';
		$current_job_end_date = '';
		$email ='';
		$telephone = '';
		$mobile = '';
		$fax = '';
		$CurrentEmployer='';
		$JobProfile='';
		$GapPeriod='';
		$current_salary_symbol =  '';
		$current_salary = '';
		$current_salary_currency = '';
		$current_salary_unit ='';
		
		$expected_salary_symbol = '';
		$expected_salary = '';
		$expected_salary_currency = '';
		$expected_salary_unit = '';
		
		foreach($json["Address"] as $address)
		{
			if ($address["Type"] == 'Present') {
				$present_street = $address["Street" ];
				$present_city = $address["City" ];
				$present_state = $address["State" ];
				$present_country = $address["Country" ];
				$present_zipcode = $address["ZipCode" ];
				
			}
			if ($address["Type"] == 'Permanent') {
				$permanent_street = $address["Street" ];
				$permanent_city = $address["City" ];
				$permanent_state = $address["State" ];
				$permanent_country = $address["Country" ];
				$permanent_zipcode = $address["ZipCode" ];					
			}
		}			
		
		foreach($json["Email"] as $eml)	{
			$email .= $eml["EmailAddress"] .",";
		}
		$email = rtrim($email, ",");
		foreach($json["PreferredLocation"] as $ploc){
			$preferred_city = $ploc["City"];
			$preferred_state = $ploc["State"];
			$preferred_country = $ploc["Country"];
		}
		
		foreach($json["PhoneNumber"] as $phone)	{
			if ($phone["Type"] == 'Phone'){
				$telephone = $phone["FormattedNumber"];
			}
			if ($phone["Type"] == 'Mobile'){
				$mobile = $phone["FormattedNumber"];
			}
			if ($phone["Type"] == 'Fax'){
				$fax = $phone["OriginalNumber"];
			}
		}
		
		$CurrentEmployer=(String) $json["CurrentEmployer"];
		$JobProfile=(String) $json["JobProfile"];
		$GapPeriod=(String) $json["GapPeriod"];			
		$TotalExperienceInMonths=(String) $json["WorkedPeriod"]["TotalExperienceInMonths"];	
		
		$Hobbies=(String) $json["Hobbies"];
		$Objectives=(String) $json["Objectives"];
		$AverageStay=(String) $json["AverageStay"];
		$LongestStay=(String) $json["LongestStay"];
		$Availability=(String) $json["Availability"];
		
		$current_salary_symbol =  $json["CurrentSalary"]["Symbol"];
		$current_salary = $json["CurrentSalary"]["Amount"];
		$current_salary_currency = $json["CurrentSalary"]["Currency"];
		$current_salary_unit = $json["CurrentSalary"]["Unit"];
		
		$expected_salary_symbol =  $json["ExpectedSalary"]["Symbol"];
		$expected_salary = $json["ExpectedSalary"]["Amount"];
		$expected_salary_currency = $json["ExpectedSalary"]["Currency"];
		$expected_salary_unit = $json["ExpectedSalary"]["Unit"];
		$skillblock=(String) $json["SkillBlock"];
		$achievementsblock=(String) $json["Achievements"];
		
		$executiveSummary=(String) $json["ExecutiveSummary"];
		$managementSummary=(String) $json["ManagementSummary"];
		
		$candidate = Candidatemst::find($candidate_id);
		$candidateDetailsDB = DB::table('candidate_details')->where('candidate_id','=',$candidate->candidate_id)->first();
	
		if (!empty($candidateDetailsDB))
			$candidateDetails = Contactdetails::find($candidateDetailsDB->detail_id);
		else		
			$candidateDetails = new Contactdetails();	
		
		$candidateDetails->candidate_id = $candidate->candidate_id;
		$candidateDetails->test_id = $candidate->test_id;
		
		$candidateDetails->gender = $Gender;
		$candidateDetails->dateofbirth = $DateOfBirth;
		$candidateDetails->MaritalStatus = $MaritalStatus;
		$candidateDetails->Nationality = $Nationality;
		
		$candidateDetails->phone_no = $mobile;
		$candidateDetails->telephone = $telephone;
		$candidateDetails->fax = $fax;
		$candidateDetails->email = $email;
		
		$candidateDetails->address = $present_street;
		$candidateDetails->city = $present_city;
		$candidateDetails->state = $present_state;
		$candidateDetails->country = $present_country;
		$candidateDetails->zip = $present_zipcode;
		
		$candidateDetails->permanent_address1 = $permanent_street;
		$candidateDetails->permanent_city = $permanent_city;
		$candidateDetails->permanent_state = $permanent_state;
		$candidateDetails->permanent_country = $permanent_country;
		$candidateDetails->permanent_pincode = $permanent_zipcode;
		
		$candidateDetails->preferred_city = $preferred_city;
		$candidateDetails->preferred_state = $preferred_state;
		$candidateDetails->preferred_country = $preferred_country;
		$candidateDetails->executive_summary = $executiveSummary;
		$candidateDetails->management_summary = $managementSummary;
		
		$current_job_start_date = null;
		$current_job_end_date = null;
		if ($GapPeriod != '') {
			$current_job_period = explode("To",$GapPeriod);
			if (trim($current_job_period[0]) != '') {
				$current_job_start_date = '01-'.str_replace("/","-",trim($current_job_period[0]));
				$current_job_start_date = date("Y-m-d", strtotime($current_job_start_date));
			}
			if (trim($current_job_period[1]) != '') {
				$current_job_end_date = '01-'.str_replace("/","-",trim($current_job_period[1]));
				$current_job_end_date = date("Y-m-d", strtotime($current_job_end_date));
			}				
		}
		
		$candidateDetails->current_employer = $CurrentEmployer;
		$candidateDetails->current_start_date = $current_job_start_date; 
		$candidateDetails->current_end_date = $current_job_end_date;
		$candidateDetails->current_duties = $JobProfile;
		$candidateDetails->TotalExperienceInMonths = $TotalExperienceInMonths;
					
		$candidateDetails->Current_Salary = $current_salary;
		$candidateDetails->Current_Currency = $current_salary_currency;
		$candidateDetails->Current_Symbol = $current_salary_symbol;
		$candidateDetails->Current_Unit = $current_salary_unit;
		
		$candidateDetails->Expected_Salary = $expected_salary;
		$candidateDetails->Expected_Currency = $expected_salary_currency;
		$candidateDetails->Expected_Symbol = $expected_salary_symbol;
		$candidateDetails->Expected_Unit = $expected_salary_unit;
		
		$candidateDetails->Hobbies = $Hobbies;
		$candidateDetails->Objectives = $Objectives;
		$candidateDetails->skills = $skillblock;
		$candidateDetails->achievements = $achievementsblock;
		$candidateDetails->AverageStay = $AverageStay;
		$candidateDetails->LongestStay = $LongestStay;
		$candidateDetails->Availability = $Availability;
		
		$candidateDetails->is_parsed = 'Y';
		
		$candidateDetails->created_on = date("Y-m-d H:m:s");
		$candidateDetails->updated_on = date("Y-m-d H:m:s");
		
		$detail_id = $candidateDetails->save();
		
		foreach($json["LanguageKnown"] as $LanguageKnown) {
			$language =trim($LanguageKnown["Language"]);
			if ($language != '') {
				$candidateLanguageDB = DB::table('candidate_language')
										->where('candidate_id','=',$candidate->candidate_id)
										->where('languages','like','%' . $language. '%' )->first();
		
				if (empty($candidateLanguageDB)){	
					$candidatelanguage = new Language();
					$candidatelanguage->candidate_id = $candidate->candidate_id;
					$candidatelanguage->detail_id = $candidateDetails->detail_id;
					$candidatelanguage->languages = $language;
					$candidatelanguage->read = '1';
					$candidatelanguage->write = '1';
					$candidatelanguage->speak = '1';
					$candidatelanguage->save();
				}
			}
		}
		
		foreach($json["WebSite"] as $Website) {
			$website_type=$Website["Type"];
			$website_url=trim($Website["Url"]);
			if ($website_url != '') {				
					$candidatewebsite = new Candidatewebsite();
					$candidatewebsite->candidate_id = $candidate->candidate_id;
					$candidatewebsite->type = $website_type;
					$candidatewebsite->url = $website_url;
					$candidatewebsite->save();				
			}
		}
		
		foreach($json["SegregatedSkill"] as $skillset){
			$skill = trim($skillset["Skill"]);
			if ($skill != '') {
				$skill_type = $skillset["Type"];
				$skill_experience_in_months =$skillset["ExperienceInMonths"];
				$skill_alias=$skillset["Alias"];
				$skill_ontology=$skillset["Ontology"];			
				
				$candidateskill = new Candidateskill();
				$candidateskill->candidate_id = $candidate->candidate_id;
				$candidateskill->type = $skill_type;
				$candidateskill->skill = $skill;
				$candidateskill->experience_in_months = $skill_experience_in_months;
				$candidateskill->alias = $skill_alias;
				$candidateskill->ontology = $skill_ontology;
				$candidateskill->save();
			}
		}
		
		
		foreach ($json["SegregatedExperience"] as $exp){
			 $employername = $exp["Employer"][ "EmployerName"];
			 $job_title = $exp["JobProfile"]["Title"];
			 $work_city =$exp["Location"]["City"];
			 $work_state =$exp["Location"]["State"];
			 $work_country =$exp["Location"]["Country"];
			
			/* $exp_start_date = trim($exp["StartDate"]);
			 $exp_end_date = trim($exp["EndDate"]);
			 $job_description = $exp["JobDescription"];
			 
			 $start_date = date("Y-m-d", strtotime($exp_start_date));
			 $end_date = date("Y-m-d", strtotime($exp_end_date));*/
			 
			 $exp_start_date = trim($exp["StartDate"]);
			 $exp_end_date = trim($exp["EndDate"]);
			 
			 $job_description = $exp["JobDescription"];
			 if($exp_start_date != '') {
				 $exp_start_date =str_replace("/","-",$exp_start_date);				 
				 $start_date = date("Y-m-d",strtotime(date("d-m-Y", strtotime($exp_start_date))));
			 } else {
				 $start_date = null;
			 }
			 if($exp_end_date != '') {
				 $exp_end_date =str_replace("/","-",$exp_end_date);
				 $end_date = date("Y-m-d",strtotime(date("d-m-Y", strtotime($exp_end_date))));
			 }else {
				 $end_date = null;
			 }
			 
			 $candidateworkexp = new Experience();
			 $candidateworkexp->candidate_id = $candidate->candidate_id;
			 $candidateworkexp->detail_id = $candidateDetails->detail_id;
			 $candidateworkexp->designation = $job_title;
			 $candidateworkexp->company = $employername;
			 $candidateworkexp->start_date = $start_date;
			 $candidateworkexp->end_date = $end_date;
			 $candidateworkexp->location = $work_city;
			 $candidateworkexp->state = $work_state;
			 $candidateworkexp->country = $work_country;
			 $candidateworkexp->description = $job_description;
			 $candidateworkexp->save();
		}
		
		foreach ($json["SegregatedQualification"] as $edu) {
			
			if(isset($edu["Institution"])) {
				$institution_name =$edu["Institution"]["Name"];
				$institution_type = $edu["Institution"]["Type"];
				$institution_city= $edu["Institution"]["Location" ]["City"];
				$institution_state=$edu["Institution"]["Location" ]["State"];
				$institution_country= $edu["Institution"]["Location" ]["Country"];
			}
			
			$degree_name = $edu["Degree"]["DegreeName" ];
			$degree_start_date = $edu["StartDate"];
			$degree_end_date = $edu["EndDate"];
			//$degree_start_date = date("Y-m-d", strtotime($degree_start_date));
			//$degree_end_date = date("Y-m-d", strtotime($degree_end_date));
			
			if($degree_start_date != '') {
				$degree_start_date =str_replace("/","-",$degree_start_date);				 
				$degree_start_date = date("Y-m-d",strtotime(date("d-m-Y", strtotime($degree_start_date))));
			} else {
				$degree_start_date = null;
			}
			
			if($degree_end_date != '') {
				$degree_end_date =str_replace("/","-",$degree_end_date);
				$degree_end_date = date("Y-m-d",strtotime(date("d-m-Y", strtotime($degree_end_date))));
			} else {
				$degree_end_date = null;
			}
			 
			$aggregate_value = '';
			$aggregate_measuretype= '';
			if($edu["Aggregate"]["Value"]) {
				$aggregate_value = $edu["Aggregate"]["Value"];
				$aggregate_measuretype= $edu["Aggregate"]["MeasureType"];						
			}	
			$candidateeducation = new Education();
			$candidateeducation->candidate_id = $candidate->candidate_id;
			$candidateeducation->detail_id = $candidateDetails->detail_id;
			$candidateeducation->degree = $degree_name;
			$candidateeducation->major = $degree_name;
			$candidateeducation->institute = $institution_name;
			$candidateeducation->type = $institution_type;
			$candidateeducation->start_date = $degree_start_date;
			$candidateeducation->end_date = $degree_end_date;
			$candidateeducation->region = $institution_city;
			$candidateeducation->state = $institution_state;
			$candidateeducation->country = $institution_country;
			$candidateeducation->aggregate_value = $aggregate_value;
			$candidateeducation->aggregate_measuretype = $aggregate_measuretype;
			$candidateeducation->save();
		}
		
		foreach($json["SegregatedAchievement"] as $achievementset){
			$achievement = trim($achievementset["AwardTitle"]);
			if ($achievement != '') {
				$achievementIssuer = trim($achievementset["Issuer"]);
				$achievementAssociatedWith = trim($achievementset["AssociatedWith"]);
				$achievementIssuingDate = trim($achievementset["IssuingDate"]);
				$achievementDescription = trim($achievementset["Description"]);
				
				//$achievementIssuingDate = date("Y-m-d", strtotime($achievementIssuingDate));	
				if($achievementIssuingDate != '') {
					$achievementIssuingDate =str_replace("/","-",$achievementIssuingDate);
					$achievementIssuingDate = date("Y-m-d",strtotime(date("d-m-Y", strtotime($achievementIssuingDate))));
				} else {
					$achievementIssuingDate = null;
				}				
				
				$candidateachievements = new Candidateachievements();
				$candidateachievements->candidate_id = $candidate->candidate_id;
				$candidateachievements->award_title = $achievement;
				$candidateachievements->issuer = $achievementIssuer;
				$candidateachievements->associated_with = $achievementAssociatedWith;
				$candidateachievements->issuing_date = $achievementIssuingDate;
				$candidateachievements->description = $achievementDescription;
				$candidateachievements->save();
				
			}
		}
		
		foreach($json["SegregatedCertification"] as $certificate){
			$certificationTitle = trim($certificate["CertificationTitle"]);
			if ($certificationTitle != '') {
				$certification_authority = trim($certificate["Authority"]);
				$certification_certificationCode= trim($certificate["CertificationCode"]);
				$certification_expiry = trim($certificate["IsExpiry"]);
				$certification_start_date = trim($certificate["StartDate"]);
				$certification_end_date = trim($certificate["EndDate"]);
				$certification_url = trim($certificate["CertificationUrl"]);
				/*if ($certification_start_date)
					$certification_start_date = date("Y-m-d", strtotime($certification_start_date));
				if ($certification_end_date)
					$certification_end_date = date("Y-m-d", strtotime($certification_end_date));*/
				if ($certification_start_date) {
					//$certification_start_date = date("Y-m-d", strtotime($certification_start_date));
					$certification_start_date =str_replace("/","-",$certification_start_date);
					$certification_start_date = date("Y-m-d",strtotime(date("d-m-Y", strtotime($certification_start_date))));
				} else {
					$certification_start_date = null;
				}
				if ($certification_end_date) {
					//$certification_end_date = date("Y-m-d", strtotime($certification_end_date));
					$certification_end_date =str_replace("/","-",$certification_end_date);
					$certification_end_date = date("Y-m-d",strtotime(date("d-m-Y", strtotime($certification_end_date))));
				} else {
					$certification_end_date = null;
				}
				
				$candidatecertification = new Candidatecertification();
				$candidatecertification->candidate_id = $candidate->candidate_id;
				$candidatecertification->certification_title = $certificationTitle;
				$candidatecertification->authority = $certification_authority;
				$candidatecertification->certification_code = $certification_certificationCode;
				$candidatecertification->isexpiry = $certification_expiry;
				$candidatecertification->start_date = $certification_start_date;
				$candidatecertification->end_date = $certification_end_date;
				$candidatecertification->certification_url = $certification_url;
				$candidatecertification->save();
				
			}
		}
		return $jsonOutput;		
	}	
}