<?php

namespace App\Modules\Candidate\Models;
use Illuminate\Database\Eloquent\Model;

class WebhookLog extends  Model {
	
	protected $table = 'webhook_logs';
	// public 	  $timestamps = false;
	protected $primaryKey = 'id';

     protected $fillable = [
        'webhook_id',
        'business_id',
        'event_type',
        'request_body', // Already there
        'status',          // <--- ADD THIS LINE
        'response_code',   // <--- ADD THIS LINE
        'response_body',   // <--- ADD THIS LINE
        'attempt_tried',   // <--- ADD THIS LINE
        'comment',         // <--- ADD THIS LINE
        // 'created_at',    // Usually not needed in fillable, Laravel handles it
        // 'updated_at',    // Usually not needed in fillable, Laravel handles it
    ];
    
	public function getRequestBodyAttribute($value)
    {
        return json_decode($value); // Automatically decode as an array
    }
	public function webhook()
    {
        return $this->belongsTo(Webhooks::class, 'webhook_id');
    }
}

?>