<?php

namespace App\Modules\Candidate\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;

class Result extends Model {
  protected $table = 'result';
  protected $primaryKey = 'result_id';
  
  const CREATED_AT = 'created_on';
  const UPDATED_AT = 'created_on';
  protected $fillable = ['test_id', 'candidate_id', 'business_id' , 'short_answer','full_name','position','iq_result','profile_id','profile_result','segment_data','chart_data','test_time','test_finish','date_gds','create_hour'];

  protected function calculateandsave ($test_id,$candidate_id,$start_time) {

	  $pq_result_arr = AssessmentSave::where(['candidate_id' => $candidate_id,'test_id' => $test_id])
						->whereNotIn('pq_id', [4,7,11,15,18,23,27])		
						->orderBy('pq_id')->get();
						
	


		$D_most_value = 0; $D_least_value = 0;

		$I_most_value = 0;	$I_least_value = 0;

		$S_most_value = 0;	$S_least_value = 0;

		$C_most_value = 0;	$C_least_value = 0;		

		if(count($pq_result_arr) > 28){
		
			
			$newArray = array(); 
			$updated_arr = array(); 
			$j=0;
			 foreach ( $pq_result_arr AS $key => $line ) {	 
				if ( !in_array($line['pq_id'], $updated_arr) ) { 
					$updated_arr[] = $line['pq_id']; 
					$newArray[$j] = $line;	
					$j = $j+1;
				}			
			 }
			 $pq_result_arr = array();
			 $pq_result_arr = $newArray;  
			
		}

		for($i=0; $i < count(($pq_result_arr)); $i++)

		{

			// canculate most value..
			/*if ($_SERVER['REMOTE_ADDR'] == '103.213.192.118'){
			    echo count($pq_result_arr);
				exit;
			    if($i < count($pq_result_arr)){
					echo $pq_result_arr[3]['most'];
				}else{
					exit;
				}
			}*/
			$most_val = $this->getMapValue($i+1, 'most', $pq_result_arr[$i]['most']);

			if ($most_val == "D") { $D_most_value++; }

			if ($most_val == "I") { $I_most_value++; }

			if ($most_val == "S") { $S_most_value++; }

			if ($most_val == "C") { $C_most_value++; }



			// canculate least value..

			$least_val = $this->getMapValue($i+1, 'least', $pq_result_arr[$i]['least']);

			if ($least_val == "D") { $D_least_value++; }

			if ($least_val == "I") { $I_least_value++; }

			if ($least_val == "S") { $S_least_value++; }

			if ($least_val == "C") { $C_least_value++; }

		}

	

		$D_chart_code_most = $this->chartCode($D_most_value, 'most', 'D');
	
		$I_chart_code_most = $this->chartCode($I_most_value, 'most', 'I');

		$S_chart_code_most = $this->chartCode($S_most_value, 'most', 'S');

		$C_chart_code_most = $this->chartCode($C_most_value, 'most', 'C');		



		$D_chart_code_least = $this->chartCode($D_least_value, 'least', 'D');

		$I_chart_code_least = $this->chartCode($I_least_value, 'least', 'I');

		$S_chart_code_least = $this->chartCode($S_least_value, 'least', 'S');

		$C_chart_code_least = $this->chartCode($C_least_value, 'least', 'C');



		// Segment Plot Data. Ex 4-1, 8-2, 12-3 etc

		$D_most_segment_value = $this->segmentPlotData($D_chart_code_most);

		$I_most_segment_value = $this->segmentPlotData($I_chart_code_most);

		$S_most_segment_value = $this->segmentPlotData($S_chart_code_most);

		$C_most_segment_value = $this->segmentPlotData($C_chart_code_most);



		$D_least_segment_value = $this->segmentPlotData($D_chart_code_least);

		$I_least_segment_value = $this->segmentPlotData($I_chart_code_least);

		$S_least_segment_value = $this->segmentPlotData($S_chart_code_least);

		$C_least_segment_value = $this->segmentPlotData($C_chart_code_least);



		// Diffrence Code Calculated

		$D_chart_code_diff = $D_most_value - $D_least_value;

		$I_chart_code_diff = $I_most_value - $I_least_value;

		$S_chart_code_diff = $S_most_value - $S_least_value;

		$C_chart_code_diff = $C_most_value - $C_least_value;



		$D_chart_code_diff = $this->chartDiffCode($D_chart_code_diff, 'D');

		$I_chart_code_diff = $this->chartDiffCode($I_chart_code_diff, 'I');

		$S_chart_code_diff = $this->chartDiffCode($S_chart_code_diff, 'S');

		$C_chart_code_diff = $this->chartDiffCode($C_chart_code_diff, 'C');



		$D_diff_segment_value = $this->segmentPlotData($D_chart_code_diff);

		$I_diff_segment_value = $this->segmentPlotData($I_chart_code_diff);

		$S_diff_segment_value = $this->segmentPlotData($S_chart_code_diff);

		$C_diff_segment_value = $this->segmentPlotData($C_chart_code_diff);



		// Insert into Result table with segment_plot_data & Char code.

		$chart_data_array = array();

		$chart_data_array['most']['D']  = $D_chart_code_most;

		$chart_data_array['most']['I']  = $I_chart_code_most;

		$chart_data_array['most']['S']  = $S_chart_code_most;

		$chart_data_array['most']['C']  = $C_chart_code_most;

		$chart_data_array['least']['D'] = $D_chart_code_least;

		$chart_data_array['least']['I'] = $I_chart_code_least;

		$chart_data_array['least']['S'] = $S_chart_code_least;

		$chart_data_array['least']['C'] = $C_chart_code_least;

		$chart_data_array['diff']['D']  = $D_chart_code_diff;

		$chart_data_array['diff']['I']  = $I_chart_code_diff;

		$chart_data_array['diff']['S']  = $S_chart_code_diff;

		$chart_data_array['diff']['C']  = $C_chart_code_diff;



		$segment_data_array				  = array();

		$segment_data_array['most']['D']  = $D_most_segment_value;

		$segment_data_array['most']['I']  = $I_most_segment_value;

		$segment_data_array['most']['S']  = $S_most_segment_value;

		$segment_data_array['most']['C']  = $C_most_segment_value;

		$segment_data_array['least']['D'] = $D_least_segment_value;

		$segment_data_array['least']['I'] = $I_least_segment_value;

		$segment_data_array['least']['S'] = $S_least_segment_value;

		$segment_data_array['least']['C'] = $C_least_segment_value;

		$segment_data_array['diff']['D']  = $D_diff_segment_value;

		$segment_data_array['diff']['I']  = $I_diff_segment_value;

		$segment_data_array['diff']['S']  = $S_diff_segment_value;

		$segment_data_array['diff']['C']  = $C_diff_segment_value;

		// Delete old result & add new result in database.

		//Result::where(['candidate_id' => $candidate_id,'test_id' => $test_id])->delete();
		Result::where('candidate_id' ,'=', $candidate_id)->delete();

		// least segment value

		$least_segment_value = $D_least_segment_value . $I_least_segment_value . $S_least_segment_value . $C_least_segment_value;

		$rowset_profile = Profilemst::where(['segment_code' => $least_segment_value])->get();
		$profile_id		 = $rowset_profile[0]['profile_id'];
		$business_id = Auth::user()->business_id;
		
		
		$profilevalue_res = $this->getProfileValue($business_id, $profile_id);
        $profile_result	 = $profilevalue_res->profilevalue_title; 
   
		//$profile_result	 = $rowset_profile[0]['profile_value'];

		
		//removed recently on Oct 31, 2022 by suveha
		
		/*if ($profile_id != '10' || $profile_id != '17' || $profile_id != '18')
		{

			$business_owner = BusinessOwner::find($business_id);

			$business_credit = $business_owner->credit;

			if($business_credit != 'UNLIMITED') {

					BusinessOwner::find($business_id)->decrement('credit');
			}

		}*/


		$postition_title = Position::find(Testmst::find($test_id)->position_id)->position_title;
		
		$date1 = date("Y-m-d H:i:s"); 
		$date2 = $start_time;
		$diff = abs(strtotime($date2) - strtotime($date1)); 
		
		$years   = floor($diff / (365*60*60*24));
		$months  = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
		$days    = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));
		$hours   = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24 - $days*60*60*24)/ (60*60)); 
		$minuts  = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24 - $days*60*60*24 - $hours*60*60)/ 60); 
		$seconds = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24 - $days*60*60*24 - $hours*60*60 - $minuts*60)); 
		
		/*if ($_SERVER['REMOTE_ADDR'] == '114.69.235.19') {
				 echo 'date1:'.$date1.'</br>';
				 echo 'date2:'.$date2.'</br>';
				  echo 'diff:'.$diff.'</br>';
				   echo 'hours:'.$hours.'</br>';
				    echo 'minuts:'.$minuts.'</br>';
					echo 'seconds:'.$seconds.'</br>';
				//echo $newFilename		= $time  . '.' . $ext;
				
        }*/
	

		$elapsedtime =  $hours . " : ". $minuts ." : ". $seconds;


		$result['test_id']			= $test_id;		
		$result['candidate_id']		= $candidate_id;
		$result['business_id']		= $business_id;
		$result['full_name']		=  Auth::user()->first_name . " " . Auth::user()->last_name;
		$result['position']			= $postition_title;
		$result['short_answer']		= 1;
		$result['profile_id']		= $profile_id;
		$result['profile_result']	= $profile_result;
		$result['iq_result']	= $this->iqResult($test_id, $candidate_id);
		$result['segment_data']		= serialize($segment_data_array);
		$result['chart_data']		= serialize($chart_data_array);
		$result['test_time']        = $elapsedtime;
		//$result['test_finish']		= "Y";
		date_default_timezone_set('US/Eastern');
		$currentDate = Carbon::now();
		$result['created_on'] = $currentDate;
		$result['date_gds'] = $currentDate->format('Y-m-d');
		$result['create_hour'] = $currentDate->format('h A');
		
		$resultupdate = Result::updateOrCreate($result);
		
		//$chart_data_arr = unserialize($resultupdate->chart_data);

		$data['most-d'] = $chart_data_array['most']['D'];
		$data['most-i'] = $chart_data_array['most']['I'];	
		$data['most-s'] = $chart_data_array['most']['S'];	
		$data['most-c'] = $chart_data_array['most']['C'];	
		$data['least-d'] = $chart_data_array['least']['D'];	
		$data['least-i'] = $chart_data_array['least']['I'];	
		$data['least-s'] = $chart_data_array['least']['S'];	
		$data['least-c'] = $chart_data_array['least']['C'];
		

		$data['diff-d'] = $chart_data_array['diff']['D'];	
		$data['diff-i'] = $chart_data_array['diff']['I'];	
		$data['diff-s'] = $chart_data_array['diff']['S'];	
		$data['diff-c'] = $chart_data_array['diff']['C'];
		
		$SP_M = round($data['most-d']*3.57142);
		$SP_P = round($data['most-i']*3.57142);
		$SP_S = round($data['most-s']*3.57142);
		$SP_T = round($data['most-c']*3.57142);
		
		$UP_M = round($data['least-d']*3.57142);
		$UP_P = round($data['least-i']*3.57142);
		$UP_S = round($data['least-s']*3.57142);
		$UP_T = round($data['least-c']*3.57142);
		
		$OP_M = round($data['diff-d']*3.57142);
		$OP_P = round($data['diff-i'] *3.57142);
		$OP_S = round($data['diff-s']*3.57142);
		$OP_T = round($data['diff-c']*3.57142);
		
		/*$fields['SP_M'] = $SP_M;
		$fields['SP_P'] = $SP_P;
		$fields['SP_S'] = $SP_S;
		$fields['SP_T'] = $SP_T;
		$fields['UP_M'] = $UP_M;
		$fields['UP_P'] = $UP_P;
		$fields['UP_S'] = $UP_S;
		$fields['UP_T'] = $UP_T;
		$fields['OP_M'] = $OP_M;
		$fields['OP_P'] = $OP_P;
		$fields['OP_S'] = $OP_S;
		$fields['OP_T'] = $OP_T;*/
		
		Result::where('candidate_id','=',$candidate_id)
		->update(['SP_M' => $SP_M,'SP_P' => $SP_P,'SP_S' => $SP_S,'SP_T' => $SP_T,
			'UP_M' => $UP_M,'UP_P' => $UP_P,'UP_S' => $UP_S,'UP_T' => $UP_T,
			'OP_M' => $OP_M,'OP_P' => $OP_P,'OP_S' => $OP_S,'OP_T' => $OP_T]);
		/*if ($_SERVER['REMOTE_ADDR'] == '103.104.127.221'){

			echo "<pre>";
			print_r($result);
			exit;
		}
*/

		return $resultupdate;


  }
  
  
  
  protected function thankyoucalculateandsave ($test_id,$candidate_id,$start_time) {

	  $pq_result_arr = AssessmentSave::where(['candidate_id' => $candidate_id,'test_id' => $test_id])
						->whereNotIn('pq_id', [4,7,11,15,18,23,27])		
						->orderBy('pq_id')->get();


		$D_most_value = 0; $D_least_value = 0;

		$I_most_value = 0;	$I_least_value = 0;

		$S_most_value = 0;	$S_least_value = 0;

		$C_most_value = 0;	$C_least_value = 0;		

		if(count($pq_result_arr) > 28){
		
			
			$newArray = array(); 
			$updated_arr = array(); 
			$j=0;
			 foreach ( $pq_result_arr AS $key => $line ) {	 
				if ( !in_array($line['pq_id'], $updated_arr) ) { 
					$updated_arr[] = $line['pq_id']; 
					$newArray[$j] = $line;	
					$j = $j+1;
				}			
			 }
			 $pq_result_arr = array();
			 $pq_result_arr = $newArray;  
			
		}

		for($i=0; $i < count(($pq_result_arr)); $i++)

		{

			// canculate most value..
				
			$most_val = $this->getMapValue($i+1, 'most', $pq_result_arr[$i]['most']);

			if ($most_val == "D") { $D_most_value++; }

			if ($most_val == "I") { $I_most_value++; }

			if ($most_val == "S") { $S_most_value++; }

			if ($most_val == "C") { $C_most_value++; }



			// canculate least value..

			$least_val = $this->getMapValue($i+1, 'least', $pq_result_arr[$i]['least']);

			if ($least_val == "D") { $D_least_value++; }

			if ($least_val == "I") { $I_least_value++; }

			if ($least_val == "S") { $S_least_value++; }

			if ($least_val == "C") { $C_least_value++; }

		}

	

		$D_chart_code_most = $this->chartCode($D_most_value, 'most', 'D');
	
		$I_chart_code_most = $this->chartCode($I_most_value, 'most', 'I');

		$S_chart_code_most = $this->chartCode($S_most_value, 'most', 'S');

		$C_chart_code_most = $this->chartCode($C_most_value, 'most', 'C');		



		$D_chart_code_least = $this->chartCode($D_least_value, 'least', 'D');

		$I_chart_code_least = $this->chartCode($I_least_value, 'least', 'I');

		$S_chart_code_least = $this->chartCode($S_least_value, 'least', 'S');

		$C_chart_code_least = $this->chartCode($C_least_value, 'least', 'C');



		// Segment Plot Data. Ex 4-1, 8-2, 12-3 etc

		$D_most_segment_value = $this->segmentPlotData($D_chart_code_most);

		$I_most_segment_value = $this->segmentPlotData($I_chart_code_most);

		$S_most_segment_value = $this->segmentPlotData($S_chart_code_most);

		$C_most_segment_value = $this->segmentPlotData($C_chart_code_most);



		$D_least_segment_value = $this->segmentPlotData($D_chart_code_least);

		$I_least_segment_value = $this->segmentPlotData($I_chart_code_least);

		$S_least_segment_value = $this->segmentPlotData($S_chart_code_least);

		$C_least_segment_value = $this->segmentPlotData($C_chart_code_least);



		// Diffrence Code Calculated

		$D_chart_code_diff = $D_most_value - $D_least_value;

		$I_chart_code_diff = $I_most_value - $I_least_value;

		$S_chart_code_diff = $S_most_value - $S_least_value;

		$C_chart_code_diff = $C_most_value - $C_least_value;



		$D_chart_code_diff = $this->chartDiffCode($D_chart_code_diff, 'D');

		$I_chart_code_diff = $this->chartDiffCode($I_chart_code_diff, 'I');

		$S_chart_code_diff = $this->chartDiffCode($S_chart_code_diff, 'S');

		$C_chart_code_diff = $this->chartDiffCode($C_chart_code_diff, 'C');



		$D_diff_segment_value = $this->segmentPlotData($D_chart_code_diff);

		$I_diff_segment_value = $this->segmentPlotData($I_chart_code_diff);

		$S_diff_segment_value = $this->segmentPlotData($S_chart_code_diff);

		$C_diff_segment_value = $this->segmentPlotData($C_chart_code_diff);



		// Insert into Result table with segment_plot_data & Char code.

		$chart_data_array = array();

		$chart_data_array['most']['D']  = $D_chart_code_most;

		$chart_data_array['most']['I']  = $I_chart_code_most;

		$chart_data_array['most']['S']  = $S_chart_code_most;

		$chart_data_array['most']['C']  = $C_chart_code_most;

		$chart_data_array['least']['D'] = $D_chart_code_least;

		$chart_data_array['least']['I'] = $I_chart_code_least;

		$chart_data_array['least']['S'] = $S_chart_code_least;

		$chart_data_array['least']['C'] = $C_chart_code_least;

		$chart_data_array['diff']['D']  = $D_chart_code_diff;

		$chart_data_array['diff']['I']  = $I_chart_code_diff;

		$chart_data_array['diff']['S']  = $S_chart_code_diff;

		$chart_data_array['diff']['C']  = $C_chart_code_diff;



		$segment_data_array				  = array();

		$segment_data_array['most']['D']  = $D_most_segment_value;

		$segment_data_array['most']['I']  = $I_most_segment_value;

		$segment_data_array['most']['S']  = $S_most_segment_value;

		$segment_data_array['most']['C']  = $C_most_segment_value;

		$segment_data_array['least']['D'] = $D_least_segment_value;

		$segment_data_array['least']['I'] = $I_least_segment_value;

		$segment_data_array['least']['S'] = $S_least_segment_value;

		$segment_data_array['least']['C'] = $C_least_segment_value;

		$segment_data_array['diff']['D']  = $D_diff_segment_value;

		$segment_data_array['diff']['I']  = $I_diff_segment_value;

		$segment_data_array['diff']['S']  = $S_diff_segment_value;

		$segment_data_array['diff']['C']  = $C_diff_segment_value;

		// Delete old result & add new result in database.

		Result::where(['candidate_id' => $candidate_id,'test_id' => $test_id])->delete();

		// least segment value

		$least_segment_value = $D_least_segment_value . $I_least_segment_value . $S_least_segment_value . $C_least_segment_value;

		$rowset_profile = Profilemst::where(['segment_code' => $least_segment_value])->get();
		$profile_id		 = $rowset_profile[0]['profile_id'];
		$business_id = Auth::user()->business_id;
		
		
		$profilevalue_res = $this->getProfileValue($business_id, $profile_id);
        $profile_result	 = $profilevalue_res->profilevalue_title; 
   
		//$profile_result	 = $rowset_profile[0]['profile_value'];

		
			
		/*if ($profile_id != '10' || $profile_id != '17' || $profile_id != '18')
		{

			$business_owner = BusinessOwner::find($business_id);

			$business_credit = $business_owner->credit;

			if($business_credit != 'UNLIMITED') {

					BusinessOwner::find($business_id)->decrement('credit');
			}

		}*/


		$postition_title = Position::find(Testmst::find($test_id)->position_id)->position_title;
		
		$date1 = date("Y-m-d H:i:s"); 
		$date2 = $start_time;
		$diff = abs(strtotime($date2) - strtotime($date1)); 
		
		$years   = floor($diff / (365*60*60*24));
		$months  = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
		$days    = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));
		$hours   = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24 - $days*60*60*24)/ (60*60)); 
		$minuts  = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24 - $days*60*60*24 - $hours*60*60)/ 60); 
		$seconds = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24 - $days*60*60*24 - $hours*60*60 - $minuts*60)); 
		
		/*if ($_SERVER['REMOTE_ADDR'] == '114.69.235.19') {
				 echo 'date1:'.$date1.'</br>';
				 echo 'date2:'.$date2.'</br>';
				  echo 'diff:'.$diff.'</br>';
				   echo 'hours:'.$hours.'</br>';
				    echo 'minuts:'.$minuts.'</br>';
					echo 'seconds:'.$seconds.'</br>';
				//echo $newFilename		= $time  . '.' . $ext;
				
        }*/
	

		$elapsedtime =  $hours . " : ". $minuts ." : ". $seconds;


		$result['test_id']			= $test_id;		
		$result['candidate_id']		= $candidate_id;
		$result['business_id']		= $business_id;
		$result['full_name']		=  Auth::user()->first_name . " " . Auth::user()->last_name;
		$result['position']			= $postition_title;
		$result['short_answer']		= 1;
		$result['profile_id']		= $profile_id;
		$result['profile_result']	= $profile_result;
		$result['iq_result']	= $this->iqResult($test_id, $candidate_id);
		$result['segment_data']		= serialize($segment_data_array);
		$result['chart_data']		= serialize($chart_data_array);
		$result['test_time']        = $elapsedtime;
		$result['test_finish']		= "Y";

		date_default_timezone_set('US/Eastern');
		$currentDate = Carbon::now();
		$result['created_on'] = $currentDate;
		$result['date_gds'] = $currentDate->format('Y-m-d');
		$result['create_hour'] = $currentDate->format('h A');

		
		$resultupdate = Result::updateOrCreate($result);
		
		$data['most-d'] = $chart_data_array['most']['D'];
		$data['most-i'] = $chart_data_array['most']['I'];	
		$data['most-s'] = $chart_data_array['most']['S'];	
		$data['most-c'] = $chart_data_array['most']['C'];	
		$data['least-d'] = $chart_data_array['least']['D'];	
		$data['least-i'] = $chart_data_array['least']['I'];	
		$data['least-s'] = $chart_data_array['least']['S'];	
		$data['least-c'] = $chart_data_array['least']['C'];
		

		$data['diff-d'] = $chart_data_array['diff']['D'];	
		$data['diff-i'] = $chart_data_array['diff']['I'];	
		$data['diff-s'] = $chart_data_array['diff']['S'];	
		$data['diff-c'] = $chart_data_array['diff']['C'];
		
		$SP_M = round($data['most-d']*3.57142);
		$SP_P = round($data['most-i']*3.57142);
		$SP_S = round($data['most-s']*3.57142);
		$SP_T = round($data['most-c']*3.57142);
		
		$UP_M = round($data['least-d']*3.57142);
		$UP_P = round($data['least-i']*3.57142);
		$UP_S = round($data['least-s']*3.57142);
		$UP_T = round($data['least-c']*3.57142);
		
		$OP_M = round($data['diff-d']*3.57142);
		$OP_P = round($data['diff-i'] *3.57142);
		$OP_S = round($data['diff-s']*3.57142);
		$OP_T = round($data['diff-c']*3.57142);
		
		/*$fields['SP_M'] = $SP_M;
		$fields['SP_P'] = $SP_P;
		$fields['SP_S'] = $SP_S;
		$fields['SP_T'] = $SP_T;
		$fields['UP_M'] = $UP_M;
		$fields['UP_P'] = $UP_P;
		$fields['UP_S'] = $UP_S;
		$fields['UP_T'] = $UP_T;
		$fields['OP_M'] = $OP_M;
		$fields['OP_P'] = $OP_P;
		$fields['OP_S'] = $OP_S;
		$fields['OP_T'] = $OP_T;*/
		
		Result::where('candidate_id','=',$candidate_id)
		->update(['SP_M' => $SP_M,'SP_P' => $SP_P,'SP_S' => $SP_S,'SP_T' => $SP_T,
			'UP_M' => $UP_M,'UP_P' => $UP_P,'UP_S' => $UP_S,'UP_T' => $UP_T,
			'OP_M' => $OP_M,'OP_P' => $OP_P,'OP_S' => $OP_S,'OP_T' => $OP_T]);

		return $resultupdate;


  }
  
  


  public function iqResult($test_id, $candidate_id)

	{

		
		
		
		$correct_count = ProblemsolvingSave::where(['test_id' => $test_id, 'candidate_id' => $candidate_id , 'result' => 'Correct' ])->count();
		
		/*

		0 - 9		NEEDS DIRECTION - FOLLOWER

		10 to 12	INDEPENDENT THINKER - LIKES A CHALLENGE

		13 to 15	THINKS OUTSIDE THE BOX - LEADER

		*/


		if ($correct_count < 10)
			return "NEEDS HELP  WITH PROBLEM SOLVING";   //return "NEEDS DIRECTION - FOLLOWER";
		elseif ($correct_count >= 10 && $correct_count < 13)
			return "ADEQUATE PROBLEM SOLVING SKILLS";   //return "INDEPENDENT THINKER - LIKES A CHALLENGE";
		elseif ($correct_count >= 13)
			return "GREAT PROBLEM SOLVING SKILLS";  	//return "THINKS OUTSIDE THE BOX - LEADER";

	}



	public function getMapValue($question_id, $identifier, $option)

	{

		/*

		Square	- I represent

		Star	- C represent		

		Z		- D represent

		$		- S represent

		*/		

		$option_value_array = array();


		$option_value_array[1]['most'][1] = 'I';

		$option_value_array[1]['most'][2] = 'D';

		$option_value_array[1]['most'][3] = 'C';

		$option_value_array[1]['most'][4] = 'S';		


		$option_value_array[1]['least'][1] = 'I';

		$option_value_array[1]['least'][2] = 'D';

		$option_value_array[1]['least'][3] = 'C';

		$option_value_array[1]['least'][4] = 'S';



		$option_value_array[2]['most'][1] = 'C';

		$option_value_array[2]['most'][2] = 'D';

		$option_value_array[2]['most'][3] = 'I';

		$option_value_array[2]['most'][4] = 'S';

		$option_value_array[2]['least'][1] = 'C';

		$option_value_array[2]['least'][2] = 'D';

		$option_value_array[2]['least'][3] = 'I';

		$option_value_array[2]['least'][4] = 'N';



		$option_value_array[3]['most'][1] = 'I';

		$option_value_array[3]['most'][2] = 'C';

		$option_value_array[3]['most'][3] = 'D';

		$option_value_array[3]['most'][4] = 'N';		

		$option_value_array[3]['least'][1] = 'N';

		$option_value_array[3]['least'][2] = 'C';

		$option_value_array[3]['least'][3] = 'D';

		$option_value_array[3]['least'][4] = 'S';



		$option_value_array[4]['most'][1] = 'I';

		$option_value_array[4]['most'][2] = 'C';

		$option_value_array[4]['most'][3] = 'S';

		$option_value_array[4]['most'][4] = 'D';		

		$option_value_array[4]['least'][1] = 'I';

		$option_value_array[4]['least'][2] = 'C';

		$option_value_array[4]['least'][3] = 'S';

		$option_value_array[4]['least'][4] = 'D';

		

		$option_value_array[5]['most'][1] = 'D';

		$option_value_array[5]['most'][2] = 'C';

		$option_value_array[5]['most'][3] = 'I';

		$option_value_array[5]['most'][4] = 'S';		

		$option_value_array[5]['least'][1] = 'D';

		$option_value_array[5]['least'][2] = 'C';

		$option_value_array[5]['least'][3] = 'I';

		$option_value_array[5]['least'][4] = 'S';



		$option_value_array[6]['most'][1] = 'S';

		$option_value_array[6]['most'][2] = 'I';

		$option_value_array[6]['most'][3] = 'N';

		$option_value_array[6]['most'][4] = 'N';		

		$option_value_array[6]['least'][1] = 'S';

		$option_value_array[6]['least'][2] = 'N';

		$option_value_array[6]['least'][3] = 'C';

		$option_value_array[6]['least'][4] = 'D';



		$option_value_array[7]['most'][1] = 'I';

		$option_value_array[7]['most'][2] = 'C';

		$option_value_array[7]['most'][3] = 'D';

		$option_value_array[7]['most'][4] = 'N';		

		$option_value_array[7]['least'][1] = 'I';

		$option_value_array[7]['least'][2] = 'C';

		$option_value_array[7]['least'][3] = 'D';

		$option_value_array[7]['least'][4] = 'S';



		$option_value_array[8]['most'][1] = 'I';

		$option_value_array[8]['most'][2] = 'C';

		$option_value_array[8]['most'][3] = 'S';

		$option_value_array[8]['most'][4] = 'D';		

		$option_value_array[8]['least'][1] = 'I';

		$option_value_array[8]['least'][2] = 'N';

		$option_value_array[8]['least'][3] = 'S';

		$option_value_array[8]['least'][4] = 'D';		



		$option_value_array[9]['most'][1] = 'C';

		$option_value_array[9]['most'][2] = 'S';

		$option_value_array[9]['most'][3] = 'I';

		$option_value_array[9]['most'][4] = 'D';		

		$option_value_array[9]['least'][1] = 'C';

		$option_value_array[9]['least'][2] = 'S';

		$option_value_array[9]['least'][3] = 'I';

		$option_value_array[9]['least'][4] = 'D';



		$option_value_array[10]['most'][1] = 'D';

		$option_value_array[10]['most'][2] = 'I';

		$option_value_array[10]['most'][3] = 'S';

		$option_value_array[10]['most'][4] = 'N';		

		$option_value_array[10]['least'][1] = 'D';

		$option_value_array[10]['least'][2] = 'I';

		$option_value_array[10]['least'][3] = 'S';

		$option_value_array[10]['least'][4] = 'C';



		$option_value_array[11]['most'][1] = 'C';

		$option_value_array[11]['most'][2] = 'S';

		$option_value_array[11]['most'][3] = 'D';

		$option_value_array[11]['most'][4] = 'I';		

		$option_value_array[11]['least'][1] = 'C';

		$option_value_array[11]['least'][2] = 'S';

		$option_value_array[11]['least'][3] = 'D';

		$option_value_array[11]['least'][4] = 'I';



		$option_value_array[12]['most'][1] = 'I';

		$option_value_array[12]['most'][2] = 'S';

		$option_value_array[12]['most'][3] = 'C';

		$option_value_array[12]['most'][4] = 'D';		

		$option_value_array[12]['least'][1] = 'I';

		$option_value_array[12]['least'][2] = 'S';

		$option_value_array[12]['least'][3] = 'C';

		$option_value_array[12]['least'][4] = 'D';		



		$option_value_array[13]['most'][1] = 'D';

		$option_value_array[13]['most'][2] = 'S';

		$option_value_array[13]['most'][3] = 'I';

		$option_value_array[13]['most'][4] = 'C';		

		$option_value_array[13]['least'][1] = 'D';

		$option_value_array[13]['least'][2] = 'S';

		$option_value_array[13]['least'][3] = 'I';

		$option_value_array[13]['least'][4] = 'C';



		$option_value_array[14]['most'][1] = 'C';

		$option_value_array[14]['most'][2] = 'S';

		$option_value_array[14]['most'][3] = 'D';

		$option_value_array[14]['most'][4] = 'I';		

		$option_value_array[14]['least'][1] = 'C';

		$option_value_array[14]['least'][2] = 'S';

		$option_value_array[14]['least'][3] = 'D';

		$option_value_array[14]['least'][4] = 'I';



		$option_value_array[15]['most'][1] = 'I';

		$option_value_array[15]['most'][2] = 'C';

		$option_value_array[15]['most'][3] = 'D';

		$option_value_array[15]['most'][4] = 'S';		

		$option_value_array[15]['least'][1] = 'I';

		$option_value_array[15]['least'][2] = 'N';

		$option_value_array[15]['least'][3] = 'D';

		$option_value_array[15]['least'][4] = 'S';



		$option_value_array[16]['most'][1] = 'C';

		$option_value_array[16]['most'][2] = 'D';

		$option_value_array[16]['most'][3] = 'S';

		$option_value_array[16]['most'][4] = 'I';		

		$option_value_array[16]['least'][1] = 'C';

		$option_value_array[16]['least'][2] = 'D';

		$option_value_array[16]['least'][3] = 'S';

		$option_value_array[16]['least'][4] = 'I';



		$option_value_array[17]['most'][1] = 'I';

		$option_value_array[17]['most'][2] = 'S';

		$option_value_array[17]['most'][3] = 'D';

		$option_value_array[17]['most'][4] = 'C';		

		$option_value_array[17]['least'][1] = 'I';

		$option_value_array[17]['least'][2] = 'S';

		$option_value_array[17]['least'][3] = 'D';

		$option_value_array[17]['least'][4] = 'C';



		$option_value_array[18]['most'][1] = 'S';

		$option_value_array[18]['most'][2] = 'D';

		$option_value_array[18]['most'][3] = 'C';

		$option_value_array[18]['most'][4] = 'I';		

		$option_value_array[18]['least'][1] = 'S';

		$option_value_array[18]['least'][2] = 'N';

		$option_value_array[18]['least'][3] = 'C';

		$option_value_array[18]['least'][4] = 'I';



		$option_value_array[19]['most'][1] = 'D';

		$option_value_array[19]['most'][2] = 'I';

		$option_value_array[19]['most'][3] = 'S';

		$option_value_array[19]['most'][4] = 'N';		

		$option_value_array[19]['least'][1] = 'D';

		$option_value_array[19]['least'][2] = 'I';

		$option_value_array[19]['least'][3] = 'S';

		$option_value_array[19]['least'][4] = 'C';



		$option_value_array[20]['most'][1] = 'I';

		$option_value_array[20]['most'][2] = 'S';

		$option_value_array[20]['most'][3] = 'N';

		$option_value_array[20]['most'][4] = 'D';		

		$option_value_array[20]['least'][1] = 'I';

		$option_value_array[20]['least'][2] = 'S';

		$option_value_array[20]['least'][3] = 'C';

		$option_value_array[20]['least'][4] = 'D';



		$option_value_array[21]['most'][1] = 'C';

		$option_value_array[21]['most'][2] = 'S';

		$option_value_array[21]['most'][3] = 'I';

		$option_value_array[21]['most'][4] = 'D';		

		$option_value_array[21]['least'][1] = 'C';

		$option_value_array[21]['least'][2] = 'S';

		$option_value_array[21]['least'][3] = 'I';

		$option_value_array[21]['least'][4] = 'D';



		$option_value_array[22]['most'][1] = 'I';

		$option_value_array[22]['most'][2] = 'C';

		$option_value_array[22]['most'][3] = 'D';

		$option_value_array[22]['most'][4] = 'S';		

		$option_value_array[22]['least'][1] = 'I';

		$option_value_array[22]['least'][2] = 'C';

		$option_value_array[22]['least'][3] = 'D';

		$option_value_array[22]['least'][4] = 'S';



		$option_value_array[23]['most'][1] = 'I';

		$option_value_array[23]['most'][2] = 'C';

		$option_value_array[23]['most'][3] = 'D';

		$option_value_array[23]['most'][4] = 'S';		

		$option_value_array[23]['least'][1] = 'I';

		$option_value_array[23]['least'][2] = 'C';

		$option_value_array[23]['least'][3] = 'D';

		$option_value_array[23]['least'][4] = 'S';



		$option_value_array[24]['most'][1] = 'I';

		$option_value_array[24]['most'][2] = 'S';

		$option_value_array[24]['most'][3] = 'D';

		$option_value_array[24]['most'][4] = 'C';		

		$option_value_array[24]['least'][1] = 'I';

		$option_value_array[24]['least'][2] = 'S';

		$option_value_array[24]['least'][3] = 'D';

		$option_value_array[24]['least'][4] = 'C';



		$option_value_array[25]['most'][1] = 'D';

		$option_value_array[25]['most'][2] = 'C';

		$option_value_array[25]['most'][3] = 'S';

		$option_value_array[25]['most'][4] = 'I';		

		$option_value_array[25]['least'][1] = 'D';

		$option_value_array[25]['least'][2] = 'C';

		$option_value_array[25]['least'][3] = 'S';

		$option_value_array[25]['least'][4] = 'I';



		$option_value_array[26]['most'][1] = 'I';

		$option_value_array[26]['most'][2] = 'C';

		$option_value_array[26]['most'][3] = 'D';

		$option_value_array[26]['most'][4] = 'S';		

		$option_value_array[26]['least'][1] = 'I';

		$option_value_array[26]['least'][2] = 'C';

		$option_value_array[26]['least'][3] = 'D';

		$option_value_array[26]['least'][4] = 'S';



		$option_value_array[27]['most'][1] = 'D';

		$option_value_array[27]['most'][2] = 'S';

		$option_value_array[27]['most'][3] = 'I';

		$option_value_array[27]['most'][4] = 'C';		

		$option_value_array[27]['least'][1] = 'D';

		$option_value_array[27]['least'][2] = 'S';

		$option_value_array[27]['least'][3] = 'I';

		$option_value_array[27]['least'][4] = 'C';



		$option_value_array[28]['most'][1] = 'C';

		$option_value_array[28]['most'][2] = 'D';

		$option_value_array[28]['most'][3] = 'I';

		$option_value_array[28]['most'][4] = 'S';		

		$option_value_array[28]['least'][1] = 'C';

		$option_value_array[28]['least'][2] = 'D';

		$option_value_array[28]['least'][3] = 'I';

		$option_value_array[28]['least'][4] = 'S';



		return $option_value_array[$question_id][$identifier][$option];

	}



	public function chartCode($column_total, $identifier, $option)

	{

		$chart_code_most = array();

		$chart_code_most[0]['most']['D'] = 3;

		$chart_code_most[0]['most']['I'] = 1;

		$chart_code_most[0]['most']['S'] = 1;

		$chart_code_most[0]['most']['C'] = 1;

		$chart_code_most[0]['least']['D'] = 28;

		$chart_code_most[0]['least']['I'] = 28;

		$chart_code_most[0]['least']['S'] = 28;

		$chart_code_most[0]['least']['C'] = 28;



		$chart_code_most[1]['most']['D'] = 6;

		$chart_code_most[1]['most']['I'] = 2;

		$chart_code_most[1]['most']['S'] = 2;

		$chart_code_most[1]['most']['C'] = 2;

		$chart_code_most[1]['least']['D'] = 28;

		$chart_code_most[1]['least']['I'] = 26;

		$chart_code_most[1]['least']['S'] = 26;

		$chart_code_most[1]['least']['C'] = 27;



		$chart_code_most[2]['most']['D'] = 9;

		$chart_code_most[2]['most']['I'] = 4;

		$chart_code_most[2]['most']['S'] = 3;

		$chart_code_most[2]['most']['C'] = 4;

		$chart_code_most[2]['least']['D'] = 27;

		$chart_code_most[2]['least']['I'] = 25;

		$chart_code_most[2]['least']['S'] = 22;

		$chart_code_most[2]['least']['C'] = 26;



		$chart_code_most[3]['most']['D'] = 12;

		$chart_code_most[3]['most']['I'] = 6;

		$chart_code_most[3]['most']['S'] = 4;

		$chart_code_most[3]['most']['C'] = 7;

		$chart_code_most[3]['least']['D'] = 26;

		$chart_code_most[3]['least']['I'] = 23;

		$chart_code_most[3]['least']['S'] = 18;

		$chart_code_most[3]['least']['C'] = 25;



		$chart_code_most[4]['most']['D'] = 14;

		$chart_code_most[4]['most']['I'] = 9;

		$chart_code_most[4]['most']['S'] = 7;

		$chart_code_most[4]['most']['C'] = 9;

		$chart_code_most[4]['least']['D'] = 25;

		$chart_code_most[4]['least']['I'] = 20;

		$chart_code_most[4]['least']['S'] = 15;

		$chart_code_most[4]['least']['C'] = 24;



		$chart_code_most[5]['most']['D'] = 16;

		$chart_code_most[5]['most']['I'] = 12;

		$chart_code_most[5]['most']['S'] = 9;

		$chart_code_most[5]['most']['C'] = 13;

		$chart_code_most[5]['least']['D'] = 24;

		$chart_code_most[5]['least']['I'] = 16;

		$chart_code_most[5]['least']['S'] = 12;

		$chart_code_most[5]['least']['C'] = 22;



		$chart_code_most[6]['most']['D'] = 19;

		$chart_code_most[6]['most']['I'] = 14;

		$chart_code_most[6]['most']['S'] = 11;

		$chart_code_most[6]['most']['C'] = 16;

		$chart_code_most[6]['least']['D'] = 22;

		$chart_code_most[6]['least']['I'] = 12;

		$chart_code_most[6]['least']['S'] = 9;

		$chart_code_most[6]['least']['C'] = 19;



		$chart_code_most[7]['most']['D'] = 20;

		$chart_code_most[7]['most']['I'] = 16;

		$chart_code_most[7]['most']['S'] = 13;

		$chart_code_most[7]['most']['C'] = 19;

		$chart_code_most[7]['least']['D'] = 21;

		$chart_code_most[7]['least']['I'] = 9;

		$chart_code_most[7]['least']['S'] = 7;

		$chart_code_most[7]['least']['C'] = 16;



		$chart_code_most[8]['most']['D'] = 22;

		$chart_code_most[8]['most']['I'] = 20;

		$chart_code_most[8]['most']['S'] = 15;

		$chart_code_most[8]['most']['C'] = 21;

		$chart_code_most[8]['least']['D'] = 19;

		$chart_code_most[8]['least']['I'] = 6;

		$chart_code_most[8]['least']['S'] = 5;

		$chart_code_most[8]['least']['C'] = 13;



		$chart_code_most[9]['most']['D'] = 23;

		$chart_code_most[9]['most']['I'] = 22;

		$chart_code_most[9]['most']['S'] = 17;

		$chart_code_most[9]['most']['C'] = 23;

		$chart_code_most[9]['least']['D'] = 17;

		$chart_code_most[9]['least']['I'] = 4;

		$chart_code_most[9]['least']['S'] = 4;

		$chart_code_most[9]['least']['C'] = 11;



		$chart_code_most[10]['most']['D'] = 24;

		$chart_code_most[10]['most']['I'] = 24;

		$chart_code_most[10]['most']['S'] = 19;

		$chart_code_most[10]['most']['C'] = 24;

		$chart_code_most[10]['least']['D'] = 14;

		$chart_code_most[10]['least']['I'] = 3;

		$chart_code_most[10]['least']['S'] = 3;

		$chart_code_most[10]['least']['C'] = 8;



		$chart_code_most[11]['most']['D'] = 25;

		$chart_code_most[11]['most']['I'] = 25;

		$chart_code_most[11]['most']['S'] = 21;

		$chart_code_most[11]['most']['C'] = 25;

		$chart_code_most[11]['least']['D'] = 12;

		$chart_code_most[11]['least']['I'] = 2;

		$chart_code_most[11]['least']['S'] = 3;

		$chart_code_most[11]['least']['C'] = 5;



		$chart_code_most[12]['most']['D'] = 26;

		$chart_code_most[12]['most']['I'] = 26;

		$chart_code_most[12]['most']['S'] = 23;

		$chart_code_most[12]['most']['C'] = 26;

		$chart_code_most[12]['least']['D'] = 11;

		$chart_code_most[12]['least']['I'] = 2;

		$chart_code_most[12]['least']['S'] = 3;

		$chart_code_most[12]['least']['C'] = 4;



		$chart_code_most[13]['most']['D'] = 27;

		$chart_code_most[13]['most']['I'] = 27;

		$chart_code_most[13]['most']['S'] = 25;

		$chart_code_most[13]['most']['C'] = 27;

		$chart_code_most[13]['least']['D'] = 8;

		$chart_code_most[13]['least']['I'] = 2;

		$chart_code_most[13]['least']['S'] = 3;

		$chart_code_most[13]['least']['C'] = 3;



		$chart_code_most[14]['most']['D'] = 27;

		$chart_code_most[14]['most']['I'] = 27;

		$chart_code_most[14]['most']['S'] = 26;

		$chart_code_most[14]['most']['C'] = 27;

		$chart_code_most[14]['least']['D'] = 7;

		$chart_code_most[14]['least']['I'] = 2;

		$chart_code_most[14]['least']['S'] = 3;

		$chart_code_most[14]['least']['C'] = 2;



		$chart_code_most[15]['most']['D'] = 27;

		$chart_code_most[15]['most']['I'] = 27;

		$chart_code_most[15]['most']['S'] = 27;

		$chart_code_most[15]['most']['C'] = 27;

		$chart_code_most[15]['least']['D'] = 6;

		$chart_code_most[15]['least']['I'] = 2;

		$chart_code_most[15]['least']['S'] = 3;

		$chart_code_most[15]['least']['C'] = 2;



		$chart_code_most[16]['most']['D'] = 27;

		$chart_code_most[16]['most']['I'] = 27;

		$chart_code_most[16]['most']['S'] = 27;

		$chart_code_most[16]['most']['C'] = 27;

		$chart_code_most[16]['least']['D'] = 4;

		$chart_code_most[16]['least']['I'] = 2;

		$chart_code_most[16]['least']['S'] = 3;

		$chart_code_most[16]['least']['C'] = 2;



		$chart_code_most[17]['most']['D'] = 27;

		$chart_code_most[17]['most']['I'] = 27;

		$chart_code_most[17]['most']['S'] = 27;

		$chart_code_most[17]['most']['C'] = 27;

		$chart_code_most[17]['least']['D'] = 3;

		$chart_code_most[17]['least']['I'] = 2;

		$chart_code_most[17]['least']['S'] = 3;

		$chart_code_most[17]['least']['C'] = 2;



		$chart_code_most[18]['most']['D'] = 27;

		$chart_code_most[18]['most']['I'] = 27;

		$chart_code_most[18]['most']['S'] = 27;

		$chart_code_most[18]['most']['C'] = 27;

		$chart_code_most[18]['least']['D'] = 2;

		$chart_code_most[18]['least']['I'] = 2;

		$chart_code_most[18]['least']['S'] = 3;

		$chart_code_most[18]['least']['C'] = 2;



		$chart_code_most[19]['most']['D'] = 27;

		$chart_code_most[19]['most']['I'] = 27;

		$chart_code_most[19]['most']['S'] = 27;

		$chart_code_most[19]['most']['C'] = 27;

		$chart_code_most[19]['least']['D'] = 2;

		$chart_code_most[19]['least']['I'] = 2;

		$chart_code_most[19]['least']['S'] = 2;

		$chart_code_most[19]['least']['C'] = 2;



		$chart_code_most[20]['most']['D'] = 27;

		$chart_code_most[20]['most']['I'] = 27;

		$chart_code_most[20]['most']['S'] = 27;

		$chart_code_most[20]['most']['C'] = 27;

		$chart_code_most[20]['least']['D'] = 2;

		$chart_code_most[20]['least']['I'] = 2;

		$chart_code_most[20]['least']['S'] = 2;

		$chart_code_most[20]['least']['C'] = 2;



		$chart_code_most[21]['most']['D'] = 27;

		$chart_code_most[21]['most']['I'] = 27;

		$chart_code_most[21]['most']['S'] = 27;

		$chart_code_most[21]['most']['C'] = 27;

		$chart_code_most[21]['least']['D'] = 2;

		$chart_code_most[21]['least']['I'] = 2;

		$chart_code_most[21]['least']['S'] = 2;

		$chart_code_most[21]['least']['C'] = 2;



		$chart_code_most[22]['most']['D'] = 27;

		$chart_code_most[22]['most']['I'] = 27;

		$chart_code_most[22]['most']['S'] = 27;

		$chart_code_most[22]['most']['C'] = 27;

		$chart_code_most[22]['least']['D'] = 2;

		$chart_code_most[22]['least']['I'] = 2;

		$chart_code_most[22]['least']['S'] = 2;

		$chart_code_most[22]['least']['C'] = 2;



		$chart_code_most[23]['most']['D'] = 27;

		$chart_code_most[23]['most']['I'] = 27;

		$chart_code_most[23]['most']['S'] = 27;

		$chart_code_most[23]['most']['C'] = 27;

		$chart_code_most[23]['least']['D'] = 2;

		$chart_code_most[23]['least']['I'] = 2;

		$chart_code_most[23]['least']['S'] = 2;

		$chart_code_most[23]['least']['C'] = 2;



		$chart_code_most[24]['most']['D'] = 27;

		$chart_code_most[24]['most']['I'] = 27;

		$chart_code_most[24]['most']['S'] = 27;

		$chart_code_most[24]['most']['C'] = 28;

		$chart_code_most[24]['least']['D'] = 2;

		$chart_code_most[24]['least']['I'] = 2;

		$chart_code_most[24]['least']['S'] = 2;

		$chart_code_most[24]['least']['C'] = 2;



		$chart_code_most[25]['most']['D'] = 27;

		$chart_code_most[25]['most']['I'] = 27;

		$chart_code_most[25]['most']['S'] = 27;

		$chart_code_most[25]['most']['C'] = 28;

		$chart_code_most[25]['least']['D'] = 2;

		$chart_code_most[25]['least']['I'] = 2;

		$chart_code_most[25]['least']['S'] = 2;

		$chart_code_most[25]['least']['C'] = 2;



		$chart_code_most[26]['most']['D'] = 27;

		$chart_code_most[26]['most']['I'] = 27;

		$chart_code_most[26]['most']['S'] = 27;

		$chart_code_most[26]['most']['C'] = 28;

		$chart_code_most[26]['least']['D'] = 2;

		$chart_code_most[26]['least']['I'] = 1;

		$chart_code_most[26]['least']['S'] = 2;

		$chart_code_most[26]['least']['C'] = 1;



		$chart_code_most[27]['most']['D'] = 28;

		$chart_code_most[27]['most']['I'] = 27;

		$chart_code_most[27]['most']['S'] = 27;

		$chart_code_most[27]['most']['C'] = 28;

		$chart_code_most[27]['least']['D'] = 1;

		$chart_code_most[27]['least']['I'] = 1;

		$chart_code_most[27]['least']['S'] = 1;

		$chart_code_most[27]['least']['C'] = 1;



		$chart_code_most[28]['most']['D'] = 28;

		$chart_code_most[28]['most']['I'] = 28;

		$chart_code_most[28]['most']['S'] = 26;

		$chart_code_most[28]['most']['C'] = 28;

		$chart_code_most[28]['least']['D'] = 1;

		$chart_code_most[28]['least']['I'] = 1;

		$chart_code_most[28]['least']['S'] = 1;

		$chart_code_most[28]['least']['C'] = 1;

		

		return $chart_code_most[$column_total][$identifier][$option];

	}



	public function chartDiffCode($column_total, $option)

	{

		$chart_code_most[-28]['D'] = 1;

		$chart_code_most[-28]['I'] = 1;

		$chart_code_most[-28]['S'] = 1;

		$chart_code_most[-28]['C'] = 1;



		$chart_code_most[-27]['D'] = 1;

		$chart_code_most[-27]['I'] = 1;

		$chart_code_most[-27]['S'] = 1;

		$chart_code_most[-27]['C'] = 1;



		$chart_code_most[-26]['D'] = 2;

		$chart_code_most[-26]['I'] = 1;

		$chart_code_most[-26]['S'] = 1;

		$chart_code_most[-26]['C'] = 1;



		$chart_code_most[-25]['D'] = 2;

		$chart_code_most[-25]['I'] = 2;

		$chart_code_most[-25]['S'] = 2;

		$chart_code_most[-25]['C'] = 1;



		$chart_code_most[-24]['D'] = 2;

		$chart_code_most[-24]['I'] = 2;

		$chart_code_most[-24]['S'] = 1;

		$chart_code_most[-24]['C'] = 1;



		$chart_code_most[-23]['D'] = 2;

		$chart_code_most[-23]['I'] = 2;

		$chart_code_most[-23]['S'] = 1;

		$chart_code_most[-23]['C'] = 1;



		$chart_code_most[-22]['D'] = 2;

		$chart_code_most[-22]['I'] = 2;

		$chart_code_most[-22]['S'] = 1;

		$chart_code_most[-22]['C'] = 1;



		$chart_code_most[-21]['D'] = 2;

		$chart_code_most[-21]['I'] = 2;

		$chart_code_most[-21]['S'] = 1;

		$chart_code_most[-21]['C'] = 1;



		$chart_code_most[-20]['D'] = 2;

		$chart_code_most[-20]['I'] = 2;

		$chart_code_most[-20]['S'] = 1;

		$chart_code_most[-20]['C'] = 2;		



		$chart_code_most[-19]['D'] = 2;

		$chart_code_most[-19]['I'] = 2;

		$chart_code_most[-19]['S'] = 1;

		$chart_code_most[-19]['C'] = 2;		



		$chart_code_most[-18]['D'] = 2;

		$chart_code_most[-18]['I'] = 2;

		$chart_code_most[-18]['S'] = 1;

		$chart_code_most[-18]['C'] = 2;		



		$chart_code_most[-17]['D'] = 2;

		$chart_code_most[-17]['I'] = 2;

		$chart_code_most[-17]['S'] = 1;

		$chart_code_most[-17]['C'] = 2;		



		$chart_code_most[-16]['D'] = 3;

		$chart_code_most[-16]['I'] = 2;

		$chart_code_most[-16]['S'] = 1;

		$chart_code_most[-16]['C'] = 2;		



		$chart_code_most[-15]['D'] = 4;

		$chart_code_most[-15]['I'] = 2;

		$chart_code_most[-15]['S'] = 1;

		$chart_code_most[-15]['C'] = 2;		



		$chart_code_most[-14]['D'] = 6;

		$chart_code_most[-14]['I'] = 2;

		$chart_code_most[-14]['S'] = 1;

		$chart_code_most[-14]['C'] = 2;		



		$chart_code_most[-13]['D'] = 7;

		$chart_code_most[-13]['I'] = 2;

		$chart_code_most[-13]['S'] = 1;

		$chart_code_most[-13]['C'] = 2;		



		$chart_code_most[-12]['D'] = 8;

		$chart_code_most[-12]['I'] = 2;

		$chart_code_most[-12]['S'] = 2;

		$chart_code_most[-12]['C'] = 2;		



		$chart_code_most[-11]['D'] = 9;

		$chart_code_most[-11]['I'] = 2;

		$chart_code_most[-11]['S'] = 2;

		$chart_code_most[-11]['C'] = 3;



		$chart_code_most[-10]['D'] = 10;

		$chart_code_most[-10]['I'] = 2;

		$chart_code_most[-10]['S'] = 2;

		$chart_code_most[-10]['C'] = 3;



		$chart_code_most[-9]['D'] = 11;

		$chart_code_most[-9]['I'] = 2;

		$chart_code_most[-9]['S'] = 2;

		$chart_code_most[-9]['C'] = 4;		



		$chart_code_most[-8]['D'] = 12;

		$chart_code_most[-8]['I'] = 3;

		$chart_code_most[-8]['S'] = 2;

		$chart_code_most[-8]['C'] = 5;



		$chart_code_most[-7]['D'] = 14;

		$chart_code_most[-7]['I'] = 3;

		$chart_code_most[-7]['S'] = 3;

		$chart_code_most[-7]['C'] = 7;



		$chart_code_most[-6]['D'] = 15;

		$chart_code_most[-6]['I'] = 4;

		$chart_code_most[-6]['S'] = 3;

		$chart_code_most[-6]['C'] = 8;



		$chart_code_most[-5]['D'] = 16;

		$chart_code_most[-5]['I'] = 6;

		$chart_code_most[-5]['S'] = 4;

		$chart_code_most[-5]['C'] = 9;



		$chart_code_most[-4]['D'] = 17;

		$chart_code_most[-4]['I'] = 7;

		$chart_code_most[-4]['S'] = 5;

		$chart_code_most[-4]['C'] = 10;



		$chart_code_most[-3]['D'] = 18;

		$chart_code_most[-3]['I'] = 8;

		$chart_code_most[-3]['S'] = 6;

		$chart_code_most[-3]['C'] = 12;



		$chart_code_most[-2]['D'] = 19;

		$chart_code_most[-2]['I'] = 9;

		$chart_code_most[-2]['S'] = 7;

		$chart_code_most[-2]['C'] = 15;



		$chart_code_most[-1]['D'] = 20;

		$chart_code_most[-1]['I'] = 11;

		$chart_code_most[-1]['S'] = 8;

		$chart_code_most[-1]['C'] = 16;



		$chart_code_most[0]['D'] = 21;

		$chart_code_most[0]['I'] = 12;

		$chart_code_most[0]['S'] = 10;

		$chart_code_most[0]['C'] = 17;



		$chart_code_most[1]['D'] = 22;

		$chart_code_most[1]['I'] = 14;

		$chart_code_most[1]['S'] = 11;

		$chart_code_most[1]['C'] = 18;



		$chart_code_most[2]['D'] = 23;

		$chart_code_most[2]['I'] = 15;

		$chart_code_most[2]['S'] = 12;

		$chart_code_most[2]['C'] = 20;



		$chart_code_most[3]['D'] = 24;

		$chart_code_most[3]['I'] = 17;

		$chart_code_most[3]['S'] = 13;

		$chart_code_most[3]['C'] = 21;



		$chart_code_most[4]['D'] = 24;

		$chart_code_most[4]['I'] = 19;

		$chart_code_most[4]['S'] = 14;

		$chart_code_most[4]['C'] = 23;



		$chart_code_most[5]['D'] = 24;

		$chart_code_most[5]['I'] = 20;

		$chart_code_most[5]['S'] = 15;

		$chart_code_most[5]['C'] = 24;



		$chart_code_most[6]['D'] = 24;

		$chart_code_most[6]['I'] = 22;

		$chart_code_most[6]['S'] = 17;

		$chart_code_most[6]['C'] = 25;



		$chart_code_most[7]['D'] = 25;

		$chart_code_most[7]['I'] = 24;

		$chart_code_most[7]['S'] = 19;

		$chart_code_most[7]['C'] = 25;



		$chart_code_most[8]['D'] = 25;

		$chart_code_most[8]['I'] = 25;

		$chart_code_most[8]['S'] = 20;

		$chart_code_most[8]['C'] = 25;



		$chart_code_most[9]['D'] = 26;

		$chart_code_most[9]['I'] = 26;

		$chart_code_most[9]['S'] = 21;

		$chart_code_most[9]['C'] = 25;



		$chart_code_most[10]['D'] = 26;

		$chart_code_most[10]['I'] = 27;

		$chart_code_most[10]['S'] = 23;

		$chart_code_most[10]['C'] = 25;



		$chart_code_most[11]['D'] = 26;

		$chart_code_most[11]['I'] = 27;

		$chart_code_most[11]['S'] = 24;

		$chart_code_most[11]['C'] = 25;



		$chart_code_most[12]['D'] = 26;

		$chart_code_most[12]['I'] = 27;

		$chart_code_most[12]['S'] = 25;

		$chart_code_most[12]['C'] = 26;



		$chart_code_most[13]['D'] = 26;

		$chart_code_most[13]['I'] = 27;

		$chart_code_most[13]['S'] = 25;

		$chart_code_most[13]['C'] = 26;



		$chart_code_most[14]['D'] = 26;

		$chart_code_most[14]['I'] = 27;

		$chart_code_most[14]['S'] = 26;

		$chart_code_most[14]['C'] = 26;



		$chart_code_most[15]['D'] = 26;

		$chart_code_most[15]['I'] = 27;

		$chart_code_most[15]['S'] = 26;

		$chart_code_most[15]['C'] = 26;



		$chart_code_most[16]['D'] = 26;

		$chart_code_most[16]['I'] = 27;

		$chart_code_most[16]['S'] = 26;

		$chart_code_most[16]['C'] = 26;



		$chart_code_most[17]['D'] = 26;

		$chart_code_most[17]['I'] = 27;

		$chart_code_most[17]['S'] = 26;

		$chart_code_most[17]['C'] = 26;



		$chart_code_most[18]['D'] = 27;

		$chart_code_most[18]['I'] = 27;

		$chart_code_most[18]['S'] = 26;

		$chart_code_most[18]['C'] = 27;



		$chart_code_most[19]['D'] = 27;

		$chart_code_most[19]['I'] = 27;

		$chart_code_most[19]['S'] = 26;

		$chart_code_most[19]['C'] = 27;



		$chart_code_most[20]['D'] = 27;

		$chart_code_most[20]['I'] = 27;

		$chart_code_most[20]['S'] = 27;

		$chart_code_most[20]['C'] = 27;



		$chart_code_most[21]['D'] = 27;

		$chart_code_most[21]['I'] = 27;

		$chart_code_most[21]['S'] = 27;

		$chart_code_most[21]['C'] = 27;



		$chart_code_most[22]['D'] = 27;

		$chart_code_most[22]['I'] = 27;

		$chart_code_most[22]['S'] = 27;

		$chart_code_most[22]['C'] = 27;



		$chart_code_most[23]['D'] = 27;

		$chart_code_most[23]['I'] = 27;

		$chart_code_most[23]['S'] = 27;

		$chart_code_most[23]['C'] = 27;



		$chart_code_most[24]['D'] = 27;

		$chart_code_most[24]['I'] = 27;

		$chart_code_most[24]['S'] = 27;

		$chart_code_most[24]['C'] = 28;



		$chart_code_most[25]['D'] = 27;

		$chart_code_most[25]['I'] = 27;

		$chart_code_most[25]['S'] = 27;

		$chart_code_most[25]['C'] = 28;



		$chart_code_most[26]['D'] = 27;

		$chart_code_most[26]['I'] = 27;

		$chart_code_most[26]['S'] = 28;

		$chart_code_most[26]['C'] = 28;



		$chart_code_most[27]['D'] = 28;

		$chart_code_most[27]['I'] = 27;

		$chart_code_most[27]['S'] = 28;

		$chart_code_most[27]['C'] = 28;



		$chart_code_most[28]['D'] = 28;

		$chart_code_most[28]['I'] = 28;

		$chart_code_most[28]['S'] = 28;

		$chart_code_most[28]['c'] = 28;

		

		return $chart_code_most[$column_total][$option];

	}



	public function segmentPlotData($val)

	{

		if ($val <= 4)

			return 1;

		elseif($val <= 8)

			return 2;

		elseif($val <= 12)

			return 3;

		elseif($val <= 16)

			return 4;

		elseif($val <= 20)

			return 5;

		elseif($val <= 24)

			return 6;

		elseif($val <= 28)

			return 7;

	}

   public function getProfileValue($business_id, $profile_id){
        $profilevalue_res = false;
        
      /*  $select = "select v.profileoutcome_table_id, v.profilevalue_id, v.profilevalue_title from business_owner_mst b ";
        $select .= " join package_mst p on p.package_id = b.current_package_id ";
        $select .= " join profile_value v on v.profileoutcome_table_id = p.profileoutcome_table_id ";
        $select .= " where v.profilevalue_id =".$profile_id." and business_id =".$business_id ;*/
        
      //  $stmt	 = $this->db->query($select);
		//$profilevalue_res = $stmt->fetch();
		 $profilevalue_res = DB::table('business_owner_mst')
		           ->join('package_mst','package_mst.package_id', '=', 'business_owner_mst.current_package_id')
				   ->join('profile_value','profile_value.profileoutcome_table_id', '=', 'package_mst.profileoutcome_table_id')
				   ->select('profile_value.profileoutcome_table_id', 'profile_value.profilevalue_id', 'profile_value.profilevalue_title')
				   ->where('profile_value.profilevalue_id', "=",$profile_id)
				   ->where('business_owner_mst.business_id','=',$business_id)->first();
				  
        return $profilevalue_res;
    }


}


?>