<?php
namespace App\Modules\Candidate\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Redirect;
use Collective\Html\Eloquent\FormAccessible;
use DB;
use App\Http\Models\User;
use App\Modules\Candidate\Models\Contactdetails;
use App\Modules\Candidate\Models\Contactinfo;
use App\Modules\Candidate\Models\Country;
use App\Modules\Candidate\Models\State;
use Illuminate\Support\Facades\Auth;
use App\Modules\Candidate\Models\Candidatemst;
use App\Modules\Candidate\Models\Testmst;
use View;

class VoluntaryController extends Controller
{


	public function index()
	{
	  		$state = State::orderBy('state')->get();
			$country = Country::orderBy('country')->get();
			$contact_info = Contactinfo::where('candidate_id', Auth::id())->first();
			
			return view('Candidate::voluntary.index',['state'=>$state,'country' => $country,'contact_info' => $contact_info]);
		
		
	}
	
	public function save(Request $request)
	{
	    //for resume parser off and candidate without resume
	     
		   $state_arr = State::where('state_id',$request->input('contact_state'))
		                    ->select('state')->first();
		   $country_arr = Country::where('country_id',$request->input('contact_country'))
		                    ->select('country_code')->first();
							
			$contact_arr = Contactinfo::where('candidate_id', Auth::id())
								->select('candidate_id')->first();
				
		   $contactinfo['candidate_id'] = Auth::id();
		   
		   
		  if($request->input('contact_address1') != '') {
			$contactinfo['address1'] =  $request->input('contact_address1');
			}
			 if($request->input('contact_city') != '') {
			$contactinfo['address2'] =  $request->input('contact_city');
			}
			 if($request->input('contact_state') != '') {
			$contactinfo['state'] =  $state_arr['state'];
			}
			 if($request->input('contact_country') != '') {
			$contactinfo['country'] =  $country_arr['country_code'];
			}
	       if(isset($contact_arr)){
		    $contactinfo_update = Contactinfo::where('candidate_id', Auth::id())
								->update($contactinfo);
			}else{
			   $contactinfo_update = Contactinfo::where('candidate_id', Auth::id())
								->updateOrCreate($contactinfo);
			}
								
			//ends////////////
			
							
		   $voluntary['candidate_id'] = Auth::id();
			
			if($request->input('gender_sel') != '') {
			$voluntary['gender'] =  $request->input('gender_sel');
			}
			if($request->input('race_sel') != '') {
			$voluntary['race'] =  $request->input('race_sel');
			}
			if($request->input('disability_sel') != '') {
			$voluntary['disability'] =  $request->input('disability_sel');
			}
			
			$voluntary_update = Contactdetails::where('candidate_id', Auth::id())
								->update($voluntary);
			
			$candidate_mst = Candidatemst::find(Auth::id());
			
			$test_mst = Testmst::find(Auth::user()->test_id);

                if($test_mst->personality_assessment == 1){
				 	$candidate_mst = Candidatemst::find(Auth::id());
					$candidate_mst->current_page = "/assessment/sample";
					$candidate_mst->save();
					return Redirect::to("/assessment/sample");
				}else if($test_mst->problem_solving == 1) {

					$candidate_mst = Candidatemst::find(Auth::id());
					$candidate_mst->current_page = "problemsolving/index";
					$candidate_mst->save();
					return Redirect::to("problemsolving/index");


				} else if($test_mst->short_answer == 1) {
					
					$candidate_mst = Candidatemst::find(Auth::id());
					$candidate_mst->current_page = "shortanswer/index";
					$candidate_mst->save();
					return Redirect::to("shortanswer/index");
				} else
					return Redirect::to("thankyou/index");
			
			
			
			/*
			$candidate_mst->current_page = '/assessment/sample';
			$candidate_mst->save();
									
			return Redirect::to('/assessment/sample');*/
		
		
		
	}
	
	


}
