<?php

namespace App\Modules\Candidate\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Collective\Html\Eloquent\FormAccessible;
use DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Auth;
use App\Modules\Candidate\Models\BusinessOwner;
use App\Modules\Candidate\Models\Profilemst;
use App\Modules\Candidate\Models\Result;
use App\Modules\Candidate\Models\Position;
use App\Modules\Candidate\Models\Candidatemst;
use App\Modules\Candidate\Models\Contactinfo;
use App\Modules\Candidate\Models\Contactdetails;
use App\Modules\Candidate\Models\State;
use App\Modules\Candidate\Models\Testmst;
use App\Modules\Candidate\Models\AssessmentSave;
use App\Modules\Candidate\Models\ProblemsolvingSave;
use App\Modules\Candidate\Models\CandidateLog;
use App\Modules\Candidate\Models\Mailmst;
use App\Modules\Candidate\Models\History;
use App\Modules\Candidate\Models\Transaction;
use Illuminate\Support\Facades\URL;
use App\Modules\Candidate\Models\BusinessOwnerSubuser;
use App\Modules\Candidate\Models\Shortanswer;
use App\Modules\Candidate\Models\PsResults;
use App\Modules\Candidate\Models\Recruiter;

use Illuminate\Support\Facades\Config;
use Carbon\Carbon;
use Mail;

use Illuminate\Support\Facades\Redirect;

use App\Modules\Candidate\Models\Attempt;
use App\Modules\Candidate\Models\Question;
use App\Modules\Candidate\Models\Videoattemptdelete;

use App\Modules\Candidate\Models\Webhooks;
use App\Modules\Candidate\Models\WebhookLog;
use App\Modules\Candidate\Models\Location;
use App\Modules\Candidate\Models\Prequalifyanswer;
use App\Modules\Candidate\Models\Prequalifybusinessquestion;
use PDF;
Use App;
use Illuminate\Support\Facades\Log;

class ThankyouController extends Controller
{


	public function index(Request $request)
	{


		$test_id = Auth::user()->test_id;

		$candidate_id = Auth::id();

		$business_id = Auth::user()->business_id;
		$business_owner = BusinessOwner::find($business_id);

	
		
        $start_time  = $request->session()->get('start_test_time');
		$mailsent_status  = $request->session()->get('finaltest_mail');
		$mailsent_status  = $mailsent_status +1;
		$request->session()->put('finaltest_mail', $mailsent_status);

		$resultupdate = Result::thankyoucalculateandsave($test_id,$candidate_id,$start_time);
		$job_res = []; 
		$job_id = Auth::user()->job_id;
		if (!empty($job_id) && !is_null($job_id)) {			
			$job_res = DB::table('jobs')->where('jobs.id','=',$job_id)->get();
		}
		if($resultupdate) {
			
			$candidatelog = DB::table('candidate_commentrate')
				   ->where('candidate_id', "=",$candidate_id)
				   ->where('business_id', "=",$business_id)
				   ->where('action', "=",'COMPLETED ASSESSMENT')->first();
			$business_logo = $business_owner->business_logo;
			if (!empty($candidatelog)) {
				if(isset($business_owner['business_website']) && $business_owner['business_website'] != '' ) {
					if( strpos( $business_owner['business_website'], 'http' ) !== false ) {
						//header('Refresh: 12;url='.$business_owner['business_website']);
						$redirect_url = $business_owner['business_website'];
					}else{
						//header('Refresh: 12;url=http://'.$business_owner['business_website']);
						 $redirect_url = 'http://'.$business_owner['business_website'];
					}
				
				} else {
					//header('Refresh: 12;url=http://www.idealtraits.com');
					$redirect_url = '';
				}
				return view('Candidate::thankyou.index', ['business_logo' => $business_logo,'job_res'=>$job_res,'redirect_url'=>$redirect_url,'business_owner'=>$business_owner]);					
			}	  
			$candidate_log = new CandidateLog;
			$candidate_log->candidate_id = $candidate_id;
			$candidate_log->business_id = $business_id;
			$candidate_log->action = "COMPLETED ASSESSMENT";
			date_default_timezone_set("America/New_York");
			$candidate_log->created_date = date('Y-m-d H:i:s');
			
			$candidate_log->save();


			$candidate_mst = Candidatemst::find($candidate_id);

			if($candidate_mst['status'] != 'Hired' && $candidate_mst['status'] != 'Terminated') {
			//if ($_SERVER['REMOTE_ADDR'] == '103.213.192.118'){
			$hire_res = DB::table('hiring_workflow')
				   ->where('stage_name', "=",'Assessment Complete')
				   ->where('business_id', "=",$business_id)
				   ->where('is_deleted', "=",'N')->first();
		   

			$candidate_mst->status_id =  $hire_res->id;
		   	//}
			$candidate_mst->recruiter_isread='1';
			if($job_res[0]->vha_job == '1') {
			$candidate_mst->admin_tag = 'VHA Working';
			$candidate_mst->archive_tag = '';
			if($candidate_mst->business_id=='6574'){
				$this->videoinvitenew($candidate_id);
			}else{
				$this->videoinvite($candidate_id);
			}
			
			}
			$candidate_mst->status = 'Assessment Complete';
			$candidate_mst->save();
			
			$job_id = Auth::user()->job_id;
			if (!empty($job_id) && !is_null($job_id)) {			
				$job_res = DB::table('jobs')->where('jobs.id','=',$job_id)->get();
			}
			
			if (!empty($business_owner->zapier_webhook_url) && !is_null($business_owner->zapier_webhook_url) ) {
				
				$zapiercandidate = Candidatemst::find($candidate_id);
				$zapiercandidate_arr = $zapiercandidate->toArray();
								
				$zapiercandidate_arr['candidate_password'] ='';
				$zapiercandidate_arr['laravel_candidate_password'] = '';
				$zapiercandidate_arr['tag'] = 'update';
				// $this->sendCandidateToZapier($business_owner->zapier_webhook_url,$zapiercandidate_arr);
				$this->candidatedetailsToZapier($business_owner->zapier_webhook_url,$candidate_id);
				
			}

			

			$webhooks = $this->getwebhookbytriggername('assmnt_cmplt',$business_owner->business_id);
			foreach($webhooks as $webhook){
				$this->candiddetailstowebhook($webhook->target_url,$candidate_id,$webhook->event_trigger,$webhook->id,'update');
			}

			}
			if($mailsent_status ==1){
				$this->businessownernotification_mail($resultupdate,$candidate_mst,$business_owner,'FINALTEST_COMPLETION_NOTIFICATION');
				$this->sendcandidatemail($candidate_mst,$business_owner,'TEST_COMPLETION_NOTIFICATION_TO_CANDIDATE');
			}
			
		}
		$candidate_res = Candidatemst::find($candidate_id);
		//if ($candidate_res->source != '' && $candidate_res->source == 'FRM_CONTACT') {
		if ($business_owner->current_package_id == '197') {
			return redirect()->to("https://ascts.idealtraits.com/thankyou");
		} 
		$package_arr = DB::table('package_mst')
				   ->select("candidateofferpage")
				   ->where('package_id', $business_owner['current_package_id'])->first();
				   
				  
	
		if ($package_arr->candidateofferpage != '' && $package_arr->candidateofferpage !=0 && $candidate_mst['job_id'] != NULL) {
			
			  return Redirect::to("interest/startcontinue");	
			
		}else{
			if(isset($business_owner['business_website']) && $business_owner['business_website'] != '' ) {
				if( strpos( $business_owner['business_website'], 'http' ) !== false ) {
					//header('Refresh: 12;url='.$business_owner['business_website']);
					$redirect_url = $business_owner['business_website'];
				}else{
					//header('Refresh: 12;url=http://'.$business_owner['business_website']);
					 $redirect_url = 'http://'.$business_owner['business_website'];
				}
			
			} else {
				//header('Refresh: 12;url=http://www.idealtraits.com');
				$redirect_url = 'http://www.idealtraits.com';
			}
			History::maintainCandidateLog(9,'CANDIDATE_THANKYOU');
			//Auth::logout();
			//$request->session()->flush();
			$business_logo = $business_owner->business_logo;
			//return view('Candidate::thankyou.index');
			return view('Candidate::thankyou.index', ['business_logo' => $business_logo,'job_res'=>$job_res,'redirect_url'=>$redirect_url,'business_owner'=>$business_owner]);
		
		}


	}

	public function videoinvite($candidate_id)
	{
		$idealvideo_site = config('constants.IDEALVIDEO_SITE');
		$url = $idealvideo_site . 'api/employer/inviteidealCandidate';
		
		$candidatename = Candidatemst::select('first_name', 'last_name', 'phone_no','job_id','email','business_id')->find($candidate_id);

		$jobId = $candidatename->job_id;
		$intake_data =  DB::table('vha_intake_form')
						->where('job_id', $jobId)
						->first();

		

		$candidatedata['email'] = trim($candidatename->email);
		
        $candidatedata['position_id'] = $intake_data->video_position_id;
		$candidatedata['app_candidate_id'] = $candidate_id;
        
        
		$data = array("candidatedata" => $candidatedata, 'candidatename' => $candidatename);

		$postdata = json_encode($data);

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
		$result = curl_exec($ch);
		$result = json_decode($result);
		curl_close($ch);
		// print_r ($result); exit;
		if ($result->response == '1') {
			
			$video_positionid = $candidatename->job_id;
			
			$candidate = Candidatemst::find($candidate_id);
			$candidate->video_invite = '1';
			$candidate->video_candidate_id = $result->video_candidate_id;
			$candidate->video_position_id = $video_positionid;
			$candidate->video_interviewstatus = 1;
			$candidate->save();

			DB::table('candidate_commentrate')->insert([
				'candidate_id' => $candidate_id,
				'business_id' => $candidatename->business_id,
				'action' => 'invite send for Video interview',
				'created_date' => date('Y-m-d H:i:s'),
			]);

			return 1;
		}
		return 0;
	}


	public function videoinvitenew($candidate_id)
	{
	
		$candidatename = Candidatemst::select('first_name', 'last_name', 'phone_no','job_id','email','business_id')->find($candidate_id);

		$jobId = $candidatename->job_id;
		$intake_data =  DB::table('vha_intake_form')
						->where('job_id', $jobId)
						->first();


		$video_interview_id =$intake_data->video_position_id;
		$candidate = Candidatemst::find($candidate_id);
		$candidate->video_interview_id = $video_interview_id;
		$candidate->is_canvimigrate = '1';
		$candidate->save();
		
		// $mailsend_ornot =$this->sendinviteemail($candid);// EmailTrait

		$client = new \GuzzleHttp\Client;
		$appsite = Config::get('constants.app_domain');
		$url = $appsite."bridge/sendinvitefromcandidate/".$candidate_id;
	
		$response = $client->get($url); 
	
		$result =  json_decode($response->getBody()->getContents());

		if($result->response=='1'){
			$candidate->video_invite = '1';
			$candidate->video_invitedate = Carbon::now();
			$candidate->video_interviewstatus = '1';
			$candidate->save();

			DB::table('candidate_commentrate')->insert([
				'candidate_id' => $candidate_id,
				'business_id' => $candidatename->business_id,
				'action' => 'invite send for Video interview',
				'created_date' => date('Y-m-d H:i:s'),
			]);

			
			return 1;
		}
		return 0;

	}
	
	public function complete(Request $request) {
		$test_id = Auth::user()->test_id;

		$candidate_id = Auth::id();

		$business_id = Auth::user()->business_id;
		$business_owner = BusinessOwner::find($business_id);
		if(isset($business_owner['business_website']) && $business_owner['business_website'] != '' ) {
			if( strpos( $business_owner['business_website'], 'http' ) !== false ) {
   				//header('Refresh: 12;url='.$business_owner['business_website']);
				$redirect_url = $business_owner['business_website'];
			}else{
		        //header('Refresh: 12;url=http://'.$business_owner['business_website']);
				$redirect_url = 'http://'.$business_owner['business_website'];
			}
			
		} else {
			//header('Refresh: 12;url=http://www.idealtraits.com');
			$redirect_url = 'http://www.idealtraits.com';
		}
			History::maintainCandidateLog(9,'CANDIDATE_THANKYOU');
			//Auth::logout();
			//$request->session()->flush();
			$business_logo = $business_owner->business_logo;
			$job_res = []; 
			$job_id = Auth::user()->job_id;
			
			if (!empty($job_id) && !is_null($job_id)) {			
				$job_res = DB::table('jobs')->where('jobs.id','=',$job_id)->get();
			}
			return view('Candidate::thankyou.index', ['business_logo' => $business_logo,'job_res'=>$job_res,'redirect_url'=>$redirect_url,'business_owner'=>$business_owner]);
		
	}
	public function redirect(Request $request)
	{
		$business_id = Auth::user()->business_id;
		$business_owner = BusinessOwner::find($business_id);
		if(isset($request->r1) && $request->r1 == 1){
			 
			    $mail = Mailmst::find('CANDIDATE_OFFERPAGE_SUCCESS');
				$mail_data['subj'] = 	$mail->subject;
				$mail_data['from'] =$mail->from_id;
				$mail_data['to'] =Auth::user()->email;
				$details_arr = Contactinfo::find(Auth::id());
				
				
				$find_sub = array('%CANDIDATE_STATE%','%FIRST_NAME%]');
      $replace_sub = array($details_arr['state'],Auth::user()->first_name);
	  $subj = str_replace($find_sub,$replace_sub,$mail->subject);
			
      $find = array('%CANDIDATE_STATE%','%FIRST_NAME%');
      $replace = array($details_arr['state'],Auth::user()->first_name);
	  $message = str_replace($find,$replace, $mail->mail_content);
	  $mail_data['content'] = $message;
	  Mail::send(['html' => 'Candidate::emails.notification'], $mail_data, function ($message) use ($mail_data,$subj) {

			$message->from($mail_data['from'], 'IdealTraits.com');
		
			     $message->to($mail_data['to'], $mail_data['to'])->subject($subj);
				//$message->to('ramkumar@sdi.la', 'ramkumar@sdi.la')->subject($subj);
			 
		});		
			Auth::logout();
		$request->session()->flush();	
		header('Location:https://examfx.com/state-prelicensing');		
				
				
				
				
		}else{
		Auth::logout();
		$request->session()->flush();
			if(isset($business_owner['business_website']) && $business_owner['business_website'] != '' ) {
		  if( strpos( $business_owner['business_website'], 'http' ) !== false ) {
				header('Location:'.$business_owner['business_website']);
           }else{
		        header('Location:http://'.$business_owner['business_website']);
		   }
		
		} else {
			Auth::logout();
		$request->session()->flush();
			header('Location:http://www.idealtraits.com');
		}
		
	}
		
		exit;
	}
	
	
	public function redirectwithreport(Request $request)
	{
		/*if ($_SERVER['REMOTE_ADDR'] == '103.213.192.118'){
			echo $currentURL = URL::full();
			exit;
		}*/
		
		$business_id = Auth::user()->business_id;
		$business_owner = BusinessOwner::find($business_id);
	    if(isset($request->r1) && $request->r1 == 1){
			
				$details_arr = Contactinfo::find(Auth::id());
	            return view('Candidate::thankyou.payment',['candidate_arr' => $details_arr,'report_cost' => $request->report_cost]);
				//return redirect()->route('thankyou-redirectwithreport', ['candidate_arr' => $details_arr,'report_cost' => $request->report_cost]);
				
				
		}else{
		Auth::logout();
		$request->session()->flush();
			if(isset($business_owner['business_website']) && $business_owner['business_website'] != '' ) {
		  if( strpos( $business_owner['business_website'], 'http' ) !== false ) {
				header('Location:'.$business_owner['business_website']);
           }else{
		        header('Location:http://'.$business_owner['business_website']);
		   }
		
		} else {
			Auth::logout();
		$request->session()->flush();
			header('Location:http://www.idealtraits.com');
		}
		
		}
		
		exit;
	}
	
	public function businessownernotification_mail ($result,$candidate_mst,$business_owner,$mail_title) {


      $mail = Mailmst::find($mail_title);
	  $mail_data['subj'] = 	$mail->subject;
	  $mail_data['from'] = 	$mail->from_id;
	  $mail_data['to'] = $business_owner['username'];
	  

    	if($mail->mail_active == 'Y'){
			
			  	  $notification_email = DB::table('business_email_notification')
				   ->select("FINALTEST_COMPLETION_NOTIFICATION")
				   ->where('business_id', $business_owner->business_id)->first();
		
				$mail_data['notification'] = [];
				if(isset($notification_email->FINALTEST_COMPLETION_NOTIFICATION) && $notification_email->FINALTEST_COMPLETION_NOTIFICATION != '' ){
						   $notification_arr = explode(",", $notification_email->FINALTEST_COMPLETION_NOTIFICATION);
							$mail_data['notification'] = $notification_arr;
							
				 }
		

		
			  $find = array('%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%PROFILE_OUTCOME%','%CANDIDATE_SUMMARY_LINK%','%PHONE%','%EMAIL%');
			  if(isset($business_owner->current_package_id) && ($business_owner->current_package_id == '230' || $business_owner->current_package_id == '231' || $business_owner->current_package_id == '232'))  
				$replace = array($business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name	,$result['profile_result'],config('constants.appbase_path').'candidate/'.$candidate_mst->candidate_id.'?united=1',$candidate_mst->phone_no,$candidate_mst->email);
			  else
				$replace = array($business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name	,$result['profile_result'],config('constants.appbase_path').'candidate/'.$candidate_mst->candidate_id,$candidate_mst->phone_no,$candidate_mst->email);
			  $message = str_replace($find,$replace, $mail->mail_content);
			  
			  if(isset($business_owner->current_package_id) && ($business_owner->current_package_id == '230' || $business_owner->current_package_id == '231' || $business_owner->current_package_id == '232'))  
				$message = str_replace('https://mcusercontent.com/d4f46a2186022625deb05bef3/images/8f356cce-c0a5-139f-55df-9fb7d75d8005.png', 'https://app.idealtraits.com/assets/media/logos/UG_byIT_Logo.png' , $message);	 
			
			  $mail_data['content'] = $message;
			  $path=config('constants.appbase_path');
			  $original = $mail_data['content'];
			foreach($mail_data['notification'] as $to_email) {
				
					$to_email = trim($to_email);
					$subuser = BusinessOwnerSubuser::Where('username','=',$to_email)->first();
					if (!empty($subuser)) {
						$find = array('%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%PROFILE_OUTCOME%','%CANDIDATE_SUMMARY_LINK%','%PHONE%','%EMAIL%');
						if(isset($business_owner->current_package_id) && ($business_owner->current_package_id == '230' || $business_owner->current_package_id == '231' || $business_owner->current_package_id == '232'))  
							$replace = array($subuser->first_name,$candidate_mst->first_name,$candidate_mst->last_name	,$result['profile_result'],$path.'candidate/'.$candidate_mst->candidate_id.'?united=1',$candidate_mst->phone_no,$candidate_mst->email);
						else
							$replace = array($subuser->first_name,$candidate_mst->first_name,$candidate_mst->last_name	,$result['profile_result'],$path.'candidate/'.$candidate_mst->candidate_id,$candidate_mst->phone_no,$candidate_mst->email);
						$message1 = str_replace($find,$replace, $mail->mail_content);
						if(isset($business_owner->current_package_id) && ($business_owner->current_package_id == '230' || $business_owner->current_package_id == '231' || $business_owner->current_package_id == '232'))  
							$message1 = str_replace('https://mcusercontent.com/d4f46a2186022625deb05bef3/images/8f356cce-c0a5-139f-55df-9fb7d75d8005.png', 'https://app.idealtraits.com/assets/media/logos/UG_byIT_Logo.png' , $message1);	 
						$mail_data['content'] = $message1;
					} else {
						$mail_data['content'] = $original;
					}


					$subuser_email = 0;
					if(isset($candidate_mst->location_id) && ($candidate_mst->location_id!='')){
						$subuser_email = BusinessOwnerSubuser::where('business_id','=',$business_owner->business_id)
									->where('username',trim($to_email))
									->where(function($query) use ($candidate_mst) {
										$query->whereNull('allowlocation_ids')
											  ->orWhere(function($query) use ($candidate_mst) {
												  $query->whereRaw("FIND_IN_SET(?, allowlocation_ids)", [$candidate_mst->location_id]);
											  });
									})
									->count();
					}
		
					if($subuser_email==0){
						$subuser_email = BusinessOwner::where('business_id','=',$business_owner->business_id)->where('username',trim($to_email))->count();
					}

					
					if($subuser_email>0){
						Mail::send(['html' => 'Candidate::emails.notification'], $mail_data, function ($message) use ($mail_data, $notification_email,$to_email) {
				
								$message->from($mail_data['from'], 'IdealTraits.com');
								if(isset($notification_email)){
								if($notification_email->FINALTEST_COMPLETION_NOTIFICATION != ''){
									$message->to($to_email,$to_email )->subject($mail_data['subj']);					  
								}
								}else{
									$message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
								}
				
						});
					}
			  }	

			  // Job Notification
			  $Jobnotification =  DB::table('job_notification')->select("FINALTEST_COMPLETION_NOTIFICATION")->where('business_id',$candidate_mst->business_id)->where('job_id',$candidate_mst->job_id)->first();

			  $mail_data['jobnotification'] = [];
			  if(isset($Jobnotification->FINALTEST_COMPLETION_NOTIFICATION) && $Jobnotification->FINALTEST_COMPLETION_NOTIFICATION != '' ){
					 $jobnotification_arr = explode(",", $Jobnotification->FINALTEST_COMPLETION_NOTIFICATION);
					 $mail_data['jobnotification'] = $jobnotification_arr;
					  
			  }
			  
			  if (!empty($mail_data['jobnotification']) && is_array($mail_data['jobnotification'])) {
	  
				  foreach($mail_data['jobnotification'] as $to_email) {
					  
					  $to_email = trim($to_email);
					  
					  $mail_data['content'] = $original;
					  $message = $original;
	  
	  
					  
					  Mail::send(['html' => 'Candidate::emails.notification'], $mail_data, function ($mess) use ($mail_data, $Jobnotification,$to_email) {
	  
						  $mess->from($mail_data['from'], 'IdealTraits.com');
	  
						  if(isset($Jobnotification)){
	  
							  if($Jobnotification->FINALTEST_COMPLETION_NOTIFICATION != ''){
								  $mess->to($to_email,$to_email )->subject($mail_data['subj']);					  
							  }
						  }
	  
					  });
				  }
			  }
		}
		
		// Recruiter mail functionality
		if($business_owner->recruiter_id!='' && $business_owner->recruiter_connectedon!=''){
			$recruiter = Recruiter::find($business_owner->recruiter_id);
			if($recruiter){
				$recruitermail = Mailmst::find('RECRUITER_COMPLETED_CANDIDATE_RESULTS');
				$recruitermail_data['subj'] = 	$recruitermail->subject;
				$recruitermail_data['from'] = 	$recruitermail->from_id;
				$recruitermail_data['to'] = $recruiter->username;
				$recruiter_name = $recruiter->first_name.' '.$recruiter->last_name;

				if($recruitermail->mail_active == 'Y'){

					$recruiternotification_email = DB::table('recruiter_notifi_setting')->select("completed_result")->where('business_id', $business_owner->business_id)->where('recruiter_id', $business_owner->recruiter_id)->first();
					$recruitermail_data['notification'] = [];
					if(isset($recruiternotification_email->completed_result) && $recruiternotification_email->completed_result != '' ){
						$recruiternotification_arr = explode(",", $recruiternotification_email->completed_result);
						$recruitermail_data['notification'] = $recruiternotification_arr;
					}
					
					$recruiterfind = array('%COMPANY_NAME%','%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%PROFILE_OUTCOME%','%CANDIDATE_SUMMARY_LINK%','%PHONE%','%EMAIL%','%RECRUITER_NAME%');
					$recruiterreplace = array($business_owner->business_name,$business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name	,$result['profile_result'],config('constants.recruiter_path').'recruiter/viewjobappliedcand/'.$business_owner->business_id.'/'.$candidate_mst->candidate_id,$candidate_mst->phone_no,$candidate_mst->email,$recruiter_name);
			 		$recruitermessage = str_replace($recruiterfind,$recruiterreplace, $recruitermail->mail_content);

					$recruitermail_data['content'] = $recruitermessage;
					$path=config('constants.recruiter_path');
					$original = $recruitermail_data['content'];
					foreach($recruitermail_data['notification'] as $to_email) {
						$to_email = trim($to_email);
						//subrecruiter notify will come here
						$recruitermail_data['content'] = $original;

						Mail::send(['html' => 'Candidate::emails.notification'], $recruitermail_data, function ($recruitermessage) use ($recruitermail_data, $recruiternotification_email,$to_email) {
							$recruitermessage->from($recruitermail_data['from'], 'IdealTraits.com');
							if(isset($recruiternotification_email)){
							   if($recruiternotification_email->completed_result != ''){
								   $recruitermessage->to($to_email,$to_email )->subject($recruitermail_data['subj']);					  
							   }
							}else{
								$recruitermessage->to($recruitermail_data['to'], $recruitermail_data['to'])->subject($recruitermail_data['subj']);
							}
						});
					}
				}
			}
			
		}

	}
	/*public function businessownernotification_mail ($result,$candidate_mst,$business_owner,$mail_title) {


      $mail = Mailmst::find($mail_title);
	  $mail_data['subj'] = 	$mail->subject;
	  $mail_data['from'] = 	$mail->from_id;
	  $mail_data['to'] = $business_owner['username'];
	  

      if($mail->mail_active == 'Y'){			 
			  	  $notification_email = DB::table('business_email_notification')
				   ->select("FINALTEST_COMPLETION_NOTIFICATION")
				   ->where('business_id', $business_owner->business_id)->first();
		
		
				if(isset($notification_email->FINALTEST_COMPLETION_NOTIFICATION) && $notification_email->FINALTEST_COMPLETION_NOTIFICATION != '' ){
						   $notification_arr = explode(",", $notification_email->FINALTEST_COMPLETION_NOTIFICATION);
							$mail_data['notification'] = $notification_arr;
							
				 }
		
			  
		
			  $find = array('%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%PROFILE_OUTCOME%','%CANDIDATE_SUMMARY_LINK%');
			  $replace = array($business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name	,$result['profile_result'],config('constants.appbase_path').'candidate/'.$candidate_mst->candidate_id);
			  $message = str_replace($find,$replace, $mail->mail_content);
			  $mail_data['content'] = $message;
		
			  Mail::queue('Candidate::emails.notification', $mail_data, function ($message) use ($mail_data, $notification_email) {
		
					$message->from($mail_data['from'], 'IdealTraits.com');					
					if(isset($notification_email)){
					   if($notification_email->FINALTEST_COMPLETION_NOTIFICATION != ''){
						
						foreach($mail_data['notification'] as $to_email) {							
							$message->to($to_email,$to_email )->subject($mail_data['subj']);
						}
					   }
					}else{
						$message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
					 }
		
				});
		}


	}*/



	public function sendcandidatemail ($candidate_mst,$business_owner,$mail_title) {


      $mail = Mailmst::find($mail_title);
	  $mail_data['subj'] = 	$mail->subject;
	  $mail_data['from'] = 	$mail->from_id;
	  $mail_data['to'] =	$candidate_mst['email'];

	  if($mail->mail_active == 'Y'){ 
		  $find = array("%FIRST NAME%","%BUSINESS LOGO%");
			
		  if($business_owner->business_logo != "") {
					   $banner = $business_owner["business_logo"];
		   } else {
					   $banner =  "default_logo.jpg";
		  }	
	
		  $replace = array($candidate_mst->first_name . " " . $candidate_mst->last_name, config('constants.business_logo_path') . $banner  );
		  $message = str_replace($find,$replace, $mail->mail_content);
		  $mail_data['content'] = $message;
	
		  Mail::queue('Candidate::emails.notification', $mail_data, function ($message) use ($mail_data) {
	
				$message->from($mail_data['from'], 'IdealTraits.com');
				$message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
				
	
			});
		}

	}
	/*public function payment($report_cost,$err_flg =0){
		$details_arr = Contactinfo::find(Auth::id());
		return view('Candidate::thankyou.payment',['candidate_arr' => $details_arr,'report_cost' => $report_cost->report_cost,'errorflag' =>$err_flg]);
	}*/
	public function reportpayment(Request $request) {
		
		
		$year = substr($request->expDateYear, -2);
		$expirymonyear = $request->expDateMonth.$year;
		$expdate = $request->expDateYear. "-" .$request->expDateMonth;
		$trans['createTransactionRequest']['merchantAuthentication']['name'] ='993QJmnY';
		$trans['createTransactionRequest']['merchantAuthentication']['transactionKey'] = '4Ra2b3YzQf79f6eY';
		//$trans['createTransactionRequest']['merchantAuthentication']['name'] = '8A738kghaG5';
		//$trans['createTransactionRequest']['merchantAuthentication']['transactionKey'] = '5q8tfL7GbP9F69p5';
		$trans['createTransactionRequest']['transactionRequest']['transactionType'] = 'authCaptureTransaction';
		$trans['createTransactionRequest']['transactionRequest']['amount'] = $request->report_cost;
		$trans['createTransactionRequest']['transactionRequest']['payment']['creditCard']['cardNumber'] = $request->creditcardnumber;
		$trans['createTransactionRequest']['transactionRequest']['payment']['creditCard']['expirationDate'] = $expdate;
		$trans['createTransactionRequest']['transactionRequest']['payment']['creditCard']['cardCode'] = $request->cvvno; 
		
		
		$details_arr = Contactinfo::find(Auth::id());
		$contact_details = DB::table('candidate_details')->where('detail_id',$details_arr['detail_id'] )->first();
		$state_arr = State::where('state',$details_arr['state'])
		                    ->select('code')->first();

		$trans['createTransactionRequest']['transactionRequest']['billTo']['firstName'] = Auth::user()->first_name;
		$trans['createTransactionRequest']['transactionRequest']['billTo']['lastName'] = Auth::user()->last_name;
		$trans['createTransactionRequest']['transactionRequest']['billTo']['address'] = $details_arr['address1'].' '.$details_arr['address2'];
		//$trans['createTransactionRequest']['transactionRequest']['billTo']['city'] = $business_owner['city'];
		if(isset($state_arr) && $state_arr['code'] != '' ){
			$trans['createTransactionRequest']['transactionRequest']['billTo']['state'] = $state_arr['code'];
		}
		//$trans['createTransactionRequest']['transactionRequest']['billTo']['zip'] = $form_data['otherAmt_zipcode'];
		$trans['createTransactionRequest']['transactionRequest']['billTo']['country'] = 'USA';
	   
		$response = $this->paymentProcess($trans);
		
		$parsed_data = json_decode(preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $response),true);
		if(isset($parsed_data['transactionResponse'])){
		  $transaction = $parsed_data['transactionResponse'];
		
		
		 if($transaction['responseCode'] == '1' || $transaction['responseCode'] == '4' ) { 
			//view success message and redirected to business owner site
			
			
			
			  $mail = Mailmst::find('CANDIDATE_REPORT_SUMMARY');
				$find_sub = array("%FIRST NAME%");
				$replace_sub = array(Auth::user()->first_name);
				$subject = str_replace($find_sub,$replace_sub,$mail->subject);
				$mail_data['subj'] = 	$subject;
				$mail_data['from'] = 	$mail->from_id;
				$mail_data['to'] =	Auth::user()->email;
				//$mail_data['to'] =	'ramkumar@sdi.la';
			    $result_details = DB::table('result')->where('candidate_id',Auth::id())->first();
		        $result_id =$result_details->result_id;
				

			if($mail->mail_active == 'Y'){ 
				$find = array("%FIRST NAME%",'%CANDIDATE_REPORT_LINK%');
				$replace = array(Auth::user()->first_name,config('constants.base_path').'cronforduplicatejobs/summarypdfgeneration/id/'.$result_id);
				//$replace = array(Auth::user()->first_name, );
				$message = str_replace($find,$replace, $mail->mail_content);
				$mail_data['content'] = $message;
	
				Mail::queue('Candidate::emails.notification', $mail_data, function ($message) use ($mail_data) {
	
				$message->from($mail_data['from'], 'IdealTraits.com');
				$message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
				
				});
			}
			$business_id = Auth::user()->business_id;
				$business_owner = BusinessOwner::find($business_id);
				  if( strpos( $business_owner['business_website'], 'http' ) !== false ) {
					$business_website = $business_owner['business_website'];
				  }else{
					 $business_website = 'http://'.$business_owner['business_website'];
					//header('Location:http://'.$business_owner['business_website']);
				  }
			
             $report_amt = $request->report_cost;			
			$trac_arr		= array();
			$trac_arr['ResponseCode']	= $transaction['responseCode'];
			$trac_arr['tranNr']	        = $transaction['transId'];
			$trac_arr['PostDate']	    = date('Y-m-d h:i:s');
			$trac_arr['Amount']		    = $report_amt;
			$trac_arr['AmtDueRemaining']= 0;
			$trac_arr['CardBalance']	= 0;
			$trac_arr['Auth']	        = 0;
			$trac_arr['AVSCode']	    = $transaction['authCode'];
			$trac_arr['CVV2Response']	= $transaction['avsResultCode'];
			$trac_arr['ErrorCode']	    = $transaction['cavvResultCode'];
			$trac_arr['Name']	        = '';
			$trac_arr['ErrorMessage']	= '';
			$trac_arr['reason']			= 'Copy of Report with Candidate ID '.Auth::id();
			$trac_arr['bid']            = $business_id;
			$trac_arr['gateway_type']   = 'authorize';
			
			
			$transaction = Transaction::create($trac_arr);	  
				  
				  
				
			 return view('Candidate::thankyou.paymentsuccess',['business_website' =>  $business_website ]);
		 }else{
			 
			 
			 $report_cost = DB::table('candidateofferpage')
				   ->select('candidateofferpage.report_cost')
				   ->where('candidateofferpage.content_id', "=",3)->first();
			   
			 $details_arr = Contactinfo::find(Auth::id());
	        return view('Candidate::thankyou.payment',['candidate_arr' => $details_arr,'report_cost' => $report_cost->report_cost,'errorflag' =>1]);
			
		 }
		}else{
			   
			 $report_cost = DB::table('candidateofferpage')
				   ->select('candidateofferpage.report_cost')
				   ->where('candidateofferpage.content_id', "=",3)->first();
			   
			 $details_arr = Contactinfo::find(Auth::id());
			 
	         return view('Candidate::thankyou.payment',['candidate_arr' => $details_arr,'report_cost' => $report_cost->report_cost,'errorflag' =>1]);
			
			exit;
		}
	}
   public function payment( ){
	   $details_arr = Contactinfo::find(Auth::id());
			 
	   return view('Candidate::thankyou.payment',['candidate_arr' => $details_arr,'report_cost' => '1.99','errorflag' =>1]);
			
   }

	
	public function paymentProcess($auth_data){

		
		
		//$url = "https://apitest.authorize.net/xml/v1/request.api";
		$url = "https://api.authorize.net/xml/v1/request.api";  // live URL
		$request = curl_init($url); // initiate curl object
		curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response
		curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)
		curl_setopt($request, CURLOPT_POSTFIELDS, json_encode($auth_data)); // use HTTP POST to send form data
		curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment this line if you get no gateway response.
		$post_response = curl_exec($request); // execute curl post and store results in $post_response
		// additional options may be required depending upon your server configuration
		// you can find documentation on curl options at http://www.php.net/curl_setopt
		curl_close ($request);
		
		return $post_response;
	}

	//webhook start
	public function candiddetailstowebhook($uri,$candidate_id,$trigger_type,$webhook_id,$tag){
		$candidate = Candidatemst::find($candidate_id);

		if($trigger_type!='job'){
			$zapiercandidate_arr['candidate_ID'] = $candidate->candidate_id;
			$zapiercandidate_arr['First_name'] =$candidate->first_name ;
			$zapiercandidate_arr['Last_name'] =$candidate->last_name ;
			$zapiercandidate_arr['Email'] =$candidate->email ;
			$zapiercandidate_arr['Phone_no'] =$candidate->phone_no ;
			$zapiercandidate_arr['Assessment_username'] =$candidate->username;
			$zapiercandidate_arr['Assessment_id'] =$candidate->test_id ;
			$zapiercandidate_arr['Job_id'] =$candidate->job_id;
			$zapiercandidate_arr['Business_id'] =$candidate->business_id ;
			$zapiercandidate_arr['Source'] =$candidate->source ;
			$zapiercandidate_arr['Date_added'] = Carbon::parse($candidate->getOriginal('date_added'))->format('Y-m-d H:i:s');
			$zapiercandidate_arr['Date_modified'] = Carbon::parse($candidate->date_modified)->format('Y-m-d H:i:s');
			$zapiercandidate_arr['Stage'] =$candidate->status;
			$zapiercandidate_arr['Location_applied'] ='Primary Location';
			$zapiercandidate_arr['Webhook_tag'] = $tag;
			$zapiercandidate_arr['Candidate_tags'] = $candidate->candidate_tags;
			$zapiercandidate_arr['Resume_url'] = '';
			$zapiercandidate_arr['Assessment_url'] = '';
			$zapiercandidate_arr['Assessment_current_page'] = $candidate->current_page;
			$zapiercandidate_arr['Job_title'] ='';
			$zapiercandidate_arr['Position_name'] = '';
			$zapiercandidate_arr['Assessment_summary_URL'] = '';
			$zapiercandidate_arr['Archive_tag'] = $candidate->archive_tag;
			$zapiercandidate_arr['offer_expiration_date'] = $candidate->offer_expirydate;
			$zapiercandidate_arr['offer_created_date'] = $candidate->offer_createdAt;
			$zapiercandidate_arr['offer_signed_date'] = $candidate->offer_signedAt;
			$zapiercandidate_arr['hired_date'] = $candidate->hired_date;
			$zapiercandidate_arr['Star_rating'] = $candidate->star_rate;
			$zapiercandidate_arr['video_invite_date'] = $candidate->video_invitedate;
			$zapiercandidate_arr['video_interview_status'] = '';
			if($candidate->video_interviewstatus=='2'){
				$zapiercandidate_arr['video_interview_status'] =  'In-Progress';
			}
			elseif($candidate->video_interviewstatus=='3'){
				$zapiercandidate_arr['video_interview_status'] = 'Complete';
			}elseif($candidate->video_interviewstatus=='1'){
				$zapiercandidate_arr['video_interview_status'] = 'Send';
			}
			
			$zapiercandidate_arr['smstext_consent']  = 'Did not Consent';
			if($candidate->smstxt_consent=='1'){
				$zapiercandidate_arr['smstext_consent']  = 'Consented';
			}
			
			$candidate_det = Contactdetails::where('candidate_id',$candidate->candidate_id)->orderBy('detail_id','desc')->first();
			if($candidate_det){
				if($candidate_det->resume!=''){
					$zapiercandidate_arr['Resume_url'] = 'https://app.idealtraits.com/storage/upload/resume/'.$candidate_det->resume;
				}
			}
			if($candidate->test_id!=''){
				$assessment_link ="https://test.idealtraits.com/public/busid/".base64_encode($candidate->business_id)."/tid/".base64_encode($candidate->test_id)."/uuid/".base64_encode($candidate->username)."/canid/".base64_encode($candidate->candidate_id);
				$zapiercandidate_arr['Assessment_url'] = $assessment_link;
			}

			$job = DB::table('jobs')->find($candidate->job_id);
			if($job){
				$zapiercandidate_arr['Job_title'] = $job->job_title;
			}

			$test_mst = Testmst::join('position_mst', 'position_mst.position_id', '=', 'test_mst.position_id')
					->where('test_mst.test_id','=',$candidate->test_id )
					->select('position_mst.position_title')->first();
			if ($test_mst) {
				$zapiercandidate_arr['Position_name'] =$test_mst->position_title;
			}

			$location = Location::find($candidate->location_id);
			if($location){
				$zapiercandidate_arr['Location_applied'] = $location->nickname;
			}

			$zapiercandidate_arr['personality_profile_result'] = '';
			$zapiercandidate_arr['problem_solving_result'] ='';
			$zapiercandidate_arr['problem_solving_score'] = '';
			$zapiercandidate_arr['self_perception_motivation_drive'] = '';
			$zapiercandidate_arr['self_perception_persuasive_convincing'] = '';
			$zapiercandidate_arr['self_perception_structure_routine'] = '';
			$zapiercandidate_arr['self_perception_thorough_compliance'] = '';
			$zapiercandidate_arr['under_pressure_motivation_drive'] = '';
			$zapiercandidate_arr['under_pressure_persuasive_convincing'] = '';
			$zapiercandidate_arr['under_pressure_structure_routine'] = '';
			$zapiercandidate_arr['under_pressure_thorough_compliance'] = '';
			$zapiercandidate_arr['others_perception_motivation_drive'] = '';
			$zapiercandidate_arr['others_perception_persuasive_convincing'] = '';
			$zapiercandidate_arr['others_perception_structure_routine'] = '';
			$zapiercandidate_arr['others_perception_thorough_compliance'] = '';

			$zapiercandidate_arr['pqq_question_1'] ='';
			$zapiercandidate_arr['pqq_answer_1'] ='';
			$zapiercandidate_arr['pqq_score_1'] ='';

			$zapiercandidate_arr['video_question_1'] ='';
			$zapiercandidate_arr['video_transcription_1'] ='';

			$zapiercandidate_arr['short_answer_question_1'] = '';
			$zapiercandidate_arr['short_answer_1'] = '';

			if($candidate->result){
				$zapiercandidate_arr['personality_profile_result'] = $candidate->result->profile_result;
				$zapiercandidate_arr['problem_solving_result'] = $candidate->result->iq_result;
				$zapiercandidate_arr['problem_solving_score'] = PsResults::where('result','Correct')->where('candidate_id',$candidate->candidate_id)->where('test_id',$candidate->test_id)->count();

				$zapiercandidate_arr['self_perception_motivation_drive'] = $candidate->result->SP_M;
				$zapiercandidate_arr['self_perception_persuasive_convincing'] = $candidate->result->SP_P;
				$zapiercandidate_arr['self_perception_structure_routine'] = $candidate->result->SP_S;
				$zapiercandidate_arr['self_perception_thorough_compliance'] = $candidate->result->SP_T;
				$zapiercandidate_arr['under_pressure_motivation_drive'] = $candidate->result->UP_M;
				$zapiercandidate_arr['under_pressure_persuasive_convincing'] = $candidate->result->UP_P;
				$zapiercandidate_arr['under_pressure_structure_routine'] = $candidate->result->UP_S;
				$zapiercandidate_arr['under_pressure_thorough_compliance'] = $candidate->result->UP_T;
				$zapiercandidate_arr['others_perception_motivation_drive'] = $candidate->result->OP_M;
				$zapiercandidate_arr['others_perception_persuasive_convincing'] = $candidate->result->OP_P;
				$zapiercandidate_arr['others_perception_structure_routine'] = $candidate->result->OP_S;
				$zapiercandidate_arr['others_perception_thorough_compliance'] = $candidate->result->OP_T;


				if($candidate->result->short_answer=='1'){
					$shortans = Shortanswer::where('candidate_id',$candidate->candidate_id)->where('test_id',$candidate->test_id)->first();
					if($shortans){
						$zapiercandidate_arr['short_answer_question_1'] = $shortans->short_question1;
						$zapiercandidate_arr['short_answer_1'] = $shortans->answer_1;
						$zapiercandidate_arr['short_answer_question_2'] = $shortans->short_question2;
						$zapiercandidate_arr['short_answer_2'] = $shortans->answer_2;
						$zapiercandidate_arr['short_answer_question_3'] = $shortans->short_question3;
						$zapiercandidate_arr['short_answer_3'] = $shortans->answer_3;
						$zapiercandidate_arr['short_answer_question_4'] = $shortans->short_question4;
						$zapiercandidate_arr['short_answer_4'] = $shortans->answer_4;
						$zapiercandidate_arr['short_answer_question_5'] = $shortans->short_question5;
						$zapiercandidate_arr['short_answer_5'] = $shortans->answer_5;
					}
				}

				if($candidate->result->profile_result != 'No result'){

					// $pdf_service_url = "https://app.idealtraits.com/getsummarypdf/".$candidate->result->result_id;
					$pdf_service_url = "http://localbusiness/getsummarypdf/".$candidate->result->result_id;
					$ch_pdf = curl_init();
					curl_setopt($ch_pdf, CURLOPT_URL, $pdf_service_url);
					curl_setopt($ch_pdf, CURLOPT_RETURNTRANSFER, 1);
					// IMPORTANT: Set to true in production for security!
					curl_setopt($ch_pdf, CURLOPT_SSL_VERIFYPEER, false);
					curl_setopt($ch_pdf, CURLOPT_TIMEOUT, 10); // Add a timeout for robustness

					$response_pdf = curl_exec($ch_pdf);
					$httpcode_pdf = curl_getinfo($ch_pdf, CURLINFO_HTTP_CODE);
					$error_pdf = curl_error($ch_pdf);
					curl_close($ch_pdf);

					if ($response_pdf !== false && $httpcode_pdf >= 200 && $httpcode_pdf < 300) {
               		 // Assuming the PDF service returns the URL directly as a string or in a JSON object
					$pdf_data = json_decode($response_pdf, true);
					if (isset($pdf_data['pdf_url'])) {
						$fetched_pdf_url = $pdf_data['pdf_url'];
						$zapiercandidate_arr['Assessment_summary_URL'] = $fetched_pdf_url;
						Log::info("Successfully fetched PDF URL for candidate_id: {$candidate->candidate_id} from external service. URL: {$fetched_pdf_url}", [
							'candidate_id' => $candidate->candidate_id,
							'result_id' => $candidate->result->result_id,
							'external_service_url' => $pdf_service_url
						]);
					} else {
						// The service returned a 2xx status, but no 'pdf_url' in JSON.
						// Try to get it as plain text, but log a warning.
						$zapiercandidate_arr['Assessment_summary_URL'] = trim($response_pdf);
						Log::warning("External PDF service returned success but no 'pdf_url' key for candidate_id: {$candidate->candidate_id}. Raw response: {$response_pdf}", [
							'candidate_id' => $candidate->candidate_id,
							'result_id' => $candidate->result->result_id,
							'external_service_url' => $pdf_service_url,
							'http_code' => $httpcode_pdf,
							'response_body' => $response_pdf
						]);
					}
				} else {
					// Curl failed or returned a non-2xx status
					$zapiercandidate_arr['Assessment_summary_URL'] = ''; // Ensure it's empty on failure
					Log::error("Failed to fetch PDF URL for candidate_id: {$candidate->candidate_id} from external service.", [
						'candidate_id' => $candidate->candidate_id,
						'result_id' => $candidate->result->result_id,
						'external_service_url' => $pdf_service_url,
						'http_code' => $httpcode_pdf,
						'curl_error' => $error_pdf,
						'response_body' => $response_pdf
					]);
				}

				
				}

			}
			
			$preq_answers = Prequalifyanswer::where('candidate_id',$candidate->candidate_id)->where('job_id',$candidate->job_id)->get();
			if($preq_answers->count()>0){
				$kk=0;
				foreach($preq_answers as $prequalify_ans){ 
				$kk++;
					$pq_question = Prequalifybusinessquestion::select('question')->find($prequalify_ans->question_id);

					$zapiercandidate_arr['pqq_question_'.$kk] =$pq_question->question;
					$zapiercandidate_arr['pqq_answer_'.$kk] =$prequalify_ans->answer;
					if ($prequalify_ans->is_score_enabled =='Y')
						$zapiercandidate_arr['pqq_score_'.$kk] =$prequalify_ans->score;
				}
			}


			if($candidate->video_interviewstatus>='3'){
				$attempt = Attempt::select('id','candidate_id','question_id','ai_trans_txt','ai_processed')->where('candidate_id',$candidate->candidate_id)->get();
				if($attempt->count()>0){
					$kk=0;
					foreach($attempt as $video_attempt){
					$kk++;
						$question = Question::select('question')->find($video_attempt->question_id);
						$zapiercandidate_arr['video_question_'.$kk] =$question->question;
						$zapiercandidate_arr['video_transcription_'.$kk] =$video_attempt->ai_trans_txt;
					}
				}else{
					$videoattempt = Videoattemptdelete::where('candidate_id',$candidate->candidate_id)->where('interview_id',$candidate->video_interview_id)->first();
					if($videoattempt){
						// $details = json_decode($videoattempt->details, true);
						$details = $videoattempt->details;
						if (is_array($details)) {
							$kk = 0;
							foreach ($details as $detail) {
								$kk++;
								$zapiercandidate_arr['video_question_' . $kk] = isset($detail['question']) ? $detail['question'] : '';
								$zapiercandidate_arr['video_transcription_' . $kk] = isset($detail['ai_trans_txt']) ? $detail['ai_trans_txt'] : '';
							}
						}
					}
				}
			}


		}

		$this->sendpayloadtowebhook($uri,$zapiercandidate_arr,$trigger_type,$webhook_id,$candidate->business_id);
	}

	public function sendpayloadtowebhook($uri,$fields,$trigger_type,$webhook_id,$business_id){

		$fields_string ='';
		foreach($fields as $key=>$value) { $fields_string .= $key.'='.urlencode($value).'&'; }
		$fields_string = rtrim($fields_string, '&');
						
		$uri = $uri.'?'.$fields_string;	

		//echo '<br>uri='. $uri;		
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $uri);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Keep this for dev, but re-enable for prod
		curl_setopt($ch, CURLOPT_POST, 1);

		$headers = array();
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Accept: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);

		$response = curl_exec($ch);
		// if (curl_errno($ch)) {
		// 	echo 'Error:' . curl_error($ch);
		// }

		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);

		 // --- Parse headers and body from the curl response ---
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $headers = substr($response, 0, $header_size);
        $body = substr($response, $header_size);
        // --- End parsing ---

		curl_close($ch);

		$webhooklog= new WebhookLog();
		$webhooklog->business_id = $business_id;
		$webhooklog->event_type = $trigger_type;
		$webhooklog->webhook_id = $webhook_id;
		$webhooklog->request_body = json_encode($fields);
		$webhooklog->attempt_tried = '1';
		$webhooklog->created_at = date('Y-m-d H:i:s');

		if ($response === false) {
			$webhooklog->response_code = $httpcode;
			$webhooklog->status='0';
			$webhooklog->comment='Curl error during webhook';
		 }else{
			$webhooklog->response_code = $httpcode;
			if ($httpcode >= 200 && $httpcode < 300) {
				$webhooklog->status='1';
				$webhooklog->response_body = json_decode($body, true);
				$webhooklog->comment='Webhook works successfully.';
				
			} else {
				$webhooklog->status='0';
				$webhooklog->response_body = $body;
				$webhooklog->comment='Webhook returned an error status.';
				
			}
		}
		$webhooklog->save();
		return $response;

	}

	public function getwebhookbytriggername($trigger_type,$business_id){
		return Webhooks::where('event_trigger',$trigger_type)->where('business_id',$business_id)->where('status','1')->get();
	}
	//webhook end

	public function candidatedetailsToZapier($uri,$candidate_id){
		$candidate = Candidatemst::find($candidate_id);
		$zapiercandidate_arr['candidate_id'] = $candidate->candidate_id;
		$zapiercandidate_arr['first_name'] =$candidate->first_name ;
		$zapiercandidate_arr['last_name'] =$candidate->last_name ;
		$zapiercandidate_arr['email'] =$candidate->email ;
		$zapiercandidate_arr['phone_no'] =$candidate->phone_no ;
		$zapiercandidate_arr['username'] =$candidate->username;
		$zapiercandidate_arr['test_id'] =$candidate->test_id ;
		$zapiercandidate_arr['job_id'] =$candidate->job_id;
		$zapiercandidate_arr['business_id'] =$candidate->business_id ;
		$zapiercandidate_arr['source'] =$candidate->source ;
		$zapiercandidate_arr['date_added'] = Carbon::parse($candidate->getOriginal('date_added'))->format('Y-m-d H:i:s');
		$zapiercandidate_arr['date_modified'] = Carbon::parse($candidate->date_modified)->format('Y-m-d H:i:s');
		$zapiercandidate_arr['status'] =$candidate->status;
		$zapiercandidate_arr['location_id'] =$candidate->location_id ;
		$zapiercandidate_arr['tag'] = 'Update';
		$zapiercandidate_arr['candidate_tags'] = $candidate->candidate_tags;
		$zapiercandidate_arr['resume'] = '';
		$zapiercandidate_arr['assessment_link'] = '';
		$zapiercandidate_arr['current_page'] = $candidate->current_page;
		$zapiercandidate_arr['job_title'] = '';
		$zapiercandidate_arr['position_name'] = '';
		$zapiercandidate_arr['archive_tag'] = $candidate->archive_tag;
		$zapiercandidate_arr['offer_expirydate'] = $candidate->offer_expirydate;
		$zapiercandidate_arr['offer_createdat'] = $candidate->offer_createdAt;
		$zapiercandidate_arr['offer_signedat'] = $candidate->offer_signedAt;
		$zapiercandidate_arr['hired_date'] = $candidate->hired_date;
		$zapiercandidate_arr['terminated_date'] = $candidate->terminated_date;
		$zapiercandidate_arr['star_rate'] = $candidate->star_rate;
		$zapiercandidate_arr['video_invitedate'] = $candidate->video_invitedate;
		$zapiercandidate_arr['video_interviewstatus'] = $candidate->video_interviewstatus;
		$zapiercandidate_arr['smstext_consent'] = $candidate->smstxt_consent;
		$zapiercandidate_arr['profile_result'] = '';
		$zapiercandidate_arr['iq_result'] = '';
		$zapiercandidate_arr['problem_solving_score'] = '';
		$zapiercandidate_arr['sp_m'] = '';
		$zapiercandidate_arr['sp_p'] = '';
		$zapiercandidate_arr['sp_s'] = '';
		$zapiercandidate_arr['sp_t'] = '';
		$zapiercandidate_arr['up_m'] = '';
		$zapiercandidate_arr['up_p'] = '';
		$zapiercandidate_arr['up_s'] = '';
		$zapiercandidate_arr['up_t'] = '';
		$zapiercandidate_arr['op_m'] = '';
		$zapiercandidate_arr['op_p'] = '';
		$zapiercandidate_arr['op_s'] = '';
		$zapiercandidate_arr['op_t'] = '';

		$zapiercandidate_arr['pq_question_1'] ='';
		$zapiercandidate_arr['pq_answer_1'] ='';
		$zapiercandidate_arr['pq_score_1'] ='';

		$zapiercandidate_arr['video_question_1'] ='';
		$zapiercandidate_arr['video_transcription_1'] ='';

		$zapiercandidate_arr['short_question_1'] = '';
		$zapiercandidate_arr['short_answer_1'] = '';
		
		$candidate_det = Contactdetails::where('candidate_id',$candidate->candidate_id)->orderBy('detail_id','desc')->first();
		if($candidate_det){
			if($candidate_det->resume!=''){
				$zapiercandidate_arr['resume'] = 'https://app.idealtraits.com/storage/upload/resume/'.$candidate_det->resume;
			}
		}

		if($candidate->test_id!=''){
			$assessment_link ="https://test.idealtraits.com/public/busid/".base64_encode($candidate->business_id)."/tid/".base64_encode($candidate->test_id)."/uuid/".base64_encode($candidate->username)."/canid/".base64_encode($candidate->candidate_id);
			$zapiercandidate_arr['assessment_link'] = $assessment_link;
		}

		$job = DB::table('jobs')->find($candidate->job_id);
		if($job){
			$zapiercandidate_arr['job_title'] = $job->job_title;
		}
		$test_mst = Testmst::join('position_mst', 'position_mst.position_id', '=', 'test_mst.position_id')
			 ->where('test_mst.test_id','=',$candidate->test_id )
			 ->select('position_mst.position_title')->first();
		if ($test_mst) {
			$zapiercandidate_arr['position_name'] =$test_mst->position_title;
		}

		if($candidate->result){
			$zapiercandidate_arr['profile_result'] = $candidate->result->profile_result;
			$zapiercandidate_arr['iq_result'] = $candidate->result->iq_result;
			$zapiercandidate_arr['problem_solving_score'] = '';
			$zapiercandidate_arr['sp_m'] = $candidate->result->SP_M;
			$zapiercandidate_arr['sp_p'] = $candidate->result->SP_P;
			$zapiercandidate_arr['sp_s'] = $candidate->result->SP_S;
			$zapiercandidate_arr['sp_t'] = $candidate->result->SP_T;
			$zapiercandidate_arr['up_m'] = $candidate->result->UP_M;
			$zapiercandidate_arr['up_p'] = $candidate->result->UP_P;
			$zapiercandidate_arr['up_s'] = $candidate->result->UP_S;
			$zapiercandidate_arr['up_t'] = $candidate->result->UP_T;
			$zapiercandidate_arr['op_m'] = $candidate->result->OP_M;
			$zapiercandidate_arr['op_p'] = $candidate->result->OP_P;
			$zapiercandidate_arr['op_s'] = $candidate->result->OP_S;
			$zapiercandidate_arr['op_t'] = $candidate->result->OP_T;


			if($candidate->result->short_answer=='1'){
				$shortans = Shortanswer::where('candidate_id',$candidate->candidate_id)->where('test_id',$candidate->test_id)->first();
				if($shortans){
					$zapiercandidate_arr['short_question_1'] = $shortans->short_question1;
					$zapiercandidate_arr['short_answer_1'] = $shortans->answer_1;
					$zapiercandidate_arr['short_question_2'] = $shortans->short_question2;
					$zapiercandidate_arr['short_answer_2'] = $shortans->answer_2;
					$zapiercandidate_arr['short_question_3'] = $shortans->short_question3;
					$zapiercandidate_arr['short_answer_3'] = $shortans->answer_3;
					$zapiercandidate_arr['short_question_4'] = $shortans->short_question4;
					$zapiercandidate_arr['short_answer_4'] = $shortans->answer_4;
					$zapiercandidate_arr['short_question_5'] = $shortans->short_question5;
					$zapiercandidate_arr['short_answer_5'] = $shortans->answer_5;
				}
			}

			$zapiercandidate_arr['problem_solving_score'] = PsResults::where('result','Correct')->where('candidate_id',$candidate->candidate_id)->where('test_id',$candidate->test_id)->count();
		}

		$preq_answers = Prequalifyanswer::where('candidate_id',$candidate->candidate_id)->where('job_id',$candidate->job_id)->get();
		if($preq_answers->count()>0){
			$kk=0;
			foreach($preq_answers as $prequalify_ans){ 
			$kk++;
				$pq_question = Prequalifybusinessquestion::select('question')->find($prequalify_ans->question_id);

				$zapiercandidate_arr['pq_question_'.$kk] =$pq_question->question;
				$zapiercandidate_arr['pq_answer_'.$kk] =$prequalify_ans->answer;
				if ($prequalify_ans->is_score_enabled =='Y')
					$zapiercandidate_arr['pq_score_'.$kk] =$prequalify_ans->score;
			}
		}

		if($candidate->video_interviewstatus>='3'){
			$attempt = Attempt::select('id','candidate_id','question_id','ai_trans_txt','ai_processed')->where('candidate_id',$candidate->candidate_id)->get();
			if($attempt->count()>0){
				$kk=0;
				foreach($attempt as $video_attempt){
				$kk++;
					$question = Question::select('question')->find($video_attempt->question_id);
					$zapiercandidate_arr['video_question_'.$kk] =$question->question;
					$zapiercandidate_arr['video_transcription_'.$kk] =$video_attempt->ai_trans_txt;
				}
			}else{
				$videoattempt = Videoattemptdelete::where('candidate_id',$candidate->candidate_id)->where('interview_id',$candidate->video_interview_id)->first();
				if($videoattempt){
					$details = json_decode($videoattempt->details, true);
					if (is_array($details)) {
						$kk = 0;
						foreach ($details as $detail) {
							$kk++;
							$zapiercandidate_arr['video_question_' . $kk] = isset($detail['question']) ? $detail['question'] : '';
							$zapiercandidate_arr['video_transcription_' . $kk] = isset($detail['ai_trans_txt']) ? $detail['ai_trans_txt'] : '';
						}
					}
				}
			}
		}

		$this->sendCandidatesToZapier($uri,$zapiercandidate_arr);
		
	}

	public function sendCandidatesToZapier($uri,$fields){
		$fields_string ='';
		foreach($fields as $key=>$value) { $fields_string .= $key.'='.urlencode($value).'&'; }
		$fields_string = rtrim($fields_string, '&');
						
		$uri = $uri.'?'.$fields_string;	

		//echo '<br>uri='. $uri;		
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $uri);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$headers = array();
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Accept: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
	}


	public function sendCandidateToZapier($uri,$fields){
		//url-ify the data for the POST
		$fields_string ='';
						
		$candidate_details = DB::table('candidate_details')->where('candidate_id',Auth::id() )
			        ->where('test_id',Auth::user()->test_id)
			        ->first();
					
		$result_arr = DB::table('result')->where('candidate_id',Auth::id() )
			        ->first();
					
		$position_arr = DB::table('test_mst')->where('test_id',Auth::user()->test_id )
				->join('position_mst','position_mst.position_id', '=', 'test_mst.position_id')
				->select('position_mst.position_title')
			    ->first();
				
		$sa_data = Shortanswer::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id])->first();
		$ps_result1 = PsResults::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id,'result'=>'Correct'])->first();
		$ps_result = PsResults::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id,'result'=>'Correct'])->orderBy('iq_id')->get();
		$ps_result_count =	$ps_result->count();		
		//if ($candidate_details->resume !='' && $candidate_details['resume'] !== NULL) {
		if (!empty($candidate_details->resume) && !is_null($candidate_details->resume) ) {
			$resume_url = 'http://dashboard.idealtraits.com/upload/resume/'.$candidate_details->resume;
			$fields['resume'] = $resume_url;
		}
		
		if (!empty($result_arr->profile_result) && !is_null($result_arr->profile_result) ) {
			$profile_result = $result_arr->profile_result;
			$fields['profile_result'] = $profile_result;
		}
		if (!empty($result_arr->iq_result) && !is_null($result_arr->iq_result) ) {
			$iq_result = $result_arr->iq_result;
			$fields['iq_result'] = $iq_result;
		}
		
		if (!empty($position_arr->position_title) && !is_null($position_arr->position_title) ) {
			$position_title = $position_arr->position_title;
			$fields['position_title'] = $position_title;
		}
		$fields['short_answer_answer_1'] = '';
		$fields['short_answer_answer_2'] = '';
		$fields['short_answer_answer_3'] = '';
		$fields['short_answer_answer_4'] = '';
		$fields['short_answer_answer_5'] = '';
		if (isset($sa_data->answer_1) && !empty($sa_data->answer_1) && !is_null($sa_data->answer_1) ) {
			$fields['short_answer_answer_1'] = $sa_data->answer_1;
		}
		if (isset($sa_data->answer_2) && !empty($sa_data->answer_2) && !is_null($sa_data->answer_2) ) {
			$fields['short_answer_answer_2'] = $sa_data->answer_2;
		}
		if (isset($sa_data->answer_3) && !empty($sa_data->answer_3) && !is_null($sa_data->answer_3) ) {
			$fields['short_answer_answer_3'] = $sa_data->answer_3;
		}
		if (isset($sa_data->answer_4) && !empty($sa_data->answer_4) && !is_null($sa_data->answer_4) ) {
			$fields['short_answer_answer_4'] = $sa_data->answer_4;
		}
		if (isset($sa_data->answer_5) && !empty($sa_data->answer_5) && !is_null($sa_data->answer_5) ) {
			$fields['short_answer_answer_5'] = $sa_data->answer_5;
		}
		if (isset($ps_result1->result) && !empty($ps_result1->result) && !is_null($ps_result1->result) ) {
			$fields['problem_solving_score'] = $ps_result_count.'/15';
		}
		 
		/*$SP_M = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 3),':',-1)*3.57142);
		$SP_P = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 5),':',-1)*3.57142);
		$SP_S = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 7),':',-1)*3.57142);
		$SP_T = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 9),':',-1)*3.57142);
		
		$UP_M = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 12),':',-1)*3.57142);
		$UP_P = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 14),':',-1)*3.57142);
		$UP_S = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 16),':',-1)*3.57142);
		$UP_T = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 18),':',-1)*3.57142);
		
		$OP_M = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 21),':',-1)*3.57142);
		$OP_P = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 23),':',-1)*3.57142);
		$OP_S = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 25),':',-1)*3.57142);
		$OP_T = round($this->substring_index($this->substring_index($result_arr->chart_data, ';', 27),':',-1)*3.57142);*/
		
		$chart_data_arr = unserialize($result_arr->chart_data);

		$data['most-d'] = $chart_data_arr['most']['D'];
		$data['most-i'] = $chart_data_arr['most']['I'];	
		$data['most-s'] = $chart_data_arr['most']['S'];	
		$data['most-c'] = $chart_data_arr['most']['C'];	
		$data['least-d'] = $chart_data_arr['least']['D'];	
		$data['least-i'] = $chart_data_arr['least']['I'];	
		$data['least-s'] = $chart_data_arr['least']['S'];	
		$data['least-c'] = $chart_data_arr['least']['C'];
		

		$data['diff-d'] = $chart_data_arr['diff']['D'];	
		$data['diff-i'] = $chart_data_arr['diff']['I'];	
		$data['diff-s'] = $chart_data_arr['diff']['S'];	
		$data['diff-c'] = $chart_data_arr['diff']['C'];
		
		$SP_M = round($data['most-d']*3.57142);
		$SP_P = round($data['most-i']*3.57142);
		$SP_S = round($data['most-s']*3.57142);
		$SP_T = round($data['most-c']*3.57142);
		
		$UP_M = round($data['least-d']*3.57142);
		$UP_P = round($data['least-i']*3.57142);
		$UP_S = round($data['least-s']*3.57142);
		$UP_T = round($data['least-c']*3.57142);
		
		$OP_M = round($data['diff-d']*3.57142);
		$OP_P = round($data['diff-i'] *3.57142);
		$OP_S = round($data['diff-s']*3.57142);
		$OP_T = round($data['diff-c']*3.57142);
		
		$fields['SP_M'] = $SP_M;
		$fields['SP_P'] = $SP_P;
		$fields['SP_S'] = $SP_S;
		$fields['SP_T'] = $SP_T;
		$fields['UP_M'] = $UP_M;
		$fields['UP_P'] = $UP_P;
		$fields['UP_S'] = $UP_S;
		$fields['UP_T'] = $UP_T;
		$fields['OP_M'] = $OP_M;
		$fields['OP_P'] = $OP_P;
		$fields['OP_S'] = $OP_S;
		$fields['OP_T'] = $OP_T;
		foreach($fields as $key=>$value) { $fields_string .= $key.'='.urlencode($value).'&'; }
		$fields_string = rtrim($fields_string, '&');
		
		
		//$uri = 'https://secure.indeed.com/oauth/tokens?'.$fields_string;	
		//$uri = 'https://hooks.zapier.com/hooks/catch/8777323/olm51ka/?'.$fields_string;				
		$uri = $uri.'?'.$fields_string;	

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $uri);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$headers = array();
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Accept: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);		
	}
	
	public function sharejob(Request $request)
	{
		//return response()->json(['data'=>$request->input('toemail')]);
		//$to_arr = explode(",", $request->input('toemail'));
		//return response()->json(['data'=>$to_arr[0]]);
		$test_id = Auth::user()->test_id;

		$candidate_id = Auth::id();

		$business_id = Auth::user()->business_id;
		$business_owner = BusinessOwner::find($business_id);
		
		$job_id = Auth::user()->job_id;
		if (!empty($job_id) && !is_null($job_id)) {			
			$job_res = DB::table('jobs')->where('jobs.id','=',$job_id)->get();
		}
		$to = $request->input('toemail');
		
		//$this->businessownernotification_mail($resultupdate,$candidate_mst,$business_owner,'FINALTEST_COMPLETION_NOTIFICATION');
		if (isset($job_res[0]->landing_page) && $job_res[0]->landing_page != '' && $job_res[0]->landing_page !== NULL) {
			$candidate_mst = Candidatemst::find($candidate_id);
			$this->sharejobmail('SHARE_FOUND_NEW_JOB',$job_res[0]->landing_page.'vie',$to,$candidate_mst);
		}
	
		//return view('Candidate::sample.index', ['business_logo' => $business_logo,'job_res'=>$job_res]);
        
	}
	
	public function sharejobmail($mail_title,$joblink,$to,$candidate_mst) {
		
		$mail = Mailmst::find($mail_title);
		$mail_data['subj'] = 	$mail->subject;
		$mail_data['from'] =$candidate_mst->email;
		//$mail_data['to'] =$to;
				
		$find = array('%JOB_LINK%');
		$replace = array($joblink);
		$message = str_replace($find,$replace, $mail->mail_content);
		$mail_data['content'] = $message;
		/*Mail::send(['html' => 'Candidate::emails.notification'], $mail_data, function ($message) use ($mail_data) {

				$message->from($mail_data['from'], 'IdealTraits.com');
			
				$message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
				//$message->to('ramkumar@sdi.la', 'ramkumar@sdi.la')->subject($subj);
				 
		});	*/
		$to_arr = explode(",", $to);
		 
		Mail::queue('Candidate::emails.notification', $mail_data, function ($message) use ($mail_data,$to_arr) {
		
			$message->from($mail_data['from'], 'IdealTraits.com');			
			
			foreach($to_arr as $to_email) {
				$to_email = trim($to_email);
				$message->to($to_email,$to_email )->subject($mail_data['subj']);			
				
			}
			 

		});

	}

	function substring_index($subject, $delim, $count){
		if($count < 0){
			return implode($delim, array_slice(explode($delim, $subject), $count));
		}else{
			return implode($delim, array_slice(explode($delim, $subject), 0, $count));
		}
	}

	

}



?>