<?php

namespace App\Modules\Candidate\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Collective\Html\Eloquent\FormAccessible;
use DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\Modules\Candidate\Models\Assessment;
use App\Modules\Candidate\Models\AssessmentSave;
use App\Modules\Candidate\Models\History;
use Illuminate\Support\Facades\Redirect;
use App\Modules\Candidate\Models\Mailmst;
use Mail;
use App\Modules\Candidate\Models\BusinessOwner;
use App\Modules\Candidate\Models\Result;
use App\Modules\Candidate\Models\Jobs;
use App\Modules\Candidate\Models\Candidatemst;
use App\Modules\Candidate\Models\Testmst;
use Illuminate\Support\Facades\URL;
use App\Modules\Candidate\Models\BusinessOwnerSubuser;
use App\Modules\Candidate\Models\Recruiter;



class AssessmentController extends Controller
{


	public function index(Request $request)
	{
        $currentURL = URL::full();
		//$current_page = Auth::user()->current_page;
		$current_page = str_replace("https://www.test","https://test",Auth::user()->current_page);

		if(strpos($currentURL,'page') && !strpos($currentURL,'backpage')){
		   if($current_page !=  $currentURL) {
				return Redirect::to($current_page);
		   } 
		}
		
		$assessments = Assessment::orderBy('pq_id')->paginate(4);

		$assessments_result = AssessmentSave::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id])->orderBy('pq_id')->get(['pq_id', 'most','least']);

		$testmst_data = Testmst::find(Auth::user()->test_id);

		return view('Candidate::assessment.index',["assessments" => $assessments,"assessments_result" => $assessments_result,"current_page" => $assessments->currentPage(), "testarr" => $testmst_data]);


	}


	public function save(Request $request)
	{
       

	
		$assessment_data = Input::all();

		foreach($assessment_data['pqid'] as $index => $pqid) {
		

		$most = $assessment_data['mst_radio'. $pqid];
		$least = $assessment_data['lst_radio'. $pqid];
		
		/*$assessment_save = new AssessmentSave;

		$assessment_save->candidate_id =  Auth::id();
		$assessment_save->pq_id =  $pqid;
		$assessment_save->most =  $most;
		$assessment_save->least =  $least;
		$assessment_save->test_id =  Auth::user()->test_id;*/

		AssessmentSave::where(['candidate_id' => Auth::id(),'test_id' => Auth::user()->test_id,"pq_id" => $pqid])->delete();
  
		//$assessment_update = AssessmentSave::where('candidate_id', Auth::id())->save($assessment_save);
		//if ($_SERVER['REMOTE_ADDR'] == '103.213.192.118'){
			$assessment_save_arr['candidate_id'] = Auth::id();
			$assessment_save_arr['pq_id'] = $pqid;
			$assessment_save_arr['test_id'] = Auth::user()->test_id;
			$assessment_save_arr['most'] = $most;
			$assessment_save_arr['least'] = $least;
			date_default_timezone_set('US/Eastern');
			$currentDate = Carbon::now();
			$assessment_save_arr['created_on'] = $currentDate;
			$asessment_update = AssessmentSave::updateOrCreate($assessment_save_arr);
		//}else{
			//$assessment_save->save();
		//}
		
		}
			if($assessment_data['nextpage']) {
				
				 $page_number_arr  =  explode('?',$assessment_data['nextpage']);
				 if($page_number_arr[1]){
					$page_num  = explode('=',$page_number_arr[1]);
					$pnumber   = $page_num[1] -1;
					if($pnumber == 1){
						History::maintainCandidateLog(12,'CANDIDATE_PQ_1');
					}else if($pnumber == 2){
						History::maintainCandidateLog(13,'CANDIDATE_PQ_2');
					}else if($pnumber == 3){
						History::maintainCandidateLog(14,'CANDIDATE_PQ_3');
					}else if($pnumber == 4){
						History::maintainCandidateLog(15,'CANDIDATE_PQ_4');
					}else if($pnumber == 5){
						History::maintainCandidateLog(16,'CANDIDATE_PQ_5');
					}else if($pnumber == 6){
						History::maintainCandidateLog(17,'CANDIDATE_PQ_6');
					}else if($pnumber == 7){
					    History::maintainCandidateLog(18,'CANDIDATE_PQ_7');
					}else if($pnumber == 8){
						History::maintainCandidateLog(19,'CANDIDATE_PQ_8');
					}
				 }
			
				$candidate_mst = Candidatemst::find(Auth::id());
				$candidate_mst->current_page = $assessment_data['nextpage'];
				$candidate_mst->save();

				return Redirect::to($assessment_data['nextpage']);		
			} else {
				History::maintainCandidateLog(8,'CANDIDATE_PQ');
				$test_id = Auth::user()->test_id;
				$candidate_id = Auth::id();
				$business_id = Auth::user()->business_id;
				$business_owner = BusinessOwner::find($business_id);
				$start_time  = $request->session()->get('start_test_time');
				$resultupdate = Result::calculateandsave($test_id,$candidate_id,$start_time);
		
				if($resultupdate) {
					$candidate_mst = Candidatemst::find($candidate_id);
					if($request->session()->get('completed.assessments') != '1'){
						
					  $this->businessownernotification_mail($resultupdate,$candidate_mst,$business_owner,'PARTIAL_RESULT');
					}
					$request->session()->put('completed.assessments', '1');

					
					if($candidate_mst['status'] != 'Hired' && $candidate_mst['status'] != 'Terminated') {
					$candidate_mst->status = 'Assessment';
					$candidate_mst->save();

					}

					//if ($_SERVER['REMOTE_ADDR'] == '103.213.192.118'){
						$candidate_mst = Candidatemst::find(Auth::id());
						if($candidate_mst->social_link == ''){


								 $URL='https://api.fullcontact.com/v2/person.json?email='.trim($candidate_mst->email).'&apiKey=9b00c00b6cbac02e';
								 

								 $ch = curl_init($URL);
		                         curl_setopt($ch, CURLOPT_TIMEOUT, 30); //timeout after 30 seconds
		                         curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
		                         curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
	                         	 $status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);   //get status code
	                         	  
		                         $result=curl_exec ($ch);
                                 $social_resp = $result;
		                         curl_close ($ch);

		                         $social_resp = json_decode($social_resp);
		                        if(isset($social_resp)){
	                         		if($social_resp->status == 200) {
		                            	$social_resp = json_encode($social_resp);
		                              	$candidate_mst->social_link =  $social_resp;
		                             	$candidate_mst->save();
		             

	                         		}else{
		                         		$candidate_mst->social_link = '{NODATA}';
		                        		$candidate_mst->save();
	                          		}
	                            }
		

						}
					  
						
					//}
					
				}


				$test_mst = Testmst::find(Auth::user()->test_id);

				if($test_mst->problem_solving == 1) {

					$candidate_mst = Candidatemst::find(Auth::id());
					$candidate_mst->current_page = "problemsolving/index";
					$candidate_mst->save();
					return Redirect::to("problemsolving/index");


				} else if($test_mst->short_answer == 1) {
					
					$candidate_mst = Candidatemst::find(Auth::id());
					$candidate_mst->current_page = "shortanswer/index";
					$candidate_mst->save();
					return Redirect::to("shortanswer/index");
				} else
					return Redirect::to("thankyou/index");


			}
	

	}
	
	public function businessownernotification_mail ($result,$candidate_mst,$business_owner,$mail_title) {
		$mail = Mailmst::find($mail_title); 
		$mail_data['subj'] = 	$mail->subject;
		$mail_data['from'] = 	$mail->from_id;
		$mail_data['to'] = $business_owner['username'];	
		 
		$notification_email = DB::table('business_email_notification')
				   ->select("TEST_COMPLETION_NOTIFICATION")
				   ->where('business_id', $business_owner->business_id)->first();

		$Jobnotification =  DB::table('job_notification')->select("TEST_COMPLETION_NOTIFICATION")->where('business_id',$candidate_mst->business_id)->where('job_id',$candidate_mst->job_id)->first();
		
		$mail_data['notification'] = [];
		if(isset($notification_email->TEST_COMPLETION_NOTIFICATION) && $notification_email->TEST_COMPLETION_NOTIFICATION != '' ){
		       $notification_arr = explode(",", $notification_email->TEST_COMPLETION_NOTIFICATION);
			   $mail_data['notification'] = $notification_arr;
				
		}

		$mail_data['jobnotification'] = [];
		if(isset($Jobnotification->TEST_COMPLETION_NOTIFICATION) && $Jobnotification->TEST_COMPLETION_NOTIFICATION != '' ){
		       $jobnotification_arr = explode(",", $Jobnotification->TEST_COMPLETION_NOTIFICATION);
			   $mail_data['jobnotification'] = $jobnotification_arr;
				
		}

		// $locbased_subuser = [];

		// if(isset($candidate_mst->location_id) && ($candidate_mst->location_id!='')){
		// 	$locbased_subuser = BusinessOwnerSubuser::where('business_id','=',$business_owner->business_id)
		// 						->where(function($query) use ($candidate_mst){
		// 							$query->whereNull('allowlocation_ids')
		// 							->orWhereRaw("FIND_IN_SET(?, allowlocation_ids)", [$candidate_mst->location_id]);
		// 						})
		// 						->pluck('username')->toArray();

		// 	if (!empty($locbased_subuser)) {
		// 		$mail_data['notification'] =  array_unique(array_merge($mail_data['notification'] , $locbased_subuser));
		// 	}
		// }

		$job_title	= '';
		if($candidate_mst->job_id != '') {	 
			$jobs = Jobs::find($candidate_mst->job_id);
			$job_title = 	$jobs->job_title;
		}	  

		$find = array('%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%USER_NAME%','%URL%','%PROFILE_OUTCOME%',"%JOB_APPLIED%","%Candidate_Link%","%PHONE%","%EMAIL%");
		
		if(isset($business_owner->current_package_id) && ($business_owner->current_package_id == '230' || $business_owner->current_package_id == '231' || $business_owner->current_package_id == '232'))  
			$replace = array($business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name,$candidate_mst->username,url('/'),$result['profile_result'],$job_title,config('constants.appbase_path').'candidate/'.$candidate_mst->candidate_id.'?united=1',$candidate_mst->phone_no,$candidate_mst->email);
		else
			$replace = array($business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name,$candidate_mst->username,url('/'),$result['profile_result'],$job_title,config('constants.appbase_path').'candidate/'.$candidate_mst->candidate_id,$candidate_mst->phone_no,$candidate_mst->email);
			
		$message = str_replace($find,$replace, $mail->mail_content);
		if(isset($business_owner->current_package_id) && ($business_owner->current_package_id == '230' || $business_owner->current_package_id == '231' || $business_owner->current_package_id == '232'))  
				$message = str_replace('https://mcusercontent.com/d4f46a2186022625deb05bef3/images/8f356cce-c0a5-139f-55df-9fb7d75d8005.png', 'https://app.idealtraits.com/assets/media/logos/UG_byIT_Logo.png' , $message);	 
		$mail_data['content'] = $message;
		$original = $mail_data['content'];

		// Job Notification
		if (!empty($mail_data['jobnotification']) && is_array($mail_data['jobnotification'])) {
			foreach($mail_data['jobnotification'] as $to_email) {
				
				$to_email = trim($to_email);
				
				$mail_data['content'] = $original;
				$message = $original;
				
				Mail::send(['html' => 'Candidate::emails.notification'], $mail_data, function ($mess) use ($mail_data, $Jobnotification,$to_email) {

					$mess->from($mail_data['from'], 'IdealTraits.com');
					if(isset($Jobnotification)){
					if($Jobnotification->TEST_COMPLETION_NOTIFICATION != ''){
						$mess->to($to_email,$to_email )->subject($mail_data['subj']);					  
					}
					}else{
						$mess->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
					}

				});
			}
		}

		foreach($mail_data['notification'] as $to_email) {
			
			$to_email = trim($to_email);
			$subuser = BusinessOwnerSubuser::Where('username','=',$to_email)->first();
			if (!empty($subuser)) {
				$find = array('%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%USER_NAME%','%URL%','%PROFILE_OUTCOME%',"%JOB_APPLIED%","%Candidate_Link%","%PHONE%","%EMAIL%");
				if(isset($business_owner->current_package_id) && ($business_owner->current_package_id == '230' || $business_owner->current_package_id == '231' || $business_owner->current_package_id == '232'))  
					$replace = array($subuser->first_name,$candidate_mst->first_name,$candidate_mst->last_name,$candidate_mst->username,url('/'),$result['profile_result'],$job_title,config('constants.appbase_path').'candidate/'.$candidate_mst->candidate_id.'?united=1',$candidate_mst->phone_no,$candidate_mst->email);
				else
				   $replace = array($subuser->first_name,$candidate_mst->first_name,$candidate_mst->last_name,$candidate_mst->username,url('/'),$result['profile_result'],$job_title,config('constants.appbase_path').'candidate/'.$candidate_mst->candidate_id,$candidate_mst->phone_no,$candidate_mst->email);
				$message1 = str_replace($find,$replace, $mail->mail_content);
				if(isset($business_owner->current_package_id) && ($business_owner->current_package_id == '230' || $business_owner->current_package_id == '231' || $business_owner->current_package_id == '232'))  
					$message1 = str_replace('https://mcusercontent.com/d4f46a2186022625deb05bef3/images/8f356cce-c0a5-139f-55df-9fb7d75d8005.png', 'https://app.idealtraits.com/assets/media/logos/UG_byIT_Logo.png' , $message1);	 
			
				
			
				$mail_data['content'] = $message1;
				$message = $message1;				
			} else {
				$mail_data['content'] = $original;
				$message = $original;
			} 


			$subuser_email = 0;
			if(isset($candidate_mst->location_id) && ($candidate_mst->location_id!='')){
				$subuser_email = BusinessOwnerSubuser::where('business_id','=',$business_owner->business_id)
							->where('username',trim($to_email))
							->where(function($query) use ($candidate_mst) {
								$query->whereNull('allowlocation_ids')
									  ->orWhere(function($query) use ($candidate_mst) {
										  $query->whereRaw("FIND_IN_SET(?, allowlocation_ids)", [$candidate_mst->location_id]);
									  });
							})
							->count();
			}

			if($subuser_email==0){
				$subuser_email = BusinessOwner::where('business_id','=',$business_owner->business_id)->where('username',trim($to_email))->count();
			}


			if($subuser_email>0){
				Mail::send(['html' => 'Candidate::emails.notification'], $mail_data, function ($mess) use ($mail_data, $notification_email,$to_email) {

					$mess->from($mail_data['from'], 'IdealTraits.com');
					if(isset($notification_email)){
					if($notification_email->TEST_COMPLETION_NOTIFICATION != ''){
						$mess->to($to_email,$to_email )->subject($mail_data['subj']);					  
					}
					}else{
						$mess->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
					}

				});
			}
		}

		// Recruiter mail functionality
		if($business_owner->recruiter_id!='' && $business_owner->recruiter_connectedon!=''){
			$recruiter = Recruiter::find($business_owner->recruiter_id);
			if($recruiter){
				$recruitermail = Mailmst::find('RECRUITER_PARTIAL_CANDIDATE_RESULTS');
				$recruitermail_data['subj'] = 	$recruitermail->subject;
				$recruitermail_data['from'] = 	$recruitermail->from_id;
				$recruitermail_data['to'] = $recruiter->username;
				$recruiter_name = $recruiter->first_name.' '.$recruiter->last_name;

				if($recruitermail->mail_active == 'Y'){

					$recruiternotification_email = DB::table('recruiter_notifi_setting')->select("part_result")->where('business_id', $business_owner->business_id)->where('recruiter_id', $business_owner->recruiter_id)->first();
					$recruitermail_data['notification'] = [];
					if(isset($recruiternotification_email->part_result) && $recruiternotification_email->part_result != '' ){
						$recruiternotification_arr = explode(",", $recruiternotification_email->part_result);
						$recruitermail_data['notification'] = $recruiternotification_arr;
					}
					
					$recruiterfind = array('%COMPANY_NAME%','%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%USER_NAME%','%URL%','%PROFILE_OUTCOME%',"%JOB_APPLIED%",'%Candidate_Link%','%PHONE%','%EMAIL%','%RECRUITER_NAME%');

					$recruiterreplace = array($business_owner->business_name,$business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name,$candidate_mst->username,url('/'),$result['profile_result'],$job_title,config('constants.recruiter_path').'recruiter/viewjobappliedcand/'.$business_owner->business_id.'/'.$candidate_mst->candidate_id,$candidate_mst->phone_no,$candidate_mst->email,$recruiter_name);
					
					$recruitermessage = str_replace($recruiterfind,$recruiterreplace, $recruitermail->mail_content);

					$recruitermail_data['content'] = $recruitermessage;
					$path=config('constants.recruiter_path');
					$original = $recruitermail_data['content'];
					foreach($recruitermail_data['notification'] as $to_email) {
						$to_email = trim($to_email);
						//subrecruiter notify will come here
						$recruitermail_data['content'] = $original;

						Mail::send(['html' => 'Candidate::emails.notification'], $recruitermail_data, function ($recruitermessage) use ($recruitermail_data, $recruiternotification_email,$to_email) {
							$recruitermessage->from($recruitermail_data['from'], 'IdealTraits.com');
							if(isset($recruiternotification_email)){
								if($recruiternotification_email->part_result != ''){
									$recruitermessage->to($to_email,$to_email )->subject($recruitermail_data['subj']);					  
								}
							}else{
								$recruitermessage->to($recruitermail_data['to'], $recruitermail_data['to'])->subject($recruitermail_data['subj']);
							}
						});
					}
				}
			}
			
		}
		
	}


	/*public function businessownernotification_mail ($result,$candidate_mst,$business_owner,$mail_title) {

      
      $mail = Mailmst::find($mail_title); 
	  $mail_data['subj'] = 	$mail->subject;
	  $mail_data['from'] = 	$mail->from_id;
	  $mail_data['to'] = $business_owner['username'];

	
		 
		  $notification_email = DB::table('business_email_notification')
				   ->select("TEST_COMPLETION_NOTIFICATION")
				   ->where('business_id', $business_owner->business_id)->first();
		
		
    if(isset($notification_email->TEST_COMPLETION_NOTIFICATION) && $notification_email->TEST_COMPLETION_NOTIFICATION != '' ){
		       $notification_arr = explode(",", $notification_email->TEST_COMPLETION_NOTIFICATION);
				$mail_data['notification'] = $notification_arr;
				
     }

	 $job_title	= '';
	  if($candidate_mst->job_id != '') {	 
	  $jobs = Jobs::find($candidate_mst->job_id);
	  $job_title = 	$jobs->job_title;
	  }
	  
	  

	  $find = array('%BUSINESS_OWNER_NAME%','%FIRST_NAME%','%LAST_NAME%','%USER_NAME%','%URL%','%PROFILE_OUTCOME%',"%JOB_APPLIED%","%Candidate_Link%");
      $replace = array($business_owner->first_name,$candidate_mst->first_name,$candidate_mst->last_name,$candidate_mst->username,url('/'),$result['profile_result'],$job_title,config('constants.appbase_path').'candidate/'.$candidate_mst->candidate_id);
	  $message = str_replace($find,$replace, $mail->mail_content);
	  $mail_data['content'] = $message;
	  Mail::send(['html' => 'Candidate::emails.notification'], $mail_data, function ($message) use ($mail_data, $notification_email) {

			$message->from($mail_data['from'], 'IdealTraits.com');
			if(isset($notification_email)){
			   if($notification_email->TEST_COMPLETION_NOTIFICATION != ''){
				foreach($mail_data['notification'] as $to_email) {
					$message->to($to_email,$to_email )->subject($mail_data['subj']);
				}
			   }
			}else{
			       $message->to($mail_data['to'], $mail_data['to'])->subject($mail_data['subj']);
				
			 }

		});


	}*/


	public function sample()
	{

		return view('Candidate::assessment.sample');


	}


}



?>